CREATE TABLE {table_prefix}QM_AI_CONVERSATION
(
    CONVERSATION_ID         VARCHAR(36) NOT NULL,
    DATASOURCE_ID           VARCHAR(100),
    USER_ID                 BIGINT NOT NULL,
    CAPTION                 VARCHAR(100) NOT NULL,
    CONTEXT_JSON            TEXT,
    LAST_MESSAGE_AT         TIMESTAMP,
    NEXT_MESSAGE_ID         INTEGER NOT NULL,
    IS_DELETED              CHAR(1) NOT NULL,
    PRIMARY KEY (CONVERSATION_ID)
);

CREATE INDEX IDX_QM_AI_CONVERSATION_USER ON {table_prefix}QM_AI_CONVERSATION(USER_ID);

CREATE TABLE {table_prefix}QM_AI_CONVERSATION_MESSAGE
(
    CONVERSATION_ID     VARCHAR(36) NOT NULL,
    MESSAGE_ID          INTEGER NOT NULL,
    MESSAGE_ROLE        VARCHAR(16) NOT NULL,
    CONTENT             CLOB NOT NULL,
    DISPLAY_MESSAGE     TEXT,
    IS_DELETED          CHAR(1) NOT NULL,
    SENT_AT             TIMESTAMP NOT NULL,
    PRIMARY KEY (CONVERSATION_ID, MESSAGE_ID),
    FOREIGN KEY (CONVERSATION_ID) REFERENCES {table_prefix}QM_AI_CONVERSATION (CONVERSATION_ID)
);

CREATE TABLE {table_prefix}QM_AI_CONTEXT_HISTORY
(
    CONVERSATION_ID      VARCHAR(36) NOT NULL,
    OBJECT_NAME          VARCHAR(128) NOT NULL,
    OBJECT_TYPE          VARCHAR(16) NOT NULL,
    PRIMARY KEY (CONVERSATION_ID, OBJECT_NAME, OBJECT_TYPE),
    FOREIGN KEY (CONVERSATION_ID) REFERENCES {table_prefix}QM_AI_CONVERSATION (CONVERSATION_ID)
);
