/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.databricks.model.auth;

import com.dbeaver.db.databricks.model.DatabricksUtils;
import com.dbeaver.db.databricks.model.auth.DatabricksM2MAuthCredentials;
import java.util.Map;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DatabricksM2MAuthModel
implements DBAAuthModel<DatabricksM2MAuthCredentials> {
    @NotNull
    public DatabricksM2MAuthCredentials createCredentials() {
        return new DatabricksM2MAuthCredentials();
    }

    @NotNull
    public DatabricksM2MAuthCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        DatabricksM2MAuthCredentials credentials = this.createCredentials();
        credentials.setHttpPath(configuration.getAuthProperty("httpPath"));
        credentials.setClientId(configuration.getAuthProperty("OAuth2ClientId"));
        credentials.setClientSecret(configuration.getAuthProperty("OAuth2Secret"));
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull DatabricksM2MAuthCredentials credentials) {
        configuration.setAuthProperty("httpPath", credentials.getHttpPath());
        configuration.setAuthProperty("OAuth2ClientId", credentials.getClientId());
        configuration.setAuthProperty("OAuth2Secret", credentials.getClientSecret());
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull DatabricksM2MAuthCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties props) {
        Map<String, String> urlParams = DatabricksUtils.extractUrlParameters(configuration);
        DatabricksUtils.setPropIfNotSet(props, urlParams, "transportMode", "http");
        DatabricksUtils.setPropIfNotSet(props, urlParams, "ssl", "1");
        DatabricksUtils.setPropIfNotSet(props, urlParams, "AuthMech", "11");
        DatabricksUtils.setPropIfNotSet(props, urlParams, "Auth_Flow", "1");
        String clientId = credentials.getClientId();
        String clientSecret = credentials.getClientSecret();
        String httpPath = credentials.getHttpPath();
        DatabricksUtils.setPropIfNotSet(props, urlParams, "httpPath", httpPath);
        DatabricksUtils.setPropIfNotSet(props, urlParams, "OAuth2ClientId", clientId);
        DatabricksUtils.setPropIfNotSet(props, urlParams, "OAuth2Secret", clientSecret);
        return credentials;
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
    }

    public void refreshCredentials(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull DatabricksM2MAuthCredentials credentials) {
    }
}

