/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.security.asn1;

import com.sybase.jdbc4.security.asn1.ASN1Object;
import com.sybase.jdbc4.security.asn1.ASN1OctetString;
import com.sybase.jdbc4.security.asn1.ASN1TaggedObject;
import com.sybase.jdbc4.security.asn1.DERObject;
import com.sybase.jdbc4.security.asn1.DEROutputStream;
import java.io.IOException;

public class DERBoolean
extends ASN1Object {
    byte value;
    public static final DERBoolean FALSE = new DERBoolean(false);
    public static final DERBoolean TRUE = new DERBoolean(true);

    public static DERBoolean getInstance(Object object) {
        if (object == null || object instanceof DERBoolean) {
            return (DERBoolean)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERBoolean(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERBoolean.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERBoolean getInstance(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static DERBoolean getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERBoolean.getInstance(aSN1TaggedObject.getObject());
    }

    public DERBoolean(byte[] byArray) {
        this.value = byArray[0];
    }

    public DERBoolean(boolean bl) {
        this.value = (byte)(bl ? -1 : 0);
    }

    public boolean isTrue() {
        return this.value != 0;
    }

    @Override
    void encode(DEROutputStream dEROutputStream) throws IOException {
        byte[] byArray = new byte[]{this.value};
        dEROutputStream.writeEncoded(1, byArray);
    }

    @Override
    protected boolean asn1Equals(DERObject dERObject) {
        if (dERObject == null || !(dERObject instanceof DERBoolean)) {
            return false;
        }
        return this.value == ((DERBoolean)dERObject).value;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return this.value != 0 ? "TRUE" : "FALSE";
    }
}

