/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.SybCallableStatement;
import com.sybase.jdbc4.jdbc.SybProperty;
import com.sybase.jdbc4.jdbc.SybUrlProvider;
import com.sybase.jdbc4.jdbc.SybXAConnection;
import com.sybase.jdbc4.jdbc.SybXADataSource;
import com.sybase.jdbc4.jdbc.SybXAResource;
import com.sybase.jdbc4.jdbc.SybXid;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class SybXAResource11
extends SybXAResource {
    private static final int MAX_XIDS_TO_RETURN = 10;
    private static final String ISO_ENCODING = "ISO8859_1";
    private static final String RPC_POSTFIX = " ( ?, ?, ?, ?, ?, ?)}";
    private static final String COMMIT_RPC = "{?= call xaos_commit ( ?, ?, ?, ?, ?, ?)}";
    private static final String ROLLBACK_RPC = "{?= call xaos_rollback ( ?, ?, ?, ?, ?, ?)}";
    private static final String FORGET_RPC = "{?= call xaos_forget ( ?, ?, ?, ?, ?, ?)}";
    private static final String PREPARE_RPC = "{?= call xaos_prepare ( ?, ?, ?, ?, ?, ?)}";
    private static final String RECOVER_RPC = "{?= call xaos_recover ( ?, ?, ?)}";
    private static final String OPEN_RPC = "{?= call xaos_open ( ?, ?, ?)}";
    private static final String CLOSE_RPC = "{?= call xaos_close ( ?, ?, ?, ?)}";
    private static final String START_RPC = "{?= call xaos_start ( ?, ?, ?, ?, ?, ?)}";
    private static final String END_RPC = "{?= call xaos_end ( ?, ?, ?, ?, ?, ?)}";
    private static int _rmidGenerator = 1;
    private final int _rmid = _rmidGenerator++;

    protected SybXAResource11(String string, SybXAConnection sybXAConnection, SybXADataSource sybXADataSource, SybUrlProvider sybUrlProvider) {
        super(string, sybXAConnection, sybXADataSource, sybUrlProvider);
        this._transProtocolType = 65536;
        SybProperty sybProperty = sybUrlProvider.getSybProperty();
        SybCallableStatement sybCallableStatement = null;
        try {
            sybCallableStatement = (SybCallableStatement)this._xaConn.prepareInternalCall(OPEN_RPC);
            sybCallableStatement.registerOutParameter(1, 4);
            sybCallableStatement.setInt(2, this._rmid);
            sybCallableStatement.setParameterName(2, "@rmid");
            sybCallableStatement.setInt(3, 0);
            sybCallableStatement.setParameterName(3, "@flags");
            String string2 = sybProperty.getString(3);
            String string3 = sybProperty.getString(4);
            sybCallableStatement.setString(4, "-N" + this._resourceManagerID + " -U" + string2 + " -P" + string3);
            sybCallableStatement.setParameterName(4, "@info");
            sybCallableStatement.execute();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._localTransactionOK = false;
    }

    @Override
    public void start(Xid xid, int n) throws XAException {
        this.sendRPC(START_RPC, xid, n);
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        int n = bl ? 0x40000000 : 0;
        this.sendRPC(COMMIT_RPC, xid, n);
    }

    @Override
    public void end(Xid xid, int n) throws XAException {
        this.sendRPC(END_RPC, xid, n);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.sendRPC(FORGET_RPC, xid);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.sendRPC(PREPARE_RPC, xid);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.sendRPC(ROLLBACK_RPC, xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Xid[] recover(int n) throws XAException {
        Vector<Xid> vector;
        block15: {
            vector = new Vector<Xid>();
            SybCallableStatement sybCallableStatement = null;
            ResultSet resultSet = null;
            try {
                sybCallableStatement = (SybCallableStatement)this._xaConn.prepareInternalCall(RECOVER_RPC);
                sybCallableStatement.registerOutParameter(1, 4);
                sybCallableStatement.setInt(2, 10);
                sybCallableStatement.setParameterName(2, "@count");
                sybCallableStatement.setInt(3, this._rmid);
                sybCallableStatement.setParameterName(3, "@rmid");
                sybCallableStatement.setInt(4, n);
                sybCallableStatement.setParameterName(4, "@flags");
                resultSet = sybCallableStatement.executeQuery();
                while (resultSet.next()) {
                    vector.add(SybXAResource11.createXid(resultSet.getInt(1), resultSet.getInt(2), resultSet.getInt(3), resultSet.getString(4)));
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("JZ0R2")) {
                    break block15;
                }
                throw new XAException(-6);
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (sybCallableStatement != null) {
                        sybCallableStatement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        Object[] objectArray = new Xid[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    @Override
    protected void close() {
        SybCallableStatement sybCallableStatement = null;
        try {
            sybCallableStatement = (SybCallableStatement)this._xaConn.prepareInternalCall(CLOSE_RPC);
            sybCallableStatement.registerOutParameter(1, 4);
            sybCallableStatement.setInt(2, this._rmid);
            sybCallableStatement.setParameterName(2, "@rmid");
            sybCallableStatement.setInt(3, 0);
            sybCallableStatement.setParameterName(3, "@flags");
            sybCallableStatement.setString(4, null);
            sybCallableStatement.setParameterName(4, "@open_info");
            sybCallableStatement.setString(5, null);
            sybCallableStatement.setParameterName(5, "@close_info");
            sybCallableStatement.execute();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private final int sendRPC(String string, Xid xid) throws XAException {
        return this.sendRPC(string, xid, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int sendRPC(String string, Xid xid, int n) throws XAException {
        int n2;
        block17: {
            n2 = 0;
            SybCallableStatement sybCallableStatement = null;
            SQLException sQLException = null;
            try {
                sybCallableStatement = (SybCallableStatement)this._xaConn.prepareInternalCall(string);
                sybCallableStatement.registerOutParameter(1, 4);
                sybCallableStatement.setInt(2, xid.getFormatId());
                sybCallableStatement.setParameterName(2, "@xid_format");
                byte[] byArray = xid.getGlobalTransactionId();
                sybCallableStatement.setInt(3, byArray.length);
                sybCallableStatement.setParameterName(3, "@xid_gtrid");
                byte[] byArray2 = xid.getBranchQualifier();
                sybCallableStatement.setInt(4, byArray2.length);
                sybCallableStatement.setParameterName(4, "@xid_bqual");
                byte[] byArray3 = new byte[byArray.length + byArray2.length];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                String string2 = null;
                try {
                    string2 = new String(byArray3, ISO_ENCODING);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new XAException(-4);
                }
                sybCallableStatement.setString(5, string2);
                sybCallableStatement.setParameterName(5, "@xid_data");
                sybCallableStatement.setInt(6, this._rmid);
                sybCallableStatement.setParameterName(6, "@rmid");
                sybCallableStatement.setInt(7, n);
                sybCallableStatement.setParameterName(7, "@flags");
                sybCallableStatement.execute();
                n2 = sybCallableStatement.getInt(1);
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                return (int)sQLException;
            }
            finally {
                block18: {
                    try {
                        if (sybCallableStatement != null) {
                            sybCallableStatement.close();
                        }
                    }
                    catch (SQLException sQLException3) {
                    }
                    catch (Exception exception) {
                        if (sQLException == null) break block18;
                        throw new XAException(-6);
                    }
                }
                if (sQLException == null) break block17;
                throw new XAException(-6);
            }
        }
        this.verifyReturnCode(n2);
        return n2;
    }

    protected void verifyReturnCode(int n) throws XAException {
        if (n != 0) {
            throw new XAException(n);
        }
    }

    private static final Xid createXid(int n, int n2, int n3, String string) throws XAException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            byArray = string.substring(0, n2).getBytes(ISO_ENCODING);
            byArray2 = string.substring(n2, n2 + n3).getBytes(ISO_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XAException(-4);
        }
        return new SybXid(n, byArray, byArray2);
    }
}

