/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui.wizard.tree;

import com.dbeaver.ee.scmp.impl.liquibase.LBUtils;
import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.model.CMPResult;
import com.dbeaver.ee.scmp.model.CMPResultChangeItem;
import com.dbeaver.ee.scmp.model.ResultObjectInfo;
import com.dbeaver.ee.scmp.ui.wizard.DiffRendererBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.themes.ITheme;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class DiffRendererTree
extends DiffRendererBase {
    private static final Log log = Log.getLog(DiffRendererTree.class);
    private Color colorCreate;
    private Color colorDelete;
    private Color colorUpdate;
    private Tree changesTree;

    @Override
    public void createControl(Composite parent) {
        this.changesTree = new Tree(parent, 67616);
        TreeColumn nameColumn = new TreeColumn(this.changesTree, 16384);
        nameColumn.setText("Name");
        TreeColumn actionColumn = new TreeColumn(this.changesTree, 16384);
        actionColumn.setText("Change");
        this.changesTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    Object itemData = e.item.getData();
                    CMPResultChangeItem changeItem = null;
                    if (itemData instanceof CMPResultChangeItem) {
                        changeItem = (CMPResultChangeItem)itemData;
                    } else if (itemData instanceof ResultObjectInfo) {
                        changeItem = ((ResultObjectInfo)itemData).getObjectItem();
                    }
                    if (changeItem != null) {
                        changeItem.setEnabled(((TreeItem)e.item).getChecked());
                        Event event = new Event();
                        event.data = itemData;
                        DiffRendererTree.this.fireChangesEvent(event);
                    } else {
                        e.doit = false;
                    }
                } else {
                    ArrayList<CMPResultChangeItem> selectedItems = new ArrayList<CMPResultChangeItem>();
                    TreeItem[] treeItemArray = DiffRendererTree.this.changesTree.getSelection();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        Object itemData = item.getData();
                        if (itemData instanceof CMPResultChangeItem) {
                            selectedItems.add((CMPResultChangeItem)itemData);
                        } else if (itemData instanceof ResultObjectInfo) {
                            if (((ResultObjectInfo)itemData).getObjectItem() != null) {
                                selectedItems.add(((ResultObjectInfo)itemData).getObjectItem());
                            }
                            selectedItems.addAll(((ResultObjectInfo)itemData).getInnerChanges());
                        }
                        ++n2;
                    }
                    StructuredSelection selection = new StructuredSelection(selectedItems.toArray());
                    DiffRendererTree.this.fireSelectionChangedEvent((IStructuredSelection)selection);
                }
            }
        });
        this.applyThemeSettings();
    }

    private void applyThemeSettings() {
        ITheme currentTheme = UIUtils.getCurrentTheme();
        this.colorCreate = currentTheme.getColorRegistry().get("com.dbeaver.scmp.diff.color.create");
        this.colorDelete = currentTheme.getColorRegistry().get("com.dbeaver.scmp.diff.color.delete");
        this.colorUpdate = currentTheme.getColorRegistry().get("com.dbeaver.scmp.diff.color.update");
    }

    @Override
    public void populateChanges(CMPOptions options, CMPResult result) {
        Map containerMap = LBUtils.getChangedItemsMap((CMPResult)result);
        for (Map.Entry containerEntry : containerMap.entrySet()) {
            TreeItem containerItem = new TreeItem(this.changesTree, 16384);
            containerItem.setImage(0, DBeaverIcons.getImage((DBPImage)DBIcon.TREE_SCHEMA));
            containerItem.setText(0, (String)containerEntry.getKey());
            containerItem.setChecked(true);
            containerItem.setGrayed(true);
            containerItem.setData(containerEntry);
            for (ResultObjectInfo objectInfo : (List)containerEntry.getValue()) {
                TreeItem objectItem = new TreeItem(containerItem, 16384);
                objectItem.setImage(0, DBeaverIcons.getImage((DBPImage)objectInfo.getObjectType().getImage()));
                objectItem.setText(0, objectInfo.getObjectName());
                objectItem.setText(1, objectInfo.getActionName());
                objectItem.setChecked(objectInfo.isEnabled());
                objectItem.setData((Object)objectInfo);
                objectItem.setForeground(this.getChangeColor(objectInfo));
                if (CommonUtils.isEmpty((Collection)objectInfo.getInnerChanges())) continue;
                for (CMPResultChangeItem innerChange : objectInfo.getInnerChanges()) {
                    TreeItem innerItem = new TreeItem(objectItem, 16384);
                    innerItem.setImage(0, DBeaverIcons.getImage((DBPImage)innerChange.getObjectType().getImage()));
                    innerItem.setText(0, innerChange.getInnerName());
                    innerItem.setText(1, innerChange.getChangeType().getTitle() + " " + innerChange.getObjectType().getTypeName());
                    innerItem.setChecked(objectInfo.isEnabled());
                    innerItem.setForeground(this.getChangeColor(innerChange));
                    innerItem.setData((Object)innerChange);
                }
            }
            containerItem.setExpanded(true);
        }
        UIUtils.asyncExec(() -> UIUtils.packColumns((Tree)this.changesTree, (boolean)true, null));
    }

    @Override
    public void selectAllItems(boolean check) {
        TreeItem[] treeItemArray = this.changesTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.selectAllItems(item, check);
            ++n2;
        }
    }

    private void selectAllItems(TreeItem item, boolean check) {
        CMPResultChangeItem objectItem;
        item.setChecked(check);
        Object itemData = item.getData();
        if (itemData instanceof CMPResultChangeItem) {
            ((CMPResultChangeItem)itemData).setEnabled(check);
        } else if (itemData instanceof ResultObjectInfo && (objectItem = ((ResultObjectInfo)itemData).getObjectItem()) != null) {
            objectItem.setEnabled(check);
        }
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            this.selectAllItems(child, check);
            ++n2;
        }
    }

    private Color getChangeColor(ResultObjectInfo objectInfo) {
        if (objectInfo.getObjectItem() == null) {
            return this.colorUpdate;
        }
        return this.getChangeColor(objectInfo.getObjectItem());
    }

    private Color getChangeColor(CMPResultChangeItem item) {
        switch (item.getChangeType()) {
            case CREATE: {
                return this.colorCreate;
            }
            case DROP: {
                return this.colorDelete;
            }
        }
        return this.colorUpdate;
    }
}

