/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.utils;

import java.nio.file.NoSuchFileException;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Function;
import org.jkiss.code.NotNull;
import org.jkiss.utils.CommonUtils;

public final class FFExceptionUtils {
    private FFExceptionUtils() {
    }

    @NotNull
    public static SQLException wrapException(@NotNull Exception e) {
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        if (e instanceof NoSuchFileException) {
            return new SQLException("File not found: " + e.getMessage());
        }
        return new SQLException(e.getMessage(), e);
    }

    @NotNull
    public static <E extends Exception> E combine(@NotNull Function<String, E> factory, @NotNull String errorMessage, @NotNull List<? extends Exception> errors) {
        StringBuilder extraMessages = new StringBuilder();
        for (Exception exception : errors) {
            String message = exception.getMessage();
            if (CommonUtils.isEmpty((String)message)) continue;
            if (!extraMessages.isEmpty()) {
                extraMessages.append("\n");
            }
            extraMessages.append(exception.getClass().getSimpleName()).append(": ").append(message);
        }
        if (!extraMessages.isEmpty()) {
            errorMessage = (String)errorMessage + "\n" + String.valueOf(extraMessages);
        }
        Exception exception = (Exception)factory.apply((String)errorMessage);
        for (Exception exception2 : errors) {
            exception.addSuppressed(exception2);
        }
        return (E)exception;
    }
}

