/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.engine.sqlite;

import com.dbeaver.jdbc.files.FFStatementFactory;
import com.dbeaver.jdbc.files.api.FFConnection;
import com.dbeaver.jdbc.files.engine.file.FileStatementFactory;
import com.dbeaver.jdbc.files.engine.sqlite.SQLiteConnectionProvider;
import com.dbeaver.jdbc.files.engine.sqlite.SQLiteProxyPreparedStatement;
import com.dbeaver.jdbc.files.engine.sqlite.SQLiteProxyStatement;
import com.dbeaver.jdbc.files.engine.sqlite.SQLiteTableManager;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import org.jkiss.code.NotNull;

public class SQLiteStatementFactory
implements FFStatementFactory {
    private final SQLiteTableManager tableManager;
    private final SQLiteConnectionProvider sqLiteConnectionProvider;
    private final FileStatementFactory fileStatementFactory;

    public SQLiteStatementFactory(SQLiteTableManager tableManager, SQLiteConnectionProvider sqLiteConnectionProvider, FileStatementFactory fileStatementFactory) {
        this.tableManager = tableManager;
        this.sqLiteConnectionProvider = sqLiteConnectionProvider;
        this.fileStatementFactory = fileStatementFactory;
    }

    @NotNull
    public SQLiteProxyStatement createStatement(@NotNull FFConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Only TYPE_FORWARD_ONLY result set type is supported");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Only CONCUR_READ_ONLY result set concurrency is supported");
        }
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException("Only CLOSE_CURSORS_AT_COMMIT result set holdability is supported");
        }
        Statement statement = this.sqLiteConnectionProvider.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return new SQLiteProxyStatement(this.tableManager, connection, statement, this.fileStatementFactory.createStatement(connection, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @NotNull
    public SQLiteProxyPreparedStatement prepareStatement(@NotNull FFConnection connection, @NotNull String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Only TYPE_FORWARD_ONLY result set type is supported");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Only CONCUR_READ_ONLY result set concurrency is supported");
        }
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException("Only CLOSE_CURSORS_AT_COMMIT result set holdability is supported");
        }
        Statement statement = this.sqLiteConnectionProvider.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return new SQLiteProxyPreparedStatement(this.tableManager, connection, statement, this.fileStatementFactory.createStatement(connection, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    @Override
    @NotNull
    public CallableStatement prepareCall(@NotNull FFConnection connection, @NotNull String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Callable statements are not supported");
    }
}

