/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.engine.sqlite;

import com.dbeaver.jdbc.base.BaseJdbcUtils;
import com.dbeaver.jdbc.files.FFSQLiteDriverInstanceProvider;
import com.dbeaver.jdbc.files.api.FFProperties;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.jkiss.api.CompositeObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.utils.IOUtils;

public class SQLiteConnectionProvider {
    private static final Logger log = Logger.getLogger(SQLiteConnectionProvider.class.getName());
    @NotNull
    private final FFProperties properties;
    @NotNull
    private final CompletableFuture<Void> connectionClosedFuture;
    private final CompletableFuture<Void> sqliteConnectionClosedFuture = new CompletableFuture();
    private volatile Connection connection;
    private volatile Path databaseDir;

    public SQLiteConnectionProvider(@NotNull FFProperties properties, @NotNull CompletableFuture<Void> connectionClosedFuture) {
        this.properties = properties;
        this.connectionClosedFuture = connectionClosedFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        if (this.connection != null) {
            return this.connection;
        }
        SQLiteConnectionProvider sQLiteConnectionProvider = this;
        synchronized (sQLiteConnectionProvider) {
            if (this.connection != null) {
                return this.connection;
            }
            this.connection = this.createSQLiteConnection();
            return this.connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getDatabaseDir() throws IOException {
        if (this.databaseDir != null) {
            return this.databaseDir;
        }
        SQLiteConnectionProvider sQLiteConnectionProvider = this;
        synchronized (sQLiteConnectionProvider) {
            if (this.databaseDir != null) {
                return this.databaseDir;
            }
            try {
                this.databaseDir = this.getInternalDatabaseDir();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to get database directory: " + e.getMessage(), e);
            }
            return this.databaseDir;
        }
    }

    @NotNull
    private Connection createSQLiteConnection() throws SQLException {
        Driver driver = BaseJdbcUtils.getDriverInstance((CompositeObjectId)FFSQLiteDriverInstanceProvider.SQLITE_DRIVER_REFERENCE);
        if (driver == null) {
            throw new SQLException("SQLite driver is not found");
        }
        try {
            Path databaseDir = this.getDatabaseDir();
            log.info("Creating SQLite database at " + String.valueOf(databaseDir));
            Connection connection = driver.connect("jdbc:sqlite:" + String.valueOf(databaseDir.resolve("table_manager.db")), new Properties());
            connection.setAutoCommit(false);
            this.connectionClosedFuture.whenComplete((ignored, throwable) -> {
                try {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        log.warning("Failed to close SQLite connection: " + e.getMessage());
                        this.sqliteConnectionClosedFuture.complete(null);
                    }
                }
                finally {
                    this.sqliteConnectionClosedFuture.complete(null);
                }
            });
            return connection;
        }
        catch (IOException e) {
            throw new SQLException("Failed to create SQLite database: " + e.getMessage(), e);
        }
    }

    private Path getInternalDatabaseDir() throws IOException {
        Path databaseDir = this.properties.internalDatabaseDir();
        if (databaseDir != null) {
            Files.createDirectories(databaseDir, new FileAttribute[0]);
            return databaseDir;
        }
        Path tempDirectory = Files.createTempDirectory("dbeaver-ff", new FileAttribute[0]);
        this.sqliteConnectionClosedFuture.whenComplete((ignored, throwable) -> {
            try {
                IOUtils.deleteDirectory((Path)tempDirectory);
            }
            catch (IOException e) {
                log.warning("Failed to delete temporary directory: " + e.getMessage());
            }
        });
        return tempDirectory;
    }
}

