/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.engine.file;

import com.dbeaver.jdbc.base.CachedJdbcResultSet;
import com.dbeaver.jdbc.base.CachedJdbcResultSetMetaData;
import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.files.FFTableReader;
import com.dbeaver.jdbc.files.api.FFConnection;
import com.dbeaver.jdbc.files.api.FFJdbcResultSetMetaData;
import com.dbeaver.jdbc.files.api.FFResultSet;
import com.dbeaver.jdbc.files.api.FFStatement;
import com.dbeaver.jdbc.files.database.FFDatabase;
import com.dbeaver.jdbc.files.database.FFTable;
import com.dbeaver.jdbc.files.database.FFTableName;
import com.dbeaver.jdbc.files.engine.FFQueryAnalysisResult;
import com.dbeaver.jdbc.files.engine.FFQueryType;
import java.io.IOException;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class FileStatement
extends FFStatement {
    FileStatement(@NotNull FFConnection connection) throws SQLException {
        super(connection);
    }

    @Override
    protected ResultSet execute0(@Nullable int[] columnIndexes, @Nullable String[] columnNames, int autoGeneratedKeys, @NotNull FFQueryAnalysisResult analysisResult) throws SQLException {
        this.ensureOpen();
        FFTableName tableName = (FFTableName)analysisResult.tables().stream().findFirst().orElseThrow(() -> new SQLException("No table found in query"));
        FFDatabase database = ((FFConnection)this.connection).getDatabase();
        FFTable<?, ?> table = database.table(tableName);
        try {
            return switch (analysisResult.queryType()) {
                case FFQueryType.ALL_ROWS -> this.executeSelectAll(table);
                case FFQueryType.ROW_COUNT -> {
                    Select statement = (Select)analysisResult.statement();
                    yield this.executeSelectCount(table, statement.getPlainSelect());
                }
                default -> throw new SQLFeatureNotSupportedException("Query type not supported: " + String.valueOf((Object)analysisResult.queryType()));
            };
        }
        catch (IOException e) {
            throw new SQLException("Failed to execute query", e);
        }
    }

    private ResultSet executeSelectCount(@NotNull FFTable<?, ?> table, @NotNull PlainSelect select) throws IOException {
        long count = 0L;
        Throwable throwable = null;
        Object var6_6 = null;
        try (FFTableReader<?> reader = table.reader();){
            while (reader.readRow() != null) {
                ++count;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String columnName = FileStatement.getSelectItemName((SelectItem)select.getSelectItems().get(0));
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(columnName, (SQLType)JDBCType.BIGINT, v -> v)};
        CachedJdbcResultSetMetaData resultSetMetaData = new CachedJdbcResultSetMetaData(null, columns);
        Object[] row = new Object[]{count};
        return new CachedJdbcResultSet(null, resultSetMetaData, row);
    }

    private ResultSet executeSelectAll(@NotNull FFTable<?, ?> table) throws IOException {
        FFTableReader<?> reader = table.reader();
        FFJdbcResultSetMetaData metadata = new FFJdbcResultSetMetaData(this, table.tableName(), table.structure().columns().toArray(new ColumnInfo[0]));
        return new FFResultSet(this, metadata, reader, this.maxRows);
    }

    @Override
    protected void onClose() throws SQLException {
    }

    @Override
    protected void onCancel() throws SQLException {
    }

    private static String getSelectItemName(SelectItem<?> selectItem) {
        if (selectItem.getAlias() != null) {
            return selectItem.getAlias().getName();
        }
        return selectItem.getExpression().toString();
    }
}

