/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.api;

import com.dbeaver.jdbc.base.BaseJdbcDriver;
import com.dbeaver.jdbc.files.FFDataSourceScanner;
import com.dbeaver.jdbc.files.FFDataSourceScannerFactory;
import com.dbeaver.jdbc.files.FFFileScannerFactory;
import com.dbeaver.jdbc.files.FFPropertiesFactory;
import com.dbeaver.jdbc.files.FFResult;
import com.dbeaver.jdbc.files.FFStatementFactory;
import com.dbeaver.jdbc.files.api.FFConnection;
import com.dbeaver.jdbc.files.api.FFDataSource;
import com.dbeaver.jdbc.files.api.FFDataSourceFormat;
import com.dbeaver.jdbc.files.api.FFDatabaseMetaData;
import com.dbeaver.jdbc.files.api.FFJdbcUrl;
import com.dbeaver.jdbc.files.api.FFProperties;
import com.dbeaver.jdbc.files.api.FFPropertyInfo;
import com.dbeaver.jdbc.files.database.FFDatabase;
import com.dbeaver.jdbc.files.database.FFSchema;
import com.dbeaver.jdbc.files.database.FFSchemaName;
import com.dbeaver.jdbc.files.database.FFTable;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import com.dbeaver.jdbc.files.engine.file.FileStatementFactory;
import com.dbeaver.jdbc.files.engine.sqlite.SQLiteConnectionProvider;
import com.dbeaver.jdbc.files.engine.sqlite.SQLiteStatementFactory;
import com.dbeaver.jdbc.files.engine.sqlite.SQLiteTableManager;
import com.dbeaver.jdbc.files.utils.FFExceptionUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jkiss.api.ObjectWithContextParameters;
import org.jkiss.api.verification.FileSystemAccessVerifyer;
import org.jkiss.api.verification.ObjectWithVerification;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public abstract class FFJdbcDriver<T, TP extends FFTableProperties, P extends FFProperties>
extends BaseJdbcDriver
implements ObjectWithVerification {
    private static final Logger log = Logger.getLogger(FFJdbcDriver.class.getName());
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    public static final List<Character> QUOTE_CHARS = List.of(Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf('`'));

    public FFJdbcDriver(@NotNull String driverUrlPrefix, int defaultVersionMajor, int defaultVersionMinor) {
        super(driverUrlPrefix, defaultVersionMajor, defaultVersionMinor);
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return (DriverPropertyInfo[])((FFProperties)this.getPropertiesFactory().createProperties(info)).propertyInfos().stream().sorted(Comparator.comparing(FFPropertyInfo::name)).map(FFPropertyInfo::toDriverPropertyInfo).toArray(DriverPropertyInfo[]::new);
    }

    @NotNull
    protected FFConnection connectImpl(@NotNull String url, @Nullable Properties info) throws SQLException {
        try {
            P driverProperties = this.getPropertiesFactory().createProperties(info != null ? info : new Properties());
            return this.connectImpl(url, driverProperties);
        }
        catch (Exception e) {
            throw FFExceptionUtils.wrapException(e);
        }
    }

    @NotNull
    protected FFConnection connectImpl(@NotNull String url, @NotNull P driverProperties) throws SQLException, IOException {
        FFJdbcUrl<P> connectionString = this.parseConnectionString(url, driverProperties);
        this.validateConnectionString(connectionString);
        CompletableFuture<Void> connectionClosedFuture = new CompletableFuture<Void>();
        FFResult<FFDatabase, Exception> result = this.scanDataSources(connectionString.dataSources(), connectionClosedFuture);
        FFDatabase database = result.result();
        List<Exception> scanningErrors = result.errors();
        if (database == null) {
            throw FFExceptionUtils.combine(SQLException::new, "Failed to scan data sources", scanningErrors);
        }
        List<FFSchemaName> schemas = database.schemas();
        FFSchemaName defaultSchema = schemas.stream().filter(schemaName -> schemaName.name().equalsIgnoreCase(driverProperties.defaultSchema())).findFirst().orElseGet(() -> schemas.isEmpty() ? null : (FFSchemaName)schemas.get(0));
        FFStatementFactory statementFactory = this.createStatementFactory((FFProperties)driverProperties, connectionClosedFuture);
        FFConnection ffConnection = new FFConnection(database, connection -> this.createDatabaseMetaData((FFConnection)((Object)connection), url, database), statementFactory, defaultSchema == null ? null : defaultSchema.name());
        scanningErrors.forEach(ffConnection::addWarning);
        ffConnection.getCloseFuture().whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                connectionClosedFuture.completeExceptionally((Throwable)throwable);
            } else {
                connectionClosedFuture.complete(null);
            }
        });
        return ffConnection;
    }

    @NotNull
    protected abstract FFDatabaseMetaData createDatabaseMetaData(@NotNull FFConnection var1, @NotNull String var2, @NotNull FFDatabase var3);

    @NotNull
    private FFStatementFactory createStatementFactory(@NotNull FFProperties properties, @NotNull CompletableFuture<Void> connectionClosedFuture) throws SQLException {
        if (properties.useInternalDatabase()) {
            SQLiteConnectionProvider sqLiteConnectionProvider = new SQLiteConnectionProvider(properties, connectionClosedFuture);
            SQLiteTableManager tableManager = new SQLiteTableManager(properties, sqLiteConnectionProvider);
            tableManager.init();
            return new SQLiteStatementFactory(tableManager, sqLiteConnectionProvider, new FileStatementFactory());
        }
        return new FileStatementFactory();
    }

    @NotNull
    private FFResult<FFDatabase, Exception> scanDataSources(@NotNull List<FFDataSource<P>> dataSources, @NotNull CompletableFuture<Void> connectionClosedFuture) {
        TreeMap<FFSchemaName, FFSchema> dbTree = new TreeMap<FFSchemaName, FFSchema>();
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (FFDataSource<P> dataSource : dataSources) {
            FFResult<List<FFTable<T, TP>>, Exception> result = this.scanDataSource(dataSource, connectionClosedFuture);
            for (FFTable<T, TP> table : Objects.requireNonNull(result.result())) {
                FFSchemaName schemaName = table.tableName().schema();
                FFSchema schema = dbTree.computeIfAbsent(schemaName, FFSchema::new);
                schema.addTable(table);
            }
            errors.addAll(result.errors());
        }
        if (dbTree.isEmpty() && !errors.isEmpty()) {
            return new FFResult(null, errors);
        }
        if (!errors.isEmpty()) {
            return new FFResult<FFDatabase, Exception>(new FFDatabase(dbTree), errors);
        }
        return new FFResult<FFDatabase, Exception>(new FFDatabase(dbTree), errors);
    }

    private FFResult<List<FFTable<T, TP>>, Exception> scanDataSource(@NotNull FFDataSource<P> dataSource, @NotNull CompletableFuture<Void> connectionClosedFuture) {
        try {
            FFDataSourceScannerFactory<T, TP, P> scannerFactory = this.getDataSourceScannerFactory();
            FFDataSourceScanner<T, TP, P> dataSourceScanner = scannerFactory.createDataSourceScanner(dataSource, connectionClosedFuture);
            return dataSourceScanner.scan(dataSource);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to scan data source [dataSource=" + String.valueOf(dataSource) + "]", e);
            return new FFResult<List<FFTable<T, TP>>, Exception>(List.of(), List.of(e));
        }
    }

    @NotNull
    private FFJdbcUrl<P> parseConnectionString(@NotNull String url, @NotNull P properties) throws IOException {
        return FFJdbcUrl.parse((ObjectWithContextParameters)this, this.getDriverUrlPrefix(), url, properties, this.getPropertiesFactory());
    }

    private void validateConnectionString(FFJdbcUrl<P> jdbcUrl) throws SQLException {
        try {
            for (FFDataSource<P> dataSource : jdbcUrl.dataSources()) {
                this.validateFileReadAccess(dataSource);
            }
        }
        catch (IOException e) {
            throw new SQLException("Failed to validate connection string", e);
        }
    }

    private void validateFileReadAccess(@NotNull FFDataSource<P> dataSource) throws IOException {
        Path sourcePath;
        FileSystemAccessVerifyer accessVerifier;
        Object object = this.getObjectContextParameter("fs.verifier");
        if (object instanceof FileSystemAccessVerifyer && !(accessVerifier = (FileSystemAccessVerifyer)object).isPathReadAllowed(sourcePath = dataSource.path())) {
            throw new IOException("Access denied for path: " + String.valueOf(sourcePath));
        }
    }

    @NotNull
    public abstract FFDataSourceFormat getSupportedDataSourceFormat();

    @NotNull
    public abstract FFFileScannerFactory<T, TP, P> getFileScannerFactory();

    @NotNull
    public abstract FFDataSourceScannerFactory<T, TP, P> getDataSourceScannerFactory();

    @NotNull
    public abstract FFPropertiesFactory<P> getPropertiesFactory();
}

