/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresql.models.CreateMode;
import com.azure.resourcemanager.postgresql.models.InfrastructureEncryption;
import com.azure.resourcemanager.postgresql.models.MinimalTlsVersionEnum;
import com.azure.resourcemanager.postgresql.models.PublicNetworkAccessEnum;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForCreate;
import com.azure.resourcemanager.postgresql.models.ServerVersion;
import com.azure.resourcemanager.postgresql.models.SslEnforcementEnum;
import com.azure.resourcemanager.postgresql.models.StorageProfile;
import java.io.IOException;

public final class ServerPropertiesForGeoRestore
extends ServerPropertiesForCreate {
    private CreateMode createMode = CreateMode.GEO_RESTORE;
    private String sourceServerId;
    private static final ClientLogger LOGGER = new ClientLogger(ServerPropertiesForGeoRestore.class);

    @Override
    public CreateMode createMode() {
        return this.createMode;
    }

    public String sourceServerId() {
        return this.sourceServerId;
    }

    public ServerPropertiesForGeoRestore withSourceServerId(String sourceServerId) {
        this.sourceServerId = sourceServerId;
        return this;
    }

    @Override
    public ServerPropertiesForGeoRestore withVersion(ServerVersion version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public ServerPropertiesForGeoRestore withSslEnforcement(SslEnforcementEnum sslEnforcement) {
        super.withSslEnforcement(sslEnforcement);
        return this;
    }

    @Override
    public ServerPropertiesForGeoRestore withMinimalTlsVersion(MinimalTlsVersionEnum minimalTlsVersion) {
        super.withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    @Override
    public ServerPropertiesForGeoRestore withInfrastructureEncryption(InfrastructureEncryption infrastructureEncryption) {
        super.withInfrastructureEncryption(infrastructureEncryption);
        return this;
    }

    @Override
    public ServerPropertiesForGeoRestore withPublicNetworkAccess(PublicNetworkAccessEnum publicNetworkAccess) {
        super.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public ServerPropertiesForGeoRestore withStorageProfile(StorageProfile storageProfile) {
        super.withStorageProfile(storageProfile);
        return this;
    }

    @Override
    public void validate() {
        if (this.sourceServerId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceServerId in model ServerPropertiesForGeoRestore"));
        }
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version() == null ? null : this.version().toString());
        jsonWriter.writeStringField("sslEnforcement", this.sslEnforcement() == null ? null : this.sslEnforcement().toString());
        jsonWriter.writeStringField("minimalTlsVersion", this.minimalTlsVersion() == null ? null : this.minimalTlsVersion().toString());
        jsonWriter.writeStringField("infrastructureEncryption", this.infrastructureEncryption() == null ? null : this.infrastructureEncryption().toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess() == null ? null : this.publicNetworkAccess().toString());
        jsonWriter.writeJsonField("storageProfile", (JsonSerializable)this.storageProfile());
        jsonWriter.writeStringField("sourceServerId", this.sourceServerId);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static ServerPropertiesForGeoRestore fromJson(JsonReader jsonReader) throws IOException {
        return (ServerPropertiesForGeoRestore)jsonReader.readObject(reader -> {
            ServerPropertiesForGeoRestore deserializedServerPropertiesForGeoRestore = new ServerPropertiesForGeoRestore();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedServerPropertiesForGeoRestore.withVersion(ServerVersion.fromString(reader.getString()));
                    continue;
                }
                if ("sslEnforcement".equals(fieldName)) {
                    deserializedServerPropertiesForGeoRestore.withSslEnforcement(SslEnforcementEnum.fromString(reader.getString()));
                    continue;
                }
                if ("minimalTlsVersion".equals(fieldName)) {
                    deserializedServerPropertiesForGeoRestore.withMinimalTlsVersion(MinimalTlsVersionEnum.fromString(reader.getString()));
                    continue;
                }
                if ("infrastructureEncryption".equals(fieldName)) {
                    deserializedServerPropertiesForGeoRestore.withInfrastructureEncryption(InfrastructureEncryption.fromString(reader.getString()));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedServerPropertiesForGeoRestore.withPublicNetworkAccess(PublicNetworkAccessEnum.fromString(reader.getString()));
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedServerPropertiesForGeoRestore.withStorageProfile(StorageProfile.fromJson(reader));
                    continue;
                }
                if ("sourceServerId".equals(fieldName)) {
                    deserializedServerPropertiesForGeoRestore.sourceServerId = reader.getString();
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedServerPropertiesForGeoRestore.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerPropertiesForGeoRestore;
        });
    }
}

