/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.fluent.VirtualNetworkRulesClient;
import com.azure.resourcemanager.postgresql.fluent.models.VirtualNetworkRuleInner;
import com.azure.resourcemanager.postgresql.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresql.implementation.VirtualNetworkRuleImpl;
import com.azure.resourcemanager.postgresql.models.VirtualNetworkRule;
import com.azure.resourcemanager.postgresql.models.VirtualNetworkRules;

public final class VirtualNetworkRulesImpl
implements VirtualNetworkRules {
    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkRulesImpl.class);
    private final VirtualNetworkRulesClient innerClient;
    private final PostgreSqlManager serviceManager;

    public VirtualNetworkRulesImpl(VirtualNetworkRulesClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<VirtualNetworkRule> getWithResponse(String resourceGroupName, String serverName, String virtualNetworkRuleName, Context context) {
        Response<VirtualNetworkRuleInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, virtualNetworkRuleName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VirtualNetworkRuleImpl((VirtualNetworkRuleInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public VirtualNetworkRule get(String resourceGroupName, String serverName, String virtualNetworkRuleName) {
        VirtualNetworkRuleInner inner = this.serviceClient().get(resourceGroupName, serverName, virtualNetworkRuleName);
        if (inner != null) {
            return new VirtualNetworkRuleImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String virtualNetworkRuleName) {
        this.serviceClient().delete(resourceGroupName, serverName, virtualNetworkRuleName);
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String virtualNetworkRuleName, Context context) {
        this.serviceClient().delete(resourceGroupName, serverName, virtualNetworkRuleName, context);
    }

    @Override
    public PagedIterable<VirtualNetworkRule> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<VirtualNetworkRuleInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualNetworkRuleImpl((VirtualNetworkRuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<VirtualNetworkRule> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<VirtualNetworkRuleInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualNetworkRuleImpl((VirtualNetworkRuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public VirtualNetworkRule getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String virtualNetworkRuleName = ResourceManagerUtils.getValueFromIdByName(id, "virtualNetworkRules");
        if (virtualNetworkRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualNetworkRules'.", id)));
        }
        return (VirtualNetworkRule)this.getWithResponse(resourceGroupName, serverName, virtualNetworkRuleName, Context.NONE).getValue();
    }

    @Override
    public Response<VirtualNetworkRule> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String virtualNetworkRuleName = ResourceManagerUtils.getValueFromIdByName(id, "virtualNetworkRules");
        if (virtualNetworkRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualNetworkRules'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serverName, virtualNetworkRuleName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String virtualNetworkRuleName = ResourceManagerUtils.getValueFromIdByName(id, "virtualNetworkRules");
        if (virtualNetworkRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualNetworkRules'.", id)));
        }
        this.delete(resourceGroupName, serverName, virtualNetworkRuleName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String virtualNetworkRuleName = ResourceManagerUtils.getValueFromIdByName(id, "virtualNetworkRules");
        if (virtualNetworkRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualNetworkRules'.", id)));
        }
        this.delete(resourceGroupName, serverName, virtualNetworkRuleName, context);
    }

    private VirtualNetworkRulesClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public VirtualNetworkRuleImpl define(String name) {
        return new VirtualNetworkRuleImpl(name, this.manager());
    }
}

