/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.fluent.ServerSecurityAlertPoliciesClient;
import com.azure.resourcemanager.postgresql.fluent.models.ServerSecurityAlertPolicyInner;
import com.azure.resourcemanager.postgresql.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresql.implementation.ServerSecurityAlertPolicyImpl;
import com.azure.resourcemanager.postgresql.models.SecurityAlertPolicyName;
import com.azure.resourcemanager.postgresql.models.ServerSecurityAlertPolicies;
import com.azure.resourcemanager.postgresql.models.ServerSecurityAlertPolicy;

public final class ServerSecurityAlertPoliciesImpl
implements ServerSecurityAlertPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(ServerSecurityAlertPoliciesImpl.class);
    private final ServerSecurityAlertPoliciesClient innerClient;
    private final PostgreSqlManager serviceManager;

    public ServerSecurityAlertPoliciesImpl(ServerSecurityAlertPoliciesClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ServerSecurityAlertPolicy> getWithResponse(String resourceGroupName, String serverName, SecurityAlertPolicyName securityAlertPolicyName, Context context) {
        Response<ServerSecurityAlertPolicyInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, securityAlertPolicyName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ServerSecurityAlertPolicyImpl((ServerSecurityAlertPolicyInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ServerSecurityAlertPolicy get(String resourceGroupName, String serverName, SecurityAlertPolicyName securityAlertPolicyName) {
        ServerSecurityAlertPolicyInner inner = this.serviceClient().get(resourceGroupName, serverName, securityAlertPolicyName);
        if (inner != null) {
            return new ServerSecurityAlertPolicyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<ServerSecurityAlertPolicy> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<ServerSecurityAlertPolicyInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServerSecurityAlertPolicyImpl((ServerSecurityAlertPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ServerSecurityAlertPolicy> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<ServerSecurityAlertPolicyInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServerSecurityAlertPolicyImpl((ServerSecurityAlertPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public ServerSecurityAlertPolicy getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String securityAlertPolicyNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "securityAlertPolicies");
        if (securityAlertPolicyNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityAlertPolicies'.", id)));
        }
        SecurityAlertPolicyName securityAlertPolicyName = SecurityAlertPolicyName.fromString(securityAlertPolicyNameLocal);
        return (ServerSecurityAlertPolicy)this.getWithResponse(resourceGroupName, serverName, securityAlertPolicyName, Context.NONE).getValue();
    }

    @Override
    public Response<ServerSecurityAlertPolicy> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String securityAlertPolicyNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "securityAlertPolicies");
        if (securityAlertPolicyNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityAlertPolicies'.", id)));
        }
        SecurityAlertPolicyName securityAlertPolicyName = SecurityAlertPolicyName.fromString(securityAlertPolicyNameLocal);
        return this.getWithResponse(resourceGroupName, serverName, securityAlertPolicyName, context);
    }

    private ServerSecurityAlertPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ServerSecurityAlertPolicyImpl define(SecurityAlertPolicyName name) {
        return new ServerSecurityAlertPolicyImpl(name, this.manager());
    }
}

