/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.fluent.ServerParametersClient;
import com.azure.resourcemanager.postgresql.fluent.models.ConfigurationListResultInner;
import com.azure.resourcemanager.postgresql.implementation.ConfigurationListResultImpl;
import com.azure.resourcemanager.postgresql.models.ConfigurationListResult;
import com.azure.resourcemanager.postgresql.models.ServerParameters;

public final class ServerParametersImpl
implements ServerParameters {
    private static final ClientLogger LOGGER = new ClientLogger(ServerParametersImpl.class);
    private final ServerParametersClient innerClient;
    private final PostgreSqlManager serviceManager;

    public ServerParametersImpl(ServerParametersClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public ConfigurationListResult listUpdateConfigurations(String resourceGroupName, String serverName, ConfigurationListResultInner value) {
        ConfigurationListResultInner inner = this.serviceClient().listUpdateConfigurations(resourceGroupName, serverName, value);
        if (inner != null) {
            return new ConfigurationListResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ConfigurationListResult listUpdateConfigurations(String resourceGroupName, String serverName, ConfigurationListResultInner value, Context context) {
        ConfigurationListResultInner inner = this.serviceClient().listUpdateConfigurations(resourceGroupName, serverName, value, context);
        if (inner != null) {
            return new ConfigurationListResultImpl(inner, this.manager());
        }
        return null;
    }

    private ServerParametersClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

