/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.postgresql.fluent.CheckNameAvailabilitiesClient;
import com.azure.resourcemanager.postgresql.fluent.ConfigurationsClient;
import com.azure.resourcemanager.postgresql.fluent.DatabasesClient;
import com.azure.resourcemanager.postgresql.fluent.FirewallRulesClient;
import com.azure.resourcemanager.postgresql.fluent.LocationBasedPerformanceTiersClient;
import com.azure.resourcemanager.postgresql.fluent.LogFilesClient;
import com.azure.resourcemanager.postgresql.fluent.OperationsClient;
import com.azure.resourcemanager.postgresql.fluent.PostgreSqlManagementClient;
import com.azure.resourcemanager.postgresql.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.postgresql.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.postgresql.fluent.RecoverableServersClient;
import com.azure.resourcemanager.postgresql.fluent.ReplicasClient;
import com.azure.resourcemanager.postgresql.fluent.ServerAdministratorsClient;
import com.azure.resourcemanager.postgresql.fluent.ServerBasedPerformanceTiersClient;
import com.azure.resourcemanager.postgresql.fluent.ServerKeysClient;
import com.azure.resourcemanager.postgresql.fluent.ServerParametersClient;
import com.azure.resourcemanager.postgresql.fluent.ServerSecurityAlertPoliciesClient;
import com.azure.resourcemanager.postgresql.fluent.ServersClient;
import com.azure.resourcemanager.postgresql.fluent.VirtualNetworkRulesClient;
import com.azure.resourcemanager.postgresql.implementation.CheckNameAvailabilitiesClientImpl;
import com.azure.resourcemanager.postgresql.implementation.ConfigurationsClientImpl;
import com.azure.resourcemanager.postgresql.implementation.DatabasesClientImpl;
import com.azure.resourcemanager.postgresql.implementation.FirewallRulesClientImpl;
import com.azure.resourcemanager.postgresql.implementation.LocationBasedPerformanceTiersClientImpl;
import com.azure.resourcemanager.postgresql.implementation.LogFilesClientImpl;
import com.azure.resourcemanager.postgresql.implementation.OperationsClientImpl;
import com.azure.resourcemanager.postgresql.implementation.PostgreSqlManagementClientBuilder;
import com.azure.resourcemanager.postgresql.implementation.PrivateEndpointConnectionsClientImpl;
import com.azure.resourcemanager.postgresql.implementation.PrivateLinkResourcesClientImpl;
import com.azure.resourcemanager.postgresql.implementation.RecoverableServersClientImpl;
import com.azure.resourcemanager.postgresql.implementation.ReplicasClientImpl;
import com.azure.resourcemanager.postgresql.implementation.ServerAdministratorsClientImpl;
import com.azure.resourcemanager.postgresql.implementation.ServerBasedPerformanceTiersClientImpl;
import com.azure.resourcemanager.postgresql.implementation.ServerKeysClientImpl;
import com.azure.resourcemanager.postgresql.implementation.ServerParametersClientImpl;
import com.azure.resourcemanager.postgresql.implementation.ServerSecurityAlertPoliciesClientImpl;
import com.azure.resourcemanager.postgresql.implementation.ServersClientImpl;
import com.azure.resourcemanager.postgresql.implementation.VirtualNetworkRulesClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=PostgreSqlManagementClientBuilder.class)
public final class PostgreSqlManagementClientImpl
implements PostgreSqlManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final ServersClient servers;
    private final ReplicasClient replicas;
    private final FirewallRulesClient firewallRules;
    private final VirtualNetworkRulesClient virtualNetworkRules;
    private final DatabasesClient databases;
    private final ConfigurationsClient configurations;
    private final ServerParametersClient serverParameters;
    private final LogFilesClient logFiles;
    private final ServerAdministratorsClient serverAdministrators;
    private final RecoverableServersClient recoverableServers;
    private final ServerBasedPerformanceTiersClient serverBasedPerformanceTiers;
    private final LocationBasedPerformanceTiersClient locationBasedPerformanceTiers;
    private final CheckNameAvailabilitiesClient checkNameAvailabilities;
    private final OperationsClient operations;
    private final ServerSecurityAlertPoliciesClient serverSecurityAlertPolicies;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final ServerKeysClient serverKeys;
    private static final ClientLogger LOGGER = new ClientLogger(PostgreSqlManagementClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public ServersClient getServers() {
        return this.servers;
    }

    @Override
    public ReplicasClient getReplicas() {
        return this.replicas;
    }

    @Override
    public FirewallRulesClient getFirewallRules() {
        return this.firewallRules;
    }

    @Override
    public VirtualNetworkRulesClient getVirtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    @Override
    public DatabasesClient getDatabases() {
        return this.databases;
    }

    @Override
    public ConfigurationsClient getConfigurations() {
        return this.configurations;
    }

    @Override
    public ServerParametersClient getServerParameters() {
        return this.serverParameters;
    }

    @Override
    public LogFilesClient getLogFiles() {
        return this.logFiles;
    }

    @Override
    public ServerAdministratorsClient getServerAdministrators() {
        return this.serverAdministrators;
    }

    @Override
    public RecoverableServersClient getRecoverableServers() {
        return this.recoverableServers;
    }

    @Override
    public ServerBasedPerformanceTiersClient getServerBasedPerformanceTiers() {
        return this.serverBasedPerformanceTiers;
    }

    @Override
    public LocationBasedPerformanceTiersClient getLocationBasedPerformanceTiers() {
        return this.locationBasedPerformanceTiers;
    }

    @Override
    public CheckNameAvailabilitiesClient getCheckNameAvailabilities() {
        return this.checkNameAvailabilities;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public ServerSecurityAlertPoliciesClient getServerSecurityAlertPolicies() {
        return this.serverSecurityAlertPolicies;
    }

    @Override
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public ServerKeysClient getServerKeys() {
        return this.serverKeys;
    }

    PostgreSqlManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.servers = new ServersClientImpl(this);
        this.replicas = new ReplicasClientImpl(this);
        this.firewallRules = new FirewallRulesClientImpl(this);
        this.virtualNetworkRules = new VirtualNetworkRulesClientImpl(this);
        this.databases = new DatabasesClientImpl(this);
        this.configurations = new ConfigurationsClientImpl(this);
        this.serverParameters = new ServerParametersClientImpl(this);
        this.logFiles = new LogFilesClientImpl(this);
        this.serverAdministrators = new ServerAdministratorsClientImpl(this);
        this.recoverableServers = new RecoverableServersClientImpl(this);
        this.serverBasedPerformanceTiers = new ServerBasedPerformanceTiersClientImpl(this);
        this.locationBasedPerformanceTiers = new LocationBasedPerformanceTiersClientImpl(this);
        this.checkNameAvailabilities = new CheckNameAvailabilitiesClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.serverSecurityAlertPolicies = new ServerSecurityAlertPoliciesClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.serverKeys = new ServerKeysClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

