/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Locale;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.xxhash.StreamingXXHash32;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;

public class LZ4FrameOutputStream
extends FilterOutputStream {
    static final int INTEGER_BYTES = 4;
    static final int LONG_BYTES = 8;
    static final int MAGIC = 407708164;
    static final int LZ4_MAX_HEADER_LENGTH = 15;
    static final int LZ4_FRAME_INCOMPRESSIBLE_MASK = Integer.MIN_VALUE;
    static final FLG.Bits[] DEFAULT_FEATURES = new FLG.Bits[]{FLG.Bits.BLOCK_INDEPENDENCE};
    static final String CLOSED_STREAM = "The stream is already closed";
    private final LZ4Compressor compressor;
    private final XXHash32 checksum;
    private final ByteBuffer buffer;
    private final byte[] compressedBuffer;
    private final int maxBlockSize;
    private final long knownSize;
    private final ByteBuffer intLEBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
    private FrameInfo frameInfo = null;

    public LZ4FrameOutputStream(OutputStream outputStream, BLOCKSIZE bLOCKSIZE, FLG.Bits ... bitsArray) throws IOException {
        this(outputStream, bLOCKSIZE, -1L, bitsArray);
    }

    public LZ4FrameOutputStream(OutputStream outputStream, BLOCKSIZE bLOCKSIZE, long l2, FLG.Bits ... bitsArray) throws IOException {
        super(outputStream);
        this.compressor = LZ4Factory.fastestInstance().fastCompressor();
        this.checksum = XXHashFactory.fastestInstance().hash32();
        this.frameInfo = new FrameInfo(new FLG(1, bitsArray), new BD(bLOCKSIZE));
        this.maxBlockSize = this.frameInfo.getBD().getBlockMaximumSize();
        this.buffer = ByteBuffer.allocate(this.maxBlockSize).order(ByteOrder.LITTLE_ENDIAN);
        this.compressedBuffer = new byte[this.compressor.maxCompressedLength(this.maxBlockSize)];
        if (this.frameInfo.getFLG().isEnabled(FLG.Bits.CONTENT_SIZE) && l2 < 0L) {
            throw new IllegalArgumentException("Known size must be greater than zero in order to use the known size feature");
        }
        this.knownSize = l2;
        this.writeHeader();
    }

    public LZ4FrameOutputStream(OutputStream outputStream, BLOCKSIZE bLOCKSIZE) throws IOException {
        this(outputStream, bLOCKSIZE, DEFAULT_FEATURES);
    }

    public LZ4FrameOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, BLOCKSIZE.SIZE_4MB);
    }

    private void writeHeader() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(15).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(407708164);
        byteBuffer.put(this.frameInfo.getFLG().toByte());
        byteBuffer.put(this.frameInfo.getBD().toByte());
        if (this.frameInfo.isEnabled(FLG.Bits.CONTENT_SIZE)) {
            byteBuffer.putLong(this.knownSize);
        }
        int n2 = this.checksum.hash(byteBuffer.array(), 4, byteBuffer.position() - 4, 0) >> 8 & 0xFF;
        byteBuffer.put((byte)n2);
        this.out.write(byteBuffer.array(), 0, byteBuffer.position());
    }

    private void writeBlock() throws IOException {
        int n2;
        byte[] byArray;
        if (this.buffer.position() == 0) {
            return;
        }
        Arrays.fill(this.compressedBuffer, (byte)0);
        int n3 = this.compressor.compress(this.buffer.array(), 0, this.buffer.position(), this.compressedBuffer, 0);
        if (n3 >= this.buffer.position()) {
            n3 = this.buffer.position();
            byArray = Arrays.copyOf(this.buffer.array(), n3);
            n2 = Integer.MIN_VALUE;
        } else {
            byArray = this.compressedBuffer;
            n2 = 0;
        }
        this.intLEBuffer.putInt(0, n3 | n2);
        this.out.write(this.intLEBuffer.array());
        this.out.write(byArray, 0, n3);
        if (this.frameInfo.isEnabled(FLG.Bits.BLOCK_CHECKSUM)) {
            this.intLEBuffer.putInt(0, this.checksum.hash(byArray, 0, n3, 0));
            this.out.write(this.intLEBuffer.array());
        }
        this.buffer.rewind();
    }

    private void writeEndMark() throws IOException {
        this.intLEBuffer.putInt(0, 0);
        this.out.write(this.intLEBuffer.array());
        if (this.frameInfo.isEnabled(FLG.Bits.CONTENT_CHECKSUM)) {
            this.intLEBuffer.putInt(0, this.frameInfo.currentStreamHash());
            this.out.write(this.intLEBuffer.array());
        }
        this.frameInfo.finish();
    }

    @Override
    public void write(int n2) throws IOException {
        this.ensureNotFinished();
        if (this.buffer.position() == this.maxBlockSize) {
            this.writeBlock();
        }
        this.buffer.put((byte)n2);
        if (this.frameInfo.isEnabled(FLG.Bits.CONTENT_CHECKSUM)) {
            this.frameInfo.updateStreamHash(new byte[]{(byte)n2}, 0, 1);
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureNotFinished();
        while (n3 > this.buffer.remaining()) {
            int n4 = this.buffer.remaining();
            this.buffer.put(byArray, n2, n4);
            if (this.frameInfo.isEnabled(FLG.Bits.CONTENT_CHECKSUM)) {
                this.frameInfo.updateStreamHash(byArray, n2, n4);
            }
            this.writeBlock();
            n2 += n4;
            n3 -= n4;
        }
        this.buffer.put(byArray, n2, n3);
        if (this.frameInfo.isEnabled(FLG.Bits.CONTENT_CHECKSUM)) {
            this.frameInfo.updateStreamHash(byArray, n2, n3);
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.frameInfo.isFinished()) {
            this.writeBlock();
        }
        super.flush();
    }

    private void ensureNotFinished() {
        if (this.frameInfo.isFinished()) {
            throw new IllegalStateException(CLOSED_STREAM);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.frameInfo.isFinished()) {
            this.flush();
            this.writeEndMark();
        }
        super.close();
    }

    static class FrameInfo {
        private final FLG flg;
        private final BD bd;
        private final StreamingXXHash32 streamHash;
        private boolean finished = false;

        public FrameInfo(FLG fLG, BD bD) {
            this.flg = fLG;
            this.bd = bD;
            this.streamHash = fLG.isEnabled(FLG.Bits.CONTENT_CHECKSUM) ? XXHashFactory.fastestInstance().newStreamingHash32(0) : null;
        }

        public boolean isEnabled(FLG.Bits bits) {
            return this.flg.isEnabled(bits);
        }

        public FLG getFLG() {
            return this.flg;
        }

        public BD getBD() {
            return this.bd;
        }

        public void updateStreamHash(byte[] byArray, int n2, int n3) {
            this.streamHash.update(byArray, n2, n3);
        }

        public int currentStreamHash() {
            return this.streamHash.getValue();
        }

        public void finish() {
            this.finished = true;
        }

        public boolean isFinished() {
            return this.finished;
        }
    }

    public static class BD {
        private static final int RESERVED_MASK = 143;
        private final BLOCKSIZE blockSizeValue;

        private BD(BLOCKSIZE bLOCKSIZE) {
            this.blockSizeValue = bLOCKSIZE;
        }

        public static BD fromByte(byte by2) {
            int n2 = by2 >>> 4 & 7;
            if ((by2 & 0x8F) > 0) {
                throw new RuntimeException("Reserved fields must be 0");
            }
            return new BD(BLOCKSIZE.valueOf(n2));
        }

        public int getBlockMaximumSize() {
            return 1 << 2 * this.blockSizeValue.getIndicator() + 8;
        }

        public byte toByte() {
            return (byte)((this.blockSizeValue.getIndicator() & 7) << 4);
        }
    }

    public static class FLG {
        private static final int DEFAULT_VERSION = 1;
        private final BitSet bitSet;
        private final int version;

        public FLG(int n2, Bits ... bitsArray) {
            this.bitSet = new BitSet(8);
            this.version = n2;
            if (bitsArray != null) {
                for (Bits bits : bitsArray) {
                    this.bitSet.set(bits.position);
                }
            }
            this.validate();
        }

        private FLG(int n2, byte by2) {
            this.bitSet = BitSet.valueOf(new byte[]{by2});
            this.version = n2;
            this.validate();
        }

        public static FLG fromByte(byte by2) {
            byte by3 = (byte)(by2 & 0xC0);
            return new FLG(by3 >>> 6, (byte)(by2 ^ by3));
        }

        public byte toByte() {
            return (byte)(this.bitSet.toByteArray()[0] | (this.version & 3) << 6);
        }

        private void validate() {
            if (this.bitSet.get(Bits.RESERVED_0.position)) {
                throw new RuntimeException("Reserved0 field must be 0");
            }
            if (this.bitSet.get(Bits.RESERVED_1.position)) {
                throw new RuntimeException("Reserved1 field must be 0");
            }
            if (!this.bitSet.get(Bits.BLOCK_INDEPENDENCE.position)) {
                throw new RuntimeException("Dependent block stream is unsupported (BLOCK_INDEPENDENCE must be set)");
            }
            if (this.version != 1) {
                throw new RuntimeException(String.format(Locale.ROOT, "Version %d is unsupported", this.version));
            }
        }

        public boolean isEnabled(Bits bits) {
            return this.bitSet.get(bits.position);
        }

        public int getVersion() {
            return this.version;
        }

        public static enum Bits {
            RESERVED_0(0),
            RESERVED_1(1),
            CONTENT_CHECKSUM(2),
            CONTENT_SIZE(3),
            BLOCK_CHECKSUM(4),
            BLOCK_INDEPENDENCE(5);

            private final int position;

            private Bits(int n3) {
                this.position = n3;
            }
        }
    }

    public static enum BLOCKSIZE {
        SIZE_64KB(4),
        SIZE_256KB(5),
        SIZE_1MB(6),
        SIZE_4MB(7);

        private final int indicator;

        private BLOCKSIZE(int n3) {
            this.indicator = n3;
        }

        public int getIndicator() {
            return this.indicator;
        }

        public static BLOCKSIZE valueOf(int n2) {
            switch (n2) {
                case 7: {
                    return SIZE_4MB;
                }
                case 6: {
                    return SIZE_1MB;
                }
                case 5: {
                    return SIZE_256KB;
                }
                case 4: {
                    return SIZE_64KB;
                }
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Block size must be 4-7. Cannot use value of [%d]", n2));
        }
    }
}

