/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.databricks.ui;

import com.dbeaver.db.databricks.model.auth.DatabricksM2MAuthModel;
import com.dbeaver.db.databricks.ui.DatabricksUIMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class DatabricksM2MAuthConfigurator
implements IObjectPropertyConfigurator<DatabricksM2MAuthModel, DBPDataSourceContainer> {
    private Text httpPathText;
    private Text clientIdText;
    private Text clientSecretText;

    public void createControl(@NotNull Composite authPanel, @NotNull DatabricksM2MAuthModel object, @NotNull Runnable propertyChangeListener) {
        this.httpPathText = UIUtils.createLabelText((Composite)authPanel, (String)DatabricksUIMessages.auth_configurator_http_path, (String)"", (int)2048);
        this.httpPathText.setMessage(DatabricksUIMessages.auth_configurator_http_path_message);
        this.httpPathText.setToolTipText(DatabricksUIMessages.auth_configurator_http_path_tip);
        this.clientIdText = UIUtils.createLabelText((Composite)authPanel, (String)DatabricksUIMessages.auth_configurator_client_id, (String)"", (int)2048);
        this.clientIdText.setMessage(DatabricksUIMessages.auth_configurator_client_id_message);
        this.clientIdText.setToolTipText(DatabricksUIMessages.auth_configurator_client_id_tip);
        this.clientSecretText = UIUtils.createLabelText((Composite)authPanel, (String)DatabricksUIMessages.auth_configurator_client_secret, (String)"", (int)0x400800);
        this.clientSecretText.setMessage(DatabricksUIMessages.auth_configurator_client_secret_message);
        this.clientSecretText.setToolTipText(DatabricksUIMessages.auth_configurator_client_secret_tip);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBPConnectionConfiguration connectionInfo = dataSourceContainer.getConnectionConfiguration();
        if (this.httpPathText != null && !this.httpPathText.isDisposed()) {
            this.httpPathText.setText(CommonUtils.notEmpty((String)connectionInfo.getAuthProperty("httpPath")));
        }
        if (this.clientIdText != null && !this.clientIdText.isDisposed()) {
            this.clientIdText.setText(CommonUtils.notEmpty((String)connectionInfo.getAuthProperty("OAuth2ClientId")));
        }
        if (this.clientSecretText != null && !this.clientSecretText.isDisposed()) {
            this.clientSecretText.setText(CommonUtils.notEmpty((String)connectionInfo.getAuthProperty("OAuth2Secret")));
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBPConnectionConfiguration connectionInfo = dataSourceContainer.getConnectionConfiguration();
        if (this.httpPathText != null && !this.httpPathText.isDisposed()) {
            connectionInfo.setAuthProperty("httpPath", this.httpPathText.getText().trim());
        }
        if (this.clientIdText != null && !this.clientIdText.isDisposed()) {
            connectionInfo.setAuthProperty("OAuth2ClientId", this.clientIdText.getText().trim());
        }
        if (this.clientSecretText != null && !this.clientSecretText.isDisposed()) {
            connectionInfo.setAuthProperty("OAuth2Secret", this.clientSecretText.getText().trim());
        }
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        this.loadSettings(dataSourceContainer);
    }

    public boolean isComplete() {
        return !this.httpPathText.getText().isEmpty() && !this.clientIdText.getText().isEmpty() && !this.clientSecretText.getText().isEmpty();
    }
}

