/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.rag;

import com.dbeaver.model.ai.rag.AIEmbeddingGenerator;
import com.dbeaver.model.ai.rag.AIScopeSelector;
import com.dbeaver.model.ai.rag.AIVectorEmbedding;
import com.dbeaver.model.ai.rag.RAGIndexBuilder;
import com.dbeaver.model.ai.rag.RAGUtils;
import com.dbeaver.model.ai.rag.strategy.SelectionStrategy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class RAGScopeSelector
implements AIScopeSelector {
    private static final Log log = Log.getLog(RAGScopeSelector.class);
    @NotNull
    private final RAGIndexBuilder indexBuilder;
    @NotNull
    private final Map<AIDatabaseScope, SelectionStrategy> strategyMap;

    public RAGScopeSelector(@NotNull RAGIndexBuilder indexBuilder, @NotNull Map<AIDatabaseScope, SelectionStrategy> strategyMap) {
        this.indexBuilder = indexBuilder;
        this.strategyMap = strategyMap;
    }

    @Override
    @Nullable
    public AIDatabaseContext select(@NotNull DBRProgressMonitor monitor, @NotNull AIEmbeddingGenerator embeddingGenerator, @NotNull AIDatabaseContext originalContext, @NotNull List<AIMessage> messages) throws DBException {
        List<DBSEntity> entities;
        List dbsObjects;
        List list = dbsObjects = originalContext.getScope() == AIDatabaseScope.CUSTOM ? Objects.requireNonNull(originalContext.getCustomEntities()) : List.of(originalContext.getScopeObject());
        if (embeddingGenerator.isLoggingEnabled()) {
            log.debug((Object)("Collecting RAG entities for scope: " + String.valueOf(originalContext.getScope())));
        }
        if ((entities = RAGUtils.flattenContainers(monitor, dbsObjects)).isEmpty()) {
            if (embeddingGenerator.isLoggingEnabled()) {
                log.debug((Object)"No RAG entities found to index");
            }
            return originalContext;
        }
        if (embeddingGenerator.isLoggingEnabled()) {
            log.debug((Object)("Collected " + entities.size() + " RAG entities to index"));
        }
        this.updateIndex(monitor, embeddingGenerator, entities, originalContext.getExecutionContext());
        if (embeddingGenerator.isLoggingEnabled()) {
            log.debug((Object)"Compute embeddings for user messages");
        }
        List<String> userMessages = messages.stream().filter(it -> it.getRole() == AIMessageType.USER).map(AIMessage::getContent).toList();
        List<AIVectorEmbedding> queryEmbeddings = embeddingGenerator.embedTexts(monitor, userMessages);
        if (embeddingGenerator.isLoggingEnabled()) {
            log.debug((Object)("Selecting relevant RAG scope for original scope: " + String.valueOf(originalContext.getScope())));
        }
        List<DBSObject> relevantObjects = this.strategyMap.get(originalContext.getScope()).selectObjectsForScope(monitor, queryEmbeddings, originalContext);
        if (embeddingGenerator.isLoggingEnabled()) {
            log.info((Object)("Selected " + relevantObjects.size() + " relevant RAG objects for scope: " + String.valueOf(relevantObjects.stream().map(DBPNamedObject::getName).toList())));
        }
        return new AIDatabaseContext.Builder(originalContext.getDataSource()).setScope(AIDatabaseScope.CUSTOM).setCustomEntities(relevantObjects).setExecutionContext(originalContext.getExecutionContext()).build();
    }

    private void updateIndex(@NotNull DBRProgressMonitor monitor, @NotNull AIEmbeddingGenerator embeddingGenerator, @NotNull List<DBSEntity> dbsEntities, @NotNull DBCExecutionContext ctx) throws DBException {
        if (embeddingGenerator.isLoggingEnabled()) {
            log.debug((Object)"Updating RAG index");
        }
        CompletableFuture<Void> indexAsyncFor = this.indexBuilder.updateIndexAsyncFor(monitor, embeddingGenerator, dbsEntities, ctx);
        try {
            indexAsyncFor.get();
            if (embeddingGenerator.isLoggingEnabled()) {
                log.debug((Object)"RAG index updated successfully");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error updating RAG index", (Throwable)e);
            throw new DBException("Error updating RAG index", (Throwable)e);
        }
    }
}

