/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.nio;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.implementation.util.BlobUserAgentModificationPolicy;
import com.azure.storage.blob.nio.AzureBasicFileAttributeView;
import com.azure.storage.blob.nio.AzureBlobFileAttributeView;
import com.azure.storage.blob.nio.AzureFileStore;
import com.azure.storage.blob.nio.AzureFileSystemProvider;
import com.azure.storage.blob.nio.AzurePath;
import com.azure.storage.blob.nio.LoggingUtility;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.RetryPolicyType;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

public final class AzureFileSystem
extends FileSystem {
    private static final ClientLogger LOGGER = new ClientLogger(AzureFileSystem.class);
    public static final String AZURE_STORAGE_SHARED_KEY_CREDENTIAL = "AzureStorageSharedKeyCredential";
    public static final String AZURE_STORAGE_SAS_TOKEN_CREDENTIAL = "AzureStorageSasTokenCredential";
    public static final String AZURE_STORAGE_HTTP_LOG_DETAIL_LEVEL = "AzureStorageHttpLogDetailLevel";
    public static final String AZURE_STORAGE_MAX_TRIES = "AzureStorageMaxTries";
    public static final String AZURE_STORAGE_TRY_TIMEOUT = "AzureStorageTryTimeout";
    public static final String AZURE_STORAGE_RETRY_DELAY_IN_MS = "AzureStorageRetryDelayInMs";
    public static final String AZURE_STORAGE_MAX_RETRY_DELAY_IN_MS = "AzureStorageMaxRetryDelayInMs";
    public static final String AZURE_STORAGE_RETRY_POLICY_TYPE = "AzureStorageRetryPolicyType";
    public static final String AZURE_STORAGE_SECONDARY_HOST = "AzureStorageSecondaryHost";
    public static final String AZURE_STORAGE_UPLOAD_BLOCK_SIZE = "AzureStorageUploadBlockSize";
    public static final String AZURE_STORAGE_MAX_CONCURRENCY_PER_REQUEST = "AzureStorageMaxConcurrencyPerRequest";
    public static final String AZURE_STORAGE_PUT_BLOB_THRESHOLD = "AzureStoragePutBlobThreshold";
    public static final String AZURE_STORAGE_DOWNLOAD_RESUME_RETRIES = "AzureStorageDownloadResumeRetries";
    static final String AZURE_STORAGE_HTTP_CLIENT = "AzureStorageHttpClient";
    static final String AZURE_STORAGE_HTTP_POLICIES = "AzureStorageHttpPolicies";
    public static final String AZURE_STORAGE_FILE_STORES = "AzureStorageFileStores";
    public static final String AZURE_STORAGE_SKIP_INITIAL_CONTAINER_CHECK = "AzureStorageSkipInitialContainerCheck";
    static final String PATH_SEPARATOR = "/";
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-storage-blob-nio.properties");
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String CLIENT_NAME = PROPERTIES.getOrDefault("name", "UnknownName");
    private static final String CLIENT_VERSION = PROPERTIES.getOrDefault("version", "UnknownVersion");
    static final Map<Class<? extends FileAttributeView>, String> SUPPORTED_ATTRIBUTE_VIEWS;
    private final AzureFileSystemProvider parentFileSystemProvider;
    private final BlobServiceClient blobServiceClient;
    private final Long blockSize;
    private final Long putBlobThreshold;
    private final Integer maxConcurrencyPerRequest;
    private final Integer downloadResumeRetries;
    private final Map<String, FileStore> fileStores;
    private FileStore defaultFileStore;
    private boolean closed;

    AzureFileSystem(AzureFileSystemProvider parentFileSystemProvider, String endpoint, Map<String, ?> config) throws IOException {
        if (Objects.isNull(parentFileSystemProvider)) {
            throw LoggingUtility.logError(LOGGER, new IllegalArgumentException("AzureFileSystem cannot be instantiated without a parent FileSystemProvider"));
        }
        this.parentFileSystemProvider = parentFileSystemProvider;
        try {
            this.blobServiceClient = this.buildBlobServiceClient(endpoint, config);
            this.blockSize = (Long)config.get(AZURE_STORAGE_UPLOAD_BLOCK_SIZE);
            this.putBlobThreshold = (Long)config.get(AZURE_STORAGE_PUT_BLOB_THRESHOLD);
            this.maxConcurrencyPerRequest = (Integer)config.get(AZURE_STORAGE_MAX_CONCURRENCY_PER_REQUEST);
            this.downloadResumeRetries = (Integer)config.get(AZURE_STORAGE_DOWNLOAD_RESUME_RETRIES);
            this.fileStores = this.initializeFileStores(config);
        }
        catch (RuntimeException e) {
            throw LoggingUtility.logError(LOGGER, new IllegalArgumentException("There was an error parsing the configurations map. Please ensure all fields are set to a legal value of the correct type.", e));
        }
        catch (IOException e) {
            throw LoggingUtility.logError(LOGGER, new IOException("Initializing FileStores failed. FileSystem could not be opened.", e));
        }
        this.closed = false;
    }

    @Override
    public FileSystemProvider provider() {
        return this.parentFileSystemProvider;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.parentFileSystemProvider.closeFileSystem(this.getFileSystemUrl());
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return PATH_SEPARATOR;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return this.fileStores.keySet().stream().map(name -> this.getPath(name + ":", new String[0])).collect(Collectors.toList());
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return this.fileStores.values();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return new HashSet<String>(SUPPORTED_ATTRIBUTE_VIEWS.values());
    }

    @Override
    public Path getPath(String first, String ... more) {
        return new AzurePath(this, first, more);
    }

    @Override
    public PathMatcher getPathMatcher(String s) throws IllegalArgumentException, PatternSyntaxException {
        throw LoggingUtility.logError(LOGGER, new UnsupportedOperationException());
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw LoggingUtility.logError(LOGGER, new UnsupportedOperationException());
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw LoggingUtility.logError(LOGGER, new UnsupportedOperationException());
    }

    String getFileSystemUrl() {
        return this.blobServiceClient.getAccountUrl();
    }

    BlobServiceClient getBlobServiceClient() {
        return this.blobServiceClient;
    }

    private BlobServiceClient buildBlobServiceClient(String endpoint, Map<String, ?> config) {
        BlobServiceClientBuilder builder = new BlobServiceClientBuilder().endpoint(endpoint);
        if (config.containsKey(AZURE_STORAGE_SHARED_KEY_CREDENTIAL)) {
            builder.credential((StorageSharedKeyCredential)config.get(AZURE_STORAGE_SHARED_KEY_CREDENTIAL));
        } else if (config.containsKey(AZURE_STORAGE_SAS_TOKEN_CREDENTIAL)) {
            builder.credential((AzureSasCredential)config.get(AZURE_STORAGE_SAS_TOKEN_CREDENTIAL));
        } else {
            throw LoggingUtility.logError(LOGGER, new IllegalArgumentException(String.format("No credentials were provided. Please specify one of the following when constructing an AzureFileSystem: %s, %s.", AZURE_STORAGE_SHARED_KEY_CREDENTIAL, AZURE_STORAGE_SAS_TOKEN_CREDENTIAL)));
        }
        builder.httpLogOptions(BlobServiceClientBuilder.getDefaultHttpLogOptions().setLogLevel((HttpLogDetailLevel)config.get(AZURE_STORAGE_HTTP_LOG_DETAIL_LEVEL)));
        RequestRetryOptions retryOptions = new RequestRetryOptions((RetryPolicyType)config.get(AZURE_STORAGE_RETRY_POLICY_TYPE), (Integer)config.get(AZURE_STORAGE_MAX_TRIES), (Integer)config.get(AZURE_STORAGE_TRY_TIMEOUT), (Long)config.get(AZURE_STORAGE_RETRY_DELAY_IN_MS), (Long)config.get(AZURE_STORAGE_MAX_RETRY_DELAY_IN_MS), (String)config.get(AZURE_STORAGE_SECONDARY_HOST));
        builder.retryOptions(retryOptions);
        builder.httpClient((HttpClient)config.get(AZURE_STORAGE_HTTP_CLIENT));
        builder.addPolicy((HttpPipelinePolicy)new BlobUserAgentModificationPolicy(CLIENT_NAME, CLIENT_VERSION));
        if (config.containsKey(AZURE_STORAGE_HTTP_POLICIES)) {
            for (HttpPipelinePolicy policy : (HttpPipelinePolicy[])config.get(AZURE_STORAGE_HTTP_POLICIES)) {
                builder.addPolicy(policy);
            }
        }
        return builder.buildClient();
    }

    private Map<String, FileStore> initializeFileStores(Map<String, ?> config) throws IOException {
        String fileStoreNames = (String)config.get(AZURE_STORAGE_FILE_STORES);
        if (CoreUtils.isNullOrEmpty((CharSequence)fileStoreNames)) {
            throw LoggingUtility.logError(LOGGER, new IllegalArgumentException("The list of FileStores cannot be null."));
        }
        Boolean skipConnectionCheck = (Boolean)config.get(AZURE_STORAGE_SKIP_INITIAL_CONTAINER_CHECK);
        HashMap<String, FileStore> fileStores = new HashMap<String, FileStore>();
        for (String fileStoreName : fileStoreNames.split(",")) {
            AzureFileStore fs = new AzureFileStore(this, fileStoreName, skipConnectionCheck);
            if (this.defaultFileStore == null) {
                this.defaultFileStore = fs;
            }
            fileStores.put(fileStoreName, fs);
        }
        return fileStores;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureFileSystem that = (AzureFileSystem)o;
        return Objects.equals(this.getFileSystemUrl(), that.getFileSystemUrl());
    }

    public int hashCode() {
        return Objects.hash(this.getFileSystemUrl());
    }

    Path getDefaultDirectory() {
        return this.getPath(this.defaultFileStore.name() + ":", new String[0]);
    }

    FileStore getFileStore(String name) throws IOException {
        FileStore store = this.fileStores.get(name);
        if (store == null) {
            throw LoggingUtility.logError(LOGGER, new IOException("Invalid file store: " + name));
        }
        return store;
    }

    Long getBlockSize() {
        return this.blockSize;
    }

    Long getPutBlobThreshold() {
        return this.putBlobThreshold;
    }

    Integer getMaxConcurrencyPerRequest() {
        return this.maxConcurrencyPerRequest;
    }

    static {
        HashMap<Class<AzureBlobFileAttributeView>, String> map = new HashMap<Class<AzureBlobFileAttributeView>, String>();
        map.put(BasicFileAttributeView.class, "basic");
        map.put(AzureBasicFileAttributeView.class, "azureBasic");
        map.put(AzureBlobFileAttributeView.class, "azureBlob");
        SUPPORTED_ATTRIBUTE_VIEWS = Collections.unmodifiableMap(map);
    }
}

