/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.nio;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.ArchiveStatus;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.nio.AzureResource;
import com.azure.storage.blob.nio.LoggingUtility;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public final class AzureBlobFileAttributes
implements BasicFileAttributes {
    private static final ClientLogger LOGGER = new ClientLogger(AzureBlobFileAttributes.class);
    private final BlobProperties properties;
    private final AzureResource resource;
    private final boolean isVirtualDirectory;

    AzureBlobFileAttributes(Path path) throws IOException {
        this.resource = new AzureResource(path);
        BlobProperties props = null;
        try {
            props = this.resource.getBlobClient().getProperties();
        }
        catch (BlobStorageException e) {
            if (e.getStatusCode() == 404 && this.resource.checkVirtualDirectoryExists()) {
                this.isVirtualDirectory = true;
                this.properties = null;
                return;
            }
            throw LoggingUtility.logError(LOGGER, new IOException("Path: " + path.toString(), e));
        }
        this.properties = props;
        this.isVirtualDirectory = false;
    }

    static Map<String, Supplier<Object>> getAttributeSuppliers(AzureBlobFileAttributes attributes) {
        HashMap<String, Supplier<Object>> map = new HashMap<String, Supplier<Object>>();
        map.put("creationTime", attributes::creationTime);
        map.put("lastModifiedTime", attributes::lastModifiedTime);
        map.put("eTag", attributes::eTag);
        map.put("blobHttpHeaders", attributes::blobHttpHeaders);
        map.put("blobType", attributes::blobType);
        map.put("copyId", attributes::copyId);
        map.put("copyStatus", attributes::copyStatus);
        map.put("copySource", attributes::copySource);
        map.put("copyProgress", attributes::copyProgress);
        map.put("copyCompletionTime", attributes::copyCompletionTime);
        map.put("copyStatusDescription", attributes::copyStatusDescription);
        map.put("isServerEncrypted", attributes::isServerEncrypted);
        map.put("accessTier", attributes::accessTier);
        map.put("isAccessTierInferred", attributes::isAccessTierInferred);
        map.put("archiveStatus", attributes::archiveStatus);
        map.put("accessTierChangeTime", attributes::accessTierChangeTime);
        map.put("metadata", attributes::metadata);
        map.put("isRegularFile", attributes::isRegularFile);
        map.put("isDirectory", attributes::isDirectory);
        map.put("isVirtualDirectory", attributes::isVirtualDirectory);
        map.put("isSymbolicLink", attributes::isSymbolicLink);
        map.put("isOther", attributes::isOther);
        map.put("size", attributes::size);
        return map;
    }

    @Override
    public FileTime creationTime() {
        return !this.isVirtualDirectory ? FileTime.from(this.properties.getCreationTime().toInstant()) : null;
    }

    @Override
    public FileTime lastModifiedTime() {
        return !this.isVirtualDirectory ? FileTime.from(this.properties.getLastModified().toInstant()) : null;
    }

    public String eTag() {
        return !this.isVirtualDirectory ? this.properties.getETag() : null;
    }

    public BlobHttpHeaders blobHttpHeaders() {
        if (this.isVirtualDirectory) {
            return null;
        }
        return new BlobHttpHeaders().setContentType(this.properties.getContentType()).setContentLanguage(this.properties.getContentLanguage()).setContentMd5(this.properties.getContentMd5()).setContentDisposition(this.properties.getContentDisposition()).setContentEncoding(this.properties.getContentEncoding()).setCacheControl(this.properties.getCacheControl());
    }

    public BlobType blobType() {
        return !this.isVirtualDirectory ? this.properties.getBlobType() : null;
    }

    public String copyId() {
        return !this.isVirtualDirectory ? this.properties.getCopyId() : null;
    }

    public CopyStatusType copyStatus() {
        return !this.isVirtualDirectory ? this.properties.getCopyStatus() : null;
    }

    public String copySource() {
        return !this.isVirtualDirectory ? this.properties.getCopySource() : null;
    }

    public String copyProgress() {
        return !this.isVirtualDirectory ? this.properties.getCopyProgress() : null;
    }

    public OffsetDateTime copyCompletionTime() {
        return !this.isVirtualDirectory ? this.properties.getCopyCompletionTime() : null;
    }

    public String copyStatusDescription() {
        return !this.isVirtualDirectory ? this.properties.getCopyStatusDescription() : null;
    }

    public Boolean isServerEncrypted() {
        return !this.isVirtualDirectory ? this.properties.isServerEncrypted() : null;
    }

    public AccessTier accessTier() {
        return !this.isVirtualDirectory ? this.properties.getAccessTier() : null;
    }

    public Boolean isAccessTierInferred() {
        return !this.isVirtualDirectory ? this.properties.isAccessTierInferred() : null;
    }

    public ArchiveStatus archiveStatus() {
        return !this.isVirtualDirectory ? this.properties.getArchiveStatus() : null;
    }

    public OffsetDateTime accessTierChangeTime() {
        return !this.isVirtualDirectory ? this.properties.getAccessTierChangeTime() : null;
    }

    public Map<String, String> metadata() {
        return !this.isVirtualDirectory ? Collections.unmodifiableMap(this.properties.getMetadata()) : null;
    }

    @Override
    public FileTime lastAccessTime() {
        return !this.isVirtualDirectory ? FileTime.from(this.properties.getLastAccessedTime().toInstant()) : null;
    }

    @Override
    public boolean isRegularFile() {
        return !this.isVirtualDirectory && !this.properties.getMetadata().getOrDefault("hdi_isfolder", "false").equals("true");
    }

    @Override
    public boolean isDirectory() {
        return !this.isRegularFile();
    }

    public boolean isVirtualDirectory() {
        return this.isVirtualDirectory;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public long size() {
        return !this.isVirtualDirectory ? this.properties.getBlobSize() : 0L;
    }

    @Override
    public Object fileKey() {
        return this.resource.getBlobClient().getBlobUrl();
    }
}

