/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sybase.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;

public class SybaseSequence
extends GenericSequence {
    private long startWith;
    private long cache;
    private long restartWith;
    private boolean cycle;
    private String description;

    SybaseSequence(GenericStructContainer container, String name, String description, Number lastValue, Number minValue, Number maxValue, Number incrementBy, @NotNull JDBCResultSet dbResult) {
        super(container, name, description, lastValue, minValue, maxValue, incrementBy);
        this.description = description;
        this.startWith = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"start_with");
        this.cache = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"cache");
        this.restartWith = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"resume_at");
        this.cycle = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"cycle");
    }

    public Number getLastValue() {
        return super.getLastValue();
    }

    @Property(viewable=true, order=6)
    public long getStartWith() {
        return this.startWith;
    }

    @Property(viewable=true, order=7)
    public long getCache() {
        return this.cache;
    }

    @Property(viewable=true, order=8)
    public long getRestartWith() {
        return this.restartWith;
    }

    @Property(viewable=true, order=9)
    public boolean isCycle() {
        return this.cycle;
    }

    @Property(viewable=true, updatable=true, editable=true, length=PropertyLength.MULTILINE, order=10)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

