/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.gcp;

import com.dbeaver.net.auth.gcp.AuthModelGCP;
import com.dbeaver.net.auth.gcp.AuthModelGCPSimpleCredentials;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AuthModelGCPBigquery
extends AuthModelGCP {
    public static final String ID = "gcp_cloud_iam_bigquery";

    @Override
    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelGCPSimpleCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connectProps) throws DBException {
        credentials.resolveCredentials(monitor);
        if (credentials.getAuthType() == null) {
            return super.initAuthentication(monitor, dataSource, credentials, configuration, connectProps);
        }
        switch (credentials.getAuthType()) {
            case SERVICE_ACCOUNT: {
                String accountConfig;
                if (!CommonUtils.isEmpty((String)credentials.getServiceAccountConfigPath())) {
                    connectProps.put("OAuthPvtKeyPath", credentials.getServiceAccountConfigPath());
                }
                if (!CommonUtils.isEmpty((String)(accountConfig = credentials.getServiceAccountConfig()))) {
                    try {
                        accountConfig = new String(Base64.getDecoder().decode(accountConfig), StandardCharsets.UTF_8);
                    }
                    catch (Exception exception) {}
                    connectProps.put("OAuthPvtKey", accountConfig);
                }
                connectProps.putIfAbsent("OAuthType", "0");
                break;
            }
            case SSO_OVER_CLI: 
            case SESSION_CREDENTIALS: 
            case PREGENERATED_OAUTH: {
                connectProps.putIfAbsent("OAuthType", "2");
                if (CommonUtils.isNotEmpty((String)credentials.getClientId()) && CommonUtils.isNotEmpty((String)credentials.getClientSecret()) && CommonUtils.isNotEmpty((String)credentials.getRefreshToken())) {
                    connectProps.put("OAuthRefreshToken", credentials.getRefreshToken());
                    connectProps.put("OAuthClientId", credentials.getClientId());
                    connectProps.put("OAuthClientSecret", credentials.getClientSecret());
                }
                if (!CommonUtils.isNotEmpty((String)credentials.getToken())) break;
                connectProps.put("OAuthAccessToken", credentials.getToken());
                break;
            }
            case DEFAULT: {
                connectProps.putIfAbsent("OAuthType", "3");
                break;
            }
        }
        return super.initAuthentication(monitor, dataSource, credentials, configuration, connectProps);
    }

    @Override
    @NotNull
    public AuthModelGCPSimpleCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        AuthModelGCPSimpleCredentials authModelGCPSimpleCredentials = (AuthModelGCPSimpleCredentials)super.loadCredentials(dataSource, configuration);
        return authModelGCPSimpleCredentials;
    }
}

