/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.ui.ai.function;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.ai.AIFunction;
import org.jkiss.dbeaver.model.ai.AIFunctionContext;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithReturn;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.data.SQLQueryDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.tools.transfer.ui.SQLPragmaExport;
import org.jkiss.utils.CommonUtils;

public class AIFunctionExportQueryResultsToFile
implements AIFunction {
    public static final String PARAM_SQL = "sql";
    public static final String PARAM_FORMAT = "outputFormat";

    @NotNull
    public AIFunctionResult callFunction(@NotNull AIFunctionContext context, @NotNull Map<String, Object> parameters) throws DBException {
        String sqlText = JSONUtils.getString(parameters, (String)PARAM_SQL);
        if (CommonUtils.isEmptyTrimmed((String)sqlText)) {
            throw new DBException("SQL query is missing");
        }
        String format = JSONUtils.getString(parameters, (String)PARAM_FORMAT);
        if (CommonUtils.isEmptyTrimmed((String)format)) {
            throw new DBException("Output format parameter is missing");
        }
        AIDatabaseContext dbCtx = context.getContext();
        if (dbCtx == null) {
            throw new DBException("Database context is missing");
        }
        DBCExecutionContext execCtx = dbCtx.getExecutionContext();
        SQLPragmaExport pragma = new SQLPragmaExport();
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("type", format);
        DBRRunnableWithReturn callback = monitor -> {
            DBPContextProvider ctxProvider = () -> execCtx;
            DBPDataSource dataSource = execCtx.getDataSource();
            String queryText = SQLUtils.removeQueryDelimiter((SQLDialect)dataSource.getSQLDialect(), (String)sqlText);
            SQLQuery query = new SQLQuery(execCtx.getDataSource(), queryText);
            query.setParameters(Collections.emptyList());
            SQLScriptContext scriptCtx = null;
            Log log = Log.getLog(AIFunctionExportQueryResultsToFile.class);
            SQLQueryDataContainer container = new SQLQueryDataContainer(ctxProvider, query, scriptCtx, log);
            return pragma.processPragma(context.getMonitor(), (DBSDataContainer)container, args);
        };
        callback.runTask(context.getMonitor());
        return new AIFunctionResult(AIFunctionResult.FunctionType.ACTION, "Export query results to " + format.toUpperCase(Locale.ROOT), callback);
    }
}

