/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.json;

import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.files.FFTableReader;
import com.dbeaver.jdbc.files.json.JsonNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class JsonTableReader
implements FFTableReader<JsonNode<?>> {
    @NotNull
    private final List<ColumnInfo<JsonNode<?>>> columns;
    @NotNull
    private final FFTableReader<JsonNode<?>> reader;

    public JsonTableReader(@NotNull List<ColumnInfo<JsonNode<?>>> columns, @NotNull FFTableReader<JsonNode<?>> reader) {
        this.columns = columns;
        this.reader = reader;
    }

    @Nullable
    public JsonNode<?>[] readRow() throws IOException {
        JsonNode[] row = (JsonNode[])this.reader.readRow();
        if (row == null) {
            return null;
        }
        Map<String, JsonNode> nodes = Arrays.stream(row).collect(Collectors.toMap(JsonNode::name, node -> node));
        JsonNode[] enriched = new JsonNode[this.columns.size()];
        int i = 0;
        while (i < this.columns.size()) {
            ColumnInfo<JsonNode<?>> column = this.columns.get(i);
            JsonNode node2 = nodes.get(column.columnName());
            enriched[i] = node2 == null ? new JsonNode<Object>(column.columnName(), null) : node2;
            ++i;
        }
        return enriched;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean isClosed() {
        return this.reader.isClosed();
    }
}

