/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.json;

import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.files.FFDataFileMetadataReader;
import com.dbeaver.jdbc.files.FFFileReader;
import com.dbeaver.jdbc.files.database.FFSchemaName;
import com.dbeaver.jdbc.files.database.FFTableName;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import com.dbeaver.jdbc.files.database.FFTableStructure;
import com.dbeaver.jdbc.files.json.JsonFileReaderFactory;
import com.dbeaver.jdbc.files.json.JsonNode;
import com.dbeaver.jdbc.files.json.JsonProperties;
import com.dbeaver.jdbc.files.json.JsonTableProperties;
import com.dbeaver.jdbc.files.utils.FFDataTypeUtils;
import com.dbeaver.jdbc.files.utils.FFIOUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.jkiss.code.NotNull;

public class JsonMetadataReader
implements FFDataFileMetadataReader<JsonNode<?>, JsonTableProperties> {
    @NotNull
    private final JsonProperties properties;
    @NotNull
    private final JsonFileReaderFactory jsonFileReaderFactory;

    public JsonMetadataReader(@NotNull JsonProperties properties, @NotNull JsonFileReaderFactory jsonFileReaderFactory) {
        this.properties = properties;
        this.jsonFileReaderFactory = jsonFileReaderFactory;
    }

    @NotNull
    public FFTableStructure<JsonNode<?>, JsonTableProperties> getTableStructure(@NotNull FFSchemaName schemaName, @NotNull Path dataPath, @NotNull String tableSourceName) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (FFFileReader<JsonNode<?>> reader = this.jsonFileReaderFactory.createReader(dataPath, this.properties);){
            if (reader.openNextTable()) {
                FFTableName tableName = new FFTableName(schemaName, FFIOUtils.truncateFileExtension((Path)dataPath));
                return new FFTableStructure(this.extractColumns(tableName, reader), (FFTableProperties)JsonTableProperties.EMPTY);
            }
            throw new IOException("No tables found in the JSON file.");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    public List<String> getTableSourceNames(@NotNull Path dataPath) throws IOException {
        return List.of(FFIOUtils.truncateFileExtension((Path)dataPath));
    }

    @NotNull
    private List<ColumnInfo<JsonNode<?>>> extractColumns(FFTableName tableName, FFFileReader<JsonNode<?>> reader) throws IOException {
        JsonNode[] firstRow = (JsonNode[])reader.readRow();
        if (firstRow == null) {
            return List.of();
        }
        ArrayList<JsonNode[]> sampleRows = new ArrayList<JsonNode[]>(this.properties.sampleRows());
        sampleRows.add(firstRow);
        int i = 1;
        while (i < this.properties.sampleRows()) {
            JsonNode[] nodes = (JsonNode[])reader.readRow();
            if (nodes == null) break;
            sampleRows.add(nodes);
            ++i;
        }
        LinkedHashMap<String, SQLType> columnTypes = new LinkedHashMap<String, SQLType>();
        Iterator iterator = sampleRows.iterator();
        while (iterator.hasNext()) {
            JsonNode[] sampleRow;
            JsonNode[] jsonNodeArray = sampleRow = (JsonNode[])iterator.next();
            int n = sampleRow.length;
            int n2 = 0;
            while (n2 < n) {
                JsonNode node = jsonNodeArray[n2];
                SQLType type = FFDataTypeUtils.determineDataType(node.value());
                columnTypes.compute(node.name(), (key, value) -> {
                    if (value == null) {
                        return type;
                    }
                    return FFDataTypeUtils.determineCommonDataType((SQLType)value, (SQLType)type);
                });
                ++n2;
            }
        }
        return columnTypes.entrySet().stream().map(entry -> new ColumnInfo(tableName.schema().name(), tableName.name(), (String)entry.getKey(), (String)entry.getKey(), (SQLType)entry.getValue(), JsonNode::value)).toList();
    }
}

