/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.model;

import com.dbeaver.db.bigquery.model.BigQueryForeignKey;
import com.dbeaver.db.bigquery.model.BigQueryTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKeyColumnTable;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyDeferability;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.utils.CommonUtils;

public class BigQueryForeignKeyCache
extends JDBCCompositeCache<GenericStructContainer, BigQueryTable, BigQueryForeignKey, GenericTableForeignKeyColumnTable> {
    BigQueryForeignKeyCache(TableCache tableCache) {
        super((JDBCStructCache)tableCache, BigQueryTable.class, (Object)"table_name", (Object)"constraint_name");
    }

    protected BigQueryForeignKeyCache(JDBCStructCache<GenericStructContainer, ?, ?> parentCache, Class<BigQueryTable> parentType, Object parentColumnName, Object objectColumnName) {
        super(parentCache, parentType, parentColumnName, objectColumnName);
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, BigQueryTable table) throws SQLException {
        String sql = "SELECT * FROM " + DBUtils.getQuotedIdentifier((DBSObject)table.getCatalog()) + "." + DBUtils.getQuotedIdentifier((DBSObject)table.getSchema()) + ".INFORMATION_SCHEMA.TABLE_CONSTRAINTS b JOIN " + DBUtils.getQuotedIdentifier((DBSObject)table.getCatalog()) + "." + DBUtils.getQuotedIdentifier((DBSObject)table.getSchema()) + ".INFORMATION_SCHEMA.KEY_COLUMN_USAGE c  ON b.CONSTRAINT_NAME = c.CONSTRAINT_NAME WHERE b.TABLE_SCHEMA = ? AND b.TABLE_NAME = ? AND b.CONSTRAINT_TYPE = ?";
        JDBCPreparedStatement statement = session.prepareStatement(sql);
        statement.setString(1, table.getSchema().getName());
        statement.setString(2, table.getName());
        statement.setString(3, DBSEntityConstraintType.FOREIGN_KEY.getName());
        return statement;
    }

    protected BigQueryForeignKey fetchObject(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull BigQueryTable parent, @NotNull String childName, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        String constraintName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_NAME");
        return new BigQueryForeignKey((GenericTableBase)parent, constraintName, "", null, DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyDeferability.UNKNOWN, true);
    }

    protected GenericTableForeignKeyColumnTable[] fetchObjectRow(@NotNull JDBCSession session, @NotNull BigQueryTable parent, @NotNull BigQueryForeignKey forObject, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
        String columnName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"column_name");
        if (CommonUtils.isEmpty((String)columnName)) {
            log.debug((Object)("Can't find constraint table column name for " + forObject.getName()));
            return null;
        }
        GenericTableColumn tableColumn = parent.getAttribute(session.getProgressMonitor(), columnName);
        if (tableColumn == null) {
            log.debug((Object)("Can't find constraint table column for " + forObject.getName()));
            return null;
        }
        int keySeq = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"key_sequence");
        return new GenericTableForeignKeyColumnTable[]{new GenericTableForeignKeyColumnTable((GenericTableForeignKey)forObject, tableColumn, keySeq, null)};
    }

    protected void cacheChildren(@NotNull DBRProgressMonitor monitor, @NotNull BigQueryForeignKey object, @NotNull List<GenericTableForeignKeyColumnTable> children) {
        try {
            object.setAttributeReferences(children);
        }
        catch (DBException e) {
            log.debug((Object)e);
        }
    }
}

