/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.model;

import com.dbeaver.db.bigquery.BigQueryConstantsPro;
import com.dbeaver.db.bigquery.BigQueryMessages;
import com.dbeaver.db.bigquery.model.BigQueryDataset;
import com.dbeaver.db.bigquery.model.BigQueryDialect;
import com.dbeaver.db.bigquery.model.BigQueryFactory;
import com.dbeaver.net.auth.gcp.AuthModelGCPCredentials;
import com.dbeaver.net.auth.gcp.GCPAuthType;
import com.dbeaver.net.auth.gcp.GCPAuthUtils;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.paging.Page;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.UserCredentials;
import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.bigquery.model.BigQueryDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCFactory;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class BigQueryDataSourcePro
extends BigQueryDataSource {
    private static final Log log = Log.getLog(BigQueryDataSourcePro.class);
    private final JDBCFactory bqFactory = new BigQueryFactory();
    private final CredentialsProvider credentialsProvider;
    private String token;
    private BigQuery bigQueryService;

    public BigQueryDataSourcePro(DBRProgressMonitor monitor, DBPDataSourceContainer container, GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel);
        DBPConnectionConfiguration configuration = container.getActualConnectionConfiguration();
        DBPAuthModelDescriptor authModelDescriptor = container.getDriver().getDataSourceProvider().detectConnectionAuthModel(container.getDriver(), configuration);
        DBAAuthModel authModel = authModelDescriptor.getInstance();
        DBAAuthCredentials credentials = authModel.loadCredentials(container, configuration);
        Object authentication = authModel.initAuthentication(monitor, (DBPDataSource)this, credentials, configuration, new Properties());
        boolean useDefaultCreds = false;
        boolean usedSSO = false;
        if (credentials instanceof AuthModelGCPCredentials || authentication instanceof AuthModelGCPCredentials) {
            AuthModelGCPCredentials gcpCredentials;
            AuthModelGCPCredentials authModelGCPCredentials = gcpCredentials = credentials instanceof AuthModelGCPCredentials ? (AuthModelGCPCredentials)credentials : (AuthModelGCPCredentials)authentication;
            if (gcpCredentials.getAuthType() == GCPAuthType.SERVICE_ACCOUNT) {
                configuration.setProviderProperty("gcp.sa_config_path", gcpCredentials.getServiceAccountConfigPath());
                configuration.setProviderProperty("gcp.sa_config", gcpCredentials.getServiceAccountConfig());
            } else if (gcpCredentials.getAuthType() == GCPAuthType.SSO_OVER_CLI || gcpCredentials.getAuthType() == GCPAuthType.SESSION_CREDENTIALS) {
                gcpCredentials.resolveCredentials(monitor);
                this.token = gcpCredentials.getToken();
                usedSSO = true;
            } else if (gcpCredentials.getAuthType() == GCPAuthType.DEFAULT) {
                useDefaultCreds = true;
            }
        } else {
            useDefaultCreds = CommonUtils.toBoolean((Object)configuration.getProviderProperty("useDefaultCredentials"));
        }
        AuthModelGCPCredentials gcpCredentialsObj = null;
        if (credentials instanceof AuthModelGCPCredentials) {
            AuthModelGCPCredentials gcpCredentials;
            gcpCredentialsObj = gcpCredentials = (AuthModelGCPCredentials)credentials;
        } else if (authentication instanceof AuthModelGCPCredentials) {
            AuthModelGCPCredentials gcpCredentials;
            gcpCredentialsObj = gcpCredentials = (AuthModelGCPCredentials)authentication;
        }
        this.credentialsProvider = this.setupCredentials(configuration, gcpCredentialsObj, useDefaultCreds, usedSSO);
        this.initializeBigQueryClient(configuration.getDatabaseName());
    }

    private CredentialsProvider setupCredentials(@NotNull DBPConnectionConfiguration cfg, AuthModelGCPCredentials gcpCreds, boolean useDefaultCreds, boolean usedSSO) throws DBException {
        try {
            GoogleCredentials credentials;
            block56: {
                if (gcpCreds != null) {
                    switch (gcpCreds.getAuthType()) {
                        case SERVICE_ACCOUNT: {
                            String credFileName = CommonUtils.toString((Object)cfg.getProviderProperty("gcp.sa_config_path"));
                            String credEncodedB64 = CommonUtils.toString((Object)cfg.getProviderProperty("gcp.sa_config"));
                            if (CommonUtils.isNotEmpty((String)credFileName)) {
                                Throwable throwable = null;
                                Object var9_21 = null;
                                try (FileInputStream is = new FileInputStream(credFileName);){
                                    credentials = GoogleCredentials.fromStream((InputStream)is);
                                    break;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            if (CommonUtils.isNotEmpty((String)credEncodedB64)) {
                                try {
                                    credEncodedB64 = new String(Base64.getDecoder().decode(credEncodedB64), StandardCharsets.UTF_8);
                                }
                                catch (Exception exception) {}
                                Throwable throwable = null;
                                Object var9_23 = null;
                                try (ByteArrayInputStream is = new ByteArrayInputStream(credEncodedB64.getBytes(StandardCharsets.UTF_8));){
                                    credentials = GoogleCredentials.fromStream((InputStream)is);
                                    break;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    throw throwable;
                                }
                            }
                            throw new DBException(BigQueryMessages.bigquery_auth_credentials_reading_error);
                        }
                        case PREGENERATED_OAUTH: {
                            String clientId = gcpCreds.getClientId();
                            String clientSecret = gcpCreds.getClientSecret();
                            String refreshToken = gcpCreds.getRefreshToken();
                            if (CommonUtils.isEmpty((String)clientId) || CommonUtils.isEmpty((String)clientSecret) || CommonUtils.isEmpty((String)refreshToken)) {
                                throw new DBException(BigQueryMessages.bigquery_auth_pregenerated_empty_properties_error);
                            }
                            UserCredentials c = UserCredentials.newBuilder().setClientId(clientId).setClientSecret(clientSecret).setRefreshToken(refreshToken).build();
                            String projectId = gcpCreds.getProjectId();
                            credentials = CommonUtils.isNotEmpty((String)projectId) ? c.createWithQuotaProject(projectId) : c;
                            break;
                        }
                        case SSO_OVER_CLI: 
                        case SESSION_CREDENTIALS: {
                            String gcpCredsToken = gcpCreds.getToken();
                            credentials = CommonUtils.isNotEmpty((String)gcpCredsToken) ? GoogleCredentials.create((AccessToken)new AccessToken(gcpCredsToken, null)) : GoogleCredentials.getApplicationDefault();
                            break;
                        }
                        default: {
                            credentials = GoogleCredentials.getApplicationDefault();
                            break;
                        }
                    }
                } else if (useDefaultCreds) {
                    credentials = GoogleCredentials.getApplicationDefault();
                } else if (usedSSO && CommonUtils.isNotEmpty((String)this.token)) {
                    credentials = GoogleCredentials.create((AccessToken)new AccessToken(this.token, null));
                } else {
                    String credFileName = CommonUtils.toString((Object)cfg.getProviderProperty("gcp.sa_config_path"));
                    String credEncodedB64 = CommonUtils.toString((Object)cfg.getProviderProperty("gcp.sa_config"));
                    if (CommonUtils.isNotEmpty((String)credFileName)) {
                        Throwable throwable = null;
                        Object var9_26 = null;
                        try (FileInputStream is = new FileInputStream(credFileName);){
                            credentials = GoogleCredentials.fromStream((InputStream)is);
                            break block56;
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    if (CommonUtils.isNotEmpty((String)credEncodedB64)) {
                        Throwable throwable = null;
                        Object var9_28 = null;
                        try (ByteArrayInputStream is = new ByteArrayInputStream(Base64.getDecoder().decode(credEncodedB64));){
                            credentials = GoogleCredentials.fromStream((InputStream)is);
                            break block56;
                        }
                        catch (Throwable throwable5) {
                            if (throwable == null) {
                                throwable = throwable5;
                            } else if (throwable != throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            throw throwable;
                        }
                    }
                    throw new DBException(BigQueryMessages.bigquery_auth_credentials_reading_error);
                }
            }
            return FixedCredentialsProvider.create((Credentials)credentials);
        }
        catch (Exception e) {
            throw new DBException(BigQueryMessages.bigquery_auth_credentials_reading_error, (Throwable)e);
        }
    }

    @NotNull
    public JDBCFactory getJdbcFactory() {
        return this.bqFactory;
    }

    public BigQueryDialect getCurrentDialect() {
        return (BigQueryDialect)CommonUtils.valueOf(BigQueryDialect.class, (String)this.getContainer().getConnectionConfiguration().getProperty("QueryDialect"), (Enum)BigQueryConstantsPro.DEFAULT_DIALECT);
    }

    @NotNull
    protected Map<String, String> getInternalConnectionProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPDriver driver, @NotNull JDBCExecutionContext context, @NotNull String purpose, @NotNull DBPConnectionConfiguration connectionInfo) throws DBCException {
        String location;
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("QueryDialect", this.getCurrentDialect().name());
        props.putAll(super.getInternalConnectionProperties(monitor, driver, context, purpose, connectionInfo));
        if (this.isSessionModeEnabled()) {
            props.put("EnableSession", "1");
        }
        if (CommonUtils.isNotEmpty((String)(location = connectionInfo.getProviderProperty("Location")))) {
            props.put("Location", location);
        }
        return props;
    }

    public Collection<? extends GenericProcedure> getProcedures(@NotNull DBRProgressMonitor monitor) throws DBException {
        GenericDataSource dataSource = this.getDataSource();
        GenericSchema genericSchema = dataSource.getSchema();
        if (genericSchema instanceof BigQueryDataset) {
            BigQueryDataset bqSchema = (BigQueryDataset)genericSchema;
            return bqSchema.getProcedures(monitor);
        }
        return super.getProcedures(monitor);
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    protected boolean isSessionModeEnabled() {
        boolean matchesEnableValue;
        DBPConnectionConfiguration connectionConfiguration = this.getContainer().getConnectionConfiguration();
        String propertyValue = connectionConfiguration.getProperty("EnableSession");
        String providerPropertyValue = connectionConfiguration.getProviderProperty("EnableSession");
        boolean bl = matchesEnableValue = Objects.equals(propertyValue, "1") || Objects.equals(providerPropertyValue, "1");
        if (matchesEnableValue) {
            return true;
        }
        return CommonUtils.toBoolean((Object)propertyValue, (boolean)false) || CommonUtils.toBoolean((Object)providerPropertyValue, (boolean)false);
    }

    private void initializeBigQueryClient(@NotNull String projectId) throws DBException {
        try {
            HeaderProvider headerProvider = GCPAuthUtils.createHeaderProvider();
            this.bigQueryService = (BigQuery)((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(projectId)).setCredentials(this.credentialsProvider.getCredentials())).setHeaderProvider(headerProvider)).build().getService();
            this.runUserAgentProbe();
        }
        catch (Exception e) {
            throw new DBException("Failed to initialize BigQuery client", (Throwable)e);
        }
    }

    public void runUserAgentProbe() {
        try {
            Dataset ds;
            Iterator it;
            String location = "";
            String projectId = ((BigQueryOptions)this.bigQueryService.getOptions()).getProjectId();
            Page page = this.bigQueryService.listDatasets(projectId, new BigQuery.DatasetListOption[]{BigQuery.DatasetListOption.pageSize((long)1L)});
            Iterator iterator = it = page == null ? null : page.getValues().iterator();
            if (it != null && it.hasNext() && CommonUtils.isNotEmpty((String)(ds = (Dataset)it.next()).getLocation())) {
                location = ds.getLocation();
            }
            String jobName = "dbeaver-ua-probe-" + System.currentTimeMillis();
            JobId jobId = JobId.newBuilder().setProject(projectId).setLocation(location).setJob(jobName).build();
            QueryJobConfiguration jobConfiguration = QueryJobConfiguration.newBuilder((String)"SELECT 1 AS ok").setUseLegacySql(Boolean.valueOf(false)).build();
            JobInfo jobInfo = JobInfo.newBuilder((JobConfiguration)jobConfiguration).setJobId(jobId).build();
            Job job = this.bigQueryService.create(jobInfo, new BigQuery.JobOption[0]);
            if ((job = job.waitFor(new RetryOption[0])) == null || job.getStatus().getError() != null) {
                throw new DBException("UA probe failed: " + (job == null ? "job is null" : job.getStatus().getError().toString()));
            }
        }
        catch (Exception e) {
            log.warn((Object)"UA probe error", (Throwable)e);
        }
    }
}

