/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.neptune.model;

import com.dbeaver.net.auth.aws.AuthModelAWSAbstract;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import com.dbeaver.net.auth.aws.AuthModelAWSNeptuneCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

public class AuthModelAWSNeptune
extends AuthModelAWSAbstract {
    public static final String ID = "aws_neptune";

    @NotNull
    public AuthModelAWSCredentials createCredentials() {
        return new AuthModelAWSNeptuneCredentials();
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelAWSCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        connProperties.put("serviceRegion", credentials.getRegion());
        AwsCredentialsProvider awsCredentialsProvider = credentials.getAuthCredentialsProvider(monitor, configuration);
        AwsCredentials awsCredentials = awsCredentialsProvider.resolveCredentials();
        if (!CommonUtils.isEmpty((String)awsCredentials.accessKeyId())) {
            System.setProperty("aws.accessKeyId", awsCredentials.accessKeyId());
            System.setProperty("aws.secretKey", awsCredentials.secretAccessKey());
            if (awsCredentials instanceof AwsSessionCredentials) {
                System.setProperty("aws.sessionToken", ((AwsSessionCredentials)awsCredentials).sessionToken());
            } else {
                System.clearProperty("aws.sessionToken");
            }
        } else {
            System.clearProperty("aws.accessKeyId");
            System.clearProperty("aws.secretKey");
            System.clearProperty("aws.sessionToken");
        }
        return credentials;
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
    }

    public boolean supportsDatabaseUser() {
        return false;
    }

    public boolean supportsRegion() {
        return true;
    }
}

