/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.neptune;

import com.dbeaver.model.net.ConfigurableNameService;
import java.net.InetAddress;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.GenericDataSourceProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfigurator;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.model.net.DBWTunnel;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AWSNeptuneDataSourceProvider
extends GenericDataSourceProvider
implements DBWHandlerConfigurator {
    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return super.openDataSource(monitor, container);
    }

    public void activateHandler(@NotNull DBWNetworkHandler handler, @NotNull DBPConnectionConfiguration connectionConfig, @NotNull DBWHandlerConfiguration handlerConfig) {
        if (handler instanceof DBWTunnel) {
            boolean mapHost;
            String hostName = connectionConfig.getHostName();
            boolean bl = mapHost = !CommonUtils.isEmpty((String)hostName) && !hostName.equals("localhost") && !hostName.equals("local") && !hostName.equals("127.0.0.1");
            if (mapHost) {
                try {
                    InetAddress proxyAddress = InetAddress.getByAddress(hostName, InetAddress.getLoopbackAddress().getAddress());
                    ConfigurableNameService.INSTANCE.mapHostAddress(hostName, new InetAddress[]{proxyAddress});
                    ((DBWTunnel)handler).addCloseListener(() -> ConfigurableNameService.INSTANCE.unmapHostAddress(hostName));
                }
                catch (Exception e) {
                    log.error((Object)"Error mapping host address", (Throwable)e);
                }
            }
            this.configureSSH(connectionConfig, handlerConfig);
        }
    }

    private void configureSSH(DBPConnectionConfiguration connectionConfig, DBWHandlerConfiguration handlerConfig) {
        String dbHostName = connectionConfig.getHostName();
        connectionConfig.getHostPort();
        String sshLocalHost = CommonUtils.toString((Object)handlerConfig.getProperty("localHost"));
        handlerConfig.getIntProperty("localPort");
        String sshRemoteHost = CommonUtils.toString((Object)handlerConfig.getProperty("remoteHost"));
        handlerConfig.getIntProperty("remotePort");
        if (CommonUtils.isEmpty((String)sshLocalHost) && CommonUtils.isEmpty((String)sshRemoteHost)) {
            handlerConfig.setProperty("localHost", (Object)dbHostName);
            handlerConfig.setProperty("remoteHost", (Object)dbHostName);
        }
    }
}

