/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.kafka.model;

import com.dbeaver.db.kafka.KSQLUtils;
import com.dbeaver.db.kafka.exec.KSQLExecutionContext;
import com.dbeaver.db.kafka.model.KSQLConnector;
import com.dbeaver.db.kafka.model.KSQLDataSourceInfo;
import com.dbeaver.db.kafka.model.KSQLDialect;
import com.dbeaver.db.kafka.model.KSQLFunction;
import com.dbeaver.db.kafka.model.KSQLQuery;
import com.dbeaver.db.kafka.model.KSQLStream;
import com.dbeaver.db.kafka.model.KSQLTable;
import com.dbeaver.db.kafka.model.KSQLTopic;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.api.client.ConnectorInfo;
import io.confluent.ksql.api.client.StreamInfo;
import io.confluent.ksql.api.client.TableInfo;
import io.confluent.ksql.api.client.TopicInfo;
import io.confluent.ksql.api.client.exception.KsqlClientException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.impl.AbstractSimpleDataSource;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;

public class KSQLDataSource
extends AbstractSimpleDataSource<KSQLExecutionContext>
implements DBPRefreshableObject,
DBPDataTypeProvider,
IAdaptable,
DBCQueryTransformProvider {
    private static final Log log = Log.getLog(KSQLDataSource.class);
    private final Gson gson = new Gson();
    private KSQLDataSourceInfo info;
    private final TopicCache topicCache = new TopicCache();
    private final TableCache tableCache = new TableCache();
    private final QueryCache queryCache = new QueryCache();
    private final StreamCache streamCache = new StreamCache();
    private final FunctionCache functionCache = new FunctionCache();
    private final ConnectorCache connectorCache = new ConnectorCache();

    public KSQLDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        super(container);
        this.executionContext = new KSQLExecutionContext(this, "Main Kafka Connection");
        ((KSQLExecutionContext)this.executionContext).connect(monitor);
    }

    @NotNull
    public SQLDialect getSQLDialect() {
        return KSQLDialect.INSTANCE;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) {
        this.info = new KSQLDataSourceInfo(this);
    }

    @NotNull
    public KSQLExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        KSQLExecutionContext context = new KSQLExecutionContext(this, purpose);
        context.connect(monitor);
        return context;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return null;
        }
        if (adapter == DBCQueryTransformProvider.class) {
            return adapter.cast((Object)this);
        }
        return null;
    }

    public void shutdown(@NotNull DBRProgressMonitor monitor) {
        super.shutdown(monitor);
        this.topicCache.clearCache();
        this.streamCache.clearCache();
        this.queryCache.clearCache();
        this.topicCache.clearCache();
        this.queryCache.clearCache();
    }

    @Association
    public List<KSQLQuery> getQueries(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.queryCache.getAllObjects(monitor, this);
    }

    @Association
    public List<KSQLFunction> getFunctions(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.functionCache.getAllObjects(monitor, this);
    }

    @Association
    public List<KSQLConnector> getConnectors(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.connectorCache.getAllObjects(monitor, this);
    }

    @Association
    public List<KSQLStream> getStreams(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.streamCache.getAllObjects(monitor, this);
    }

    @Association
    public List<KSQLTopic> getTopics(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.topicCache.getAllObjects(monitor, this);
    }

    public KSQLTopic getTopic(@NotNull DBRProgressMonitor monitor, @NotNull String topicName) throws DBException {
        return (KSQLTopic)this.topicCache.getObject(monitor, (DBSObject)this, topicName);
    }

    @Association
    public List<KSQLTable> getTables(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getAllObjects(monitor, this);
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<Object> allObjects = new ArrayList<Object>();
        allObjects.addAll(this.getTables(monitor));
        allObjects.addAll(this.getStreams(monitor));
        return allObjects;
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        KSQLStream stream = (KSQLStream)this.streamCache.getObject(monitor, (DBSObject)this, childName);
        if (stream != null) {
            return stream;
        }
        return this.tableCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<KSQLStream> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) {
        return KSQLStream.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.topicCache.getAllObjects(monitor, this);
    }

    public TableCache getTableCache() {
        return this.tableCache;
    }

    public StreamCache getStreamCache() {
        return this.streamCache;
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        return DBPDataKind.OBJECT;
    }

    @Nullable
    public DBSDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) {
        return null;
    }

    @NotNull
    public List<DBSDataType> getLocalDataTypes() {
        return null;
    }

    @Nullable
    public DBSDataType getLocalDataType(String typeName) {
        return null;
    }

    @Nullable
    public DBSDataType getLocalDataType(int typeID) {
        return null;
    }

    @NotNull
    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return "";
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.topicCache.clearCache();
        this.queryCache.clearCache();
        this.tableCache.clearCache();
        this.functionCache.clearCache();
        this.streamCache.clearCache();
        this.connectorCache.clearCache();
        return this;
    }

    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit(false, true);
        }
        return null;
    }

    public class ConnectorCache
    extends BasicObjectCache<KSQLDataSource, KSQLConnector> {
        @NotNull
        public List<KSQLConnector> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable KSQLDataSource dataSource) throws DBCException {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            if (!this.isFullyCached()) {
                ArrayList<KSQLConnector> result = new ArrayList<KSQLConnector>();
                try {
                    List functions = (List)((CompletableFuture)((KSQLExecutionContext)KSQLDataSource.this.executionContext).getKsqlClient().listConnectors().exceptionally(ex -> {
                        if (ex instanceof KsqlClientException && ex.getMessage().contains("Error code: 50000")) {
                            log.warn((Object)"KSQL connector module not found");
                            return null;
                        }
                        return null;
                    })).get(((KSQLExecutionContext)KSQLDataSource.this.executionContext).getRequestTimeout(), TimeUnit.SECONDS);
                    if (functions != null) {
                        for (ConnectorInfo connectorInfo : functions) {
                            KSQLConnector connector = new KSQLConnector(dataSource, connectorInfo);
                            result.add(connector);
                        }
                    }
                }
                catch (Throwable e) {
                    throw new DBCException("Error reading KSQL connectors", e);
                }
                this.setCache(result);
            }
            return this.getCachedObjects();
        }
    }

    public class FunctionCache
    extends BasicObjectCache<KSQLDataSource, KSQLFunction> {
        @NotNull
        public List<KSQLFunction> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable KSQLDataSource dataSource) throws DBCException {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            if (!this.isFullyCached()) {
                ArrayList<KSQLFunction> result = new ArrayList<KSQLFunction>();
                try {
                    Client.HttpResponse httpResponse = KSQLUtils.sendKSQLRequest((KSQLExecutionContext)KSQLDataSource.this.executionContext, "LIST FUNCTIONS;");
                    JsonArray listMap = (JsonArray)KSQLDataSource.this.gson.fromJson(new String(httpResponse.body()), JsonArray.class);
                    JsonArray functions = listMap.get(0).getAsJsonObject().get("functions").getAsJsonArray();
                    for (JsonElement function : functions) {
                        KSQLFunction ksqlFunction = new KSQLFunction(dataSource, function.getAsJsonObject());
                        result.add(ksqlFunction);
                    }
                    this.setCache(result);
                }
                catch (Throwable e) {
                    throw new DBCException("Error reading KSQL function", e);
                }
                this.setCache(result);
            }
            return this.getCachedObjects();
        }
    }

    public class QueryCache
    extends BasicObjectCache<KSQLDataSource, KSQLQuery> {
        @NotNull
        public List<KSQLQuery> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable KSQLDataSource ksqlDataSource) throws DBException {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            if (!this.isFullyCached()) {
                ArrayList<KSQLQuery> result = new ArrayList<KSQLQuery>();
                try {
                    Client.HttpResponse httpResponse = KSQLUtils.sendKSQLRequest((KSQLExecutionContext)KSQLDataSource.this.executionContext, "LIST QUERIES;");
                    if (httpResponse != null) {
                        JsonArray listMap = (JsonArray)KSQLDataSource.this.gson.fromJson(new String(httpResponse.body()), JsonArray.class);
                        JsonArray queries = listMap.get(0).getAsJsonObject().get("queries").getAsJsonArray();
                        for (JsonElement query : queries) {
                            KSQLQuery ksqlFunction = new KSQLQuery(query.getAsJsonObject(), ksqlDataSource, monitor);
                            result.add(ksqlFunction);
                        }
                    }
                }
                catch (Throwable e) {
                    throw new DBCException("Error reading KSQL active queries", e);
                }
                this.setCache(result);
            }
            return this.getCachedObjects();
        }
    }

    public class StreamCache
    extends BasicObjectCache<KSQLDataSource, KSQLStream> {
        @NotNull
        public List<KSQLStream> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable KSQLDataSource ksqlDataSource) throws DBException {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
                ArrayList<KSQLStream> result = new ArrayList<KSQLStream>();
                try {
                    List streamInfos = (List)((KSQLExecutionContext)KSQLDataSource.this.executionContext).getKsqlClient().listStreams().get(((KSQLExecutionContext)KSQLDataSource.this.executionContext).getRequestTimeout(), TimeUnit.SECONDS);
                    for (StreamInfo streamInfo : streamInfos) {
                        KSQLStream ksqlStream = new KSQLStream(ksqlDataSource, streamInfo, (KSQLExecutionContext)KSQLDataSource.this.executionContext, monitor);
                        result.add(ksqlStream);
                    }
                }
                catch (Throwable e) {
                    throw new DBCException("Error reading KSQL streams", e);
                }
                this.setCache(result);
            }
            return this.getCachedObjects();
        }
    }

    public class TableCache
    extends BasicObjectCache<KSQLDataSource, KSQLTable> {
        @NotNull
        public List<KSQLTable> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable KSQLDataSource dataSource) throws DBCException {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
                ArrayList<KSQLTable> result = new ArrayList<KSQLTable>();
                try {
                    List tables = (List)((KSQLExecutionContext)KSQLDataSource.this.executionContext).getKsqlClient().listTables().get(((KSQLExecutionContext)KSQLDataSource.this.executionContext).getRequestTimeout(), TimeUnit.SECONDS);
                    for (TableInfo tableInfo : tables) {
                        KSQLTable table = new KSQLTable(dataSource, tableInfo, (KSQLExecutionContext)KSQLDataSource.this.executionContext, monitor);
                        result.add(table);
                    }
                }
                catch (Throwable e) {
                    throw new DBCException("Error reading KSQL tables", e);
                }
                this.setCache(result);
            }
            return this.getCachedObjects();
        }
    }

    public class TopicCache
    extends BasicObjectCache<KSQLDataSource, KSQLTopic> {
        @NotNull
        public List<KSQLTopic> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable KSQLDataSource dataSource) throws DBCException {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            if (!this.isFullyCached()) {
                ArrayList<KSQLTopic> result = new ArrayList<KSQLTopic>();
                try {
                    List topicListings = (List)((KSQLExecutionContext)KSQLDataSource.this.executionContext).getKsqlClient().listTopics().get(((KSQLExecutionContext)KSQLDataSource.this.executionContext).getRequestTimeout(), TimeUnit.SECONDS);
                    for (TopicInfo tl : topicListings) {
                        KSQLTopic topic = new KSQLTopic(dataSource, tl);
                        result.add(topic);
                    }
                }
                catch (Throwable e) {
                    throw new DBCException("Error reading KSQL topics", e);
                }
                this.setCache(result);
            }
            return this.getCachedObjects();
        }
    }
}

