/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.kafka.exec;

import com.dbeaver.db.kafka.KSQLUtils;
import com.dbeaver.db.kafka.exec.KSQLMetaColumn;
import com.dbeaver.db.kafka.exec.KSQLSelectStatement;
import com.dbeaver.db.kafka.exec.KSQLSession;
import io.confluent.ksql.api.client.ColumnType;
import io.confluent.ksql.api.client.Row;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractResultSet;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetMeta;
import org.jkiss.dbeaver.model.qm.QMUtils;

public class KSQLPushResultSet
extends AbstractResultSet<KSQLSession, KSQLSelectStatement> {
    private final List<Row> results;
    private Iterator<Row> iterator;
    private Row curRow;
    private int rowCount = 0;
    private List<ColumnType> columnDefinitions;
    private List<String> columnNames;
    private LocalResultSetMeta metaData;

    public KSQLPushResultSet(@NotNull KSQLSelectStatement statement, @NotNull List<Row> results, long offset) {
        super((DBCSession)((KSQLSession)statement.getSession()), (DBCStatement)statement);
        this.results = results;
        this.iterator = this.results.iterator();
        if (offset > 0L) {
            long i = 0L;
            while (i < offset && this.iterator.hasNext()) {
                this.iterator.next();
                ++i;
            }
        }
    }

    public void close() {
        if (((KSQLSession)((KSQLSelectStatement)this.statement).getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetClose((DBCResultSet)this, (long)this.rowCount);
        }
    }

    @Nullable
    public Object getAttributeValue(int index) throws DBCException {
        ++index;
        if (this.curRow == null) {
            throw new DBCException("You have to fetch a row");
        }
        if (this.curRow.isNull(index)) {
            return null;
        }
        return this.getValue(index);
    }

    @Nullable
    private Object getValue(int index) {
        ColumnType columnType = this.columnDefinitions.get(index - 1);
        switch (columnType.getType()) {
            case ARRAY: {
                return this.curRow.getKsqlArray(index);
            }
            case BIGINT: {
                return this.curRow.getLong(index);
            }
            case BOOLEAN: {
                return this.curRow.getBoolean(index);
            }
            case BYTES: {
                return this.curRow.getBytes(index);
            }
            case DECIMAL: {
                return this.curRow.getDecimal(index);
            }
            case DOUBLE: {
                return this.curRow.getDouble(index);
            }
            case INTEGER: {
                return this.curRow.getInteger(index);
            }
            case STRING: {
                return this.curRow.getString(index);
            }
            case MAP: 
            case STRUCT: {
                return this.curRow.getKsqlObject(index);
            }
            case TIMESTAMP: 
            case DATE: 
            case TIME: {
                return this.curRow.getValue(index);
            }
        }
        return null;
    }

    @Nullable
    public Object getAttributeValue(String name) throws DBCException {
        if (this.curRow == null) {
            throw new DBCException("You have to fetch a row");
        }
        if (this.curRow.isNull(name)) {
            return null;
        }
        int index = -1;
        int i = 0;
        while (i < this.columnNames.size()) {
            if (name.equals(this.columnNames.get(i))) {
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            return null;
        }
        this.getValue(index);
        return null;
    }

    public boolean nextRow() throws DBCException {
        if (!this.iterator.hasNext()) {
            this.curRow = null;
            this.columnNames = null;
            this.columnDefinitions = null;
            return false;
        }
        this.curRow = this.iterator.next();
        this.columnDefinitions = this.curRow.columnTypes();
        this.columnNames = this.curRow.columnNames();
        ++this.rowCount;
        return true;
    }

    public Object getFeature(String name) {
        if (name.equals("local")) {
            return true;
        }
        return super.getFeature(name);
    }

    public boolean moveTo(int position) throws DBCException {
        this.iterator = this.results.iterator();
        if (position > 0) {
            int i = 0;
            while (i < position && this.iterator.hasNext()) {
                this.iterator.next();
                ++i;
            }
        }
        return true;
    }

    @NotNull
    public DBCResultSetMetaData getMeta() throws DBCException {
        if (this.metaData == null) {
            ArrayList<KSQLMetaColumn> attrs = new ArrayList<KSQLMetaColumn>();
            if (!this.results.isEmpty() && this.results.get(0) != null) {
                List names = this.results.get(0).columnNames();
                List types = this.results.get(0).columnTypes();
                int i = 0;
                while (i < names.size()) {
                    KSQLMetaColumn ksqlMetaColumn = new KSQLMetaColumn(this, i, (String)names.get(i), KSQLUtils.convertKSQLColumnType(((ColumnType)types.get(i)).getType()));
                    attrs.add(ksqlMetaColumn);
                    ++i;
                }
            }
            this.metaData = new LocalResultSetMeta(attrs);
        }
        return this.metaData;
    }

    public String getResultSetName() throws DBCException {
        return null;
    }
}

