/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.kafka.exec;

import com.dbeaver.db.kafka.exec.KSQLSession;
import com.dbeaver.db.kafka.model.KSQLDataSource;
import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.api.client.ClientOptions;
import io.confluent.ksql.api.client.ServerInfo;
import java.util.concurrent.TimeUnit;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCInvalidatePhase;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.utils.CommonUtils;

public class KSQLExecutionContext
extends AbstractExecutionContext<KSQLDataSource> {
    private static final Log log = Log.getLog(KSQLExecutionContext.class);
    private Client ksqlClient;

    public KSQLExecutionContext(KSQLDataSource dataSource, String purpose) {
        super((DBPDataSource)dataSource, purpose);
    }

    public Client getKsqlClient() {
        return this.ksqlClient;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((KSQLDataSource)this.dataSource).getContainer());
        try {
            try {
                monitor.subTask("Open Kafka session");
                ClientOptions clientOptions = this.buildClientOptions();
                System.setProperty("vertx.disableDnsResolver", "true");
                this.ksqlClient = Client.create((ClientOptions)clientOptions);
                monitor.subTask("Get cluster info");
                ServerInfo describeClusterResult = (ServerInfo)this.ksqlClient.serverInfo().get(this.getRequestTimeout(), TimeUnit.MILLISECONDS);
                log.debug((Object)("Connected to Kafka cluster " + describeClusterResult.getKafkaClusterId()));
                super.initContextBootstrap(monitor, true);
                ((KSQLDataSource)this.dataSource).addExecutionContext((DBCExecutionContext)this);
            }
            catch (Exception e) {
                if (this.ksqlClient != null) {
                    this.ksqlClient.close();
                    this.ksqlClient = null;
                }
                throw new DBCException((Throwable)e, (DBCExecutionContext)this);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((KSQLDataSource)this.dataSource).getContainer());
        }
    }

    @NotNull
    private ClientOptions buildClientOptions() {
        DBPConnectionConfiguration configuration = ((KSQLDataSource)this.dataSource).getContainer().getActualConnectionConfiguration();
        String nodeAddress = configuration.getHostName();
        int nodePort = CommonUtils.toInt((Object)configuration.getHostPort(), (int)8088);
        String userName = configuration.getUserName();
        String userPassword = configuration.getUserPassword();
        ClientOptions clientOptions = ClientOptions.create().setHost(nodeAddress).setPort(nodePort).setUseTls(false);
        if (!CommonUtils.isEmpty((String)userName)) {
            clientOptions.setBasicAuthCredentials(userName, userPassword);
        }
        return clientOptions;
    }

    public int getRequestTimeout() {
        return 10000;
    }

    @NotNull
    public KSQLSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new KSQLSession(monitor, purpose, taskTitle, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
        try {
            this.getKsqlClient().serverInfo().get(this.getRequestTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new DBException("Error pinging ksql", (Throwable)e);
        }
    }

    public DBSInstance getOwnerInstance() {
        return (DBSInstance)this.dataSource;
    }

    public boolean isConnected() {
        return false;
    }

    public void invalidateContext(@NotNull DBRProgressMonitor monitor, @NotNull DBCInvalidatePhase phase) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        KSQLExecutionContext kSQLExecutionContext = this;
        synchronized (kSQLExecutionContext) {
            if (this.ksqlClient != null) {
                this.ksqlClient.close();
                this.ksqlClient = null;
            }
            ((KSQLDataSource)this.dataSource).removeExecutionContext((DBCExecutionContext)this);
            super.closeContext();
        }
    }
}

