/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.OracleConnection;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.jdbc.DriverConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

public class OracleDriverConnectionFactoryAdapter
extends DriverConnectionFactoryAdapter {
    static final String CLASS_NAME = OracleDriverConnectionFactoryAdapter.class.getName();

    public OracleDriverConnectionFactoryAdapter(Driver driver, String url, Properties connectionFactoryProperties, Properties connectionProperties, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(driver, url, connectionFactoryProperties, connectionProperties, diagnosticsCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public Object createConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            void connectionRequestInfo;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleDriverConnectionFactoryAdapter", "createConnection", "entering args ({0})", null, null, connectionRetrievalInfo);
            String instanceName = connectionRequestInfo instanceof OracleJDBCConnectionRetrievalInfo ? ((OracleJDBCConnectionRetrievalInfo)connectionRequestInfo).getInstanceName() : null;
            Connection connection = null;
            try {
                if (null == instanceName || "".equals(instanceName)) {
                    this.trace(Level.FINEST, CLASS_NAME, "createConnection", "about to create connection without specifying instance", null, null, new Object[0]);
                    connection = (Connection)super.createConnection((ConnectionRetrievalInfo)connectionRequestInfo);
                } else {
                    Properties props = (Properties)this.m_connectionProperties.clone();
                    props.setProperty("oracle.jdbc.targetInstanceName", instanceName);
                    this.trace(Level.FINEST, CLASS_NAME, "createConnection", "about to create connection to the instance {0}", null, null, instanceName);
                    Driver driver = this.m_driver;
                    synchronized (driver) {
                        connection = this.m_driver.connect(this.m_url, props);
                    }
                    if (connection instanceof OracleConnection) {
                        String in = ((OracleConnection)connection).getServerSessionInfo().getProperty("INSTANCE_NAME");
                        assert (null != in);
                        assert (Util.equalsNormalized(in, instanceName)) : "internal error: got connection from the wrong instance";
                        if (!Util.equalsNormalized(in, instanceName)) {
                            this.trace(Level.FINEST, CLASS_NAME, "createConnection", "wrong conn opened, desired: {0}, actual: {1}", null, null, instanceName, in);
                        }
                    } else {
                        this.trace(Level.FINEST, CLASS_NAME, "createConnection", "not an oracle connection", null, null, new Object[0]);
                    }
                }
                if (null != connection) {
                    this.onSuccessfulConnectionCreation(connection);
                }
            }
            catch (Throwable e) {
                this.onFailedConnectionCreation(e);
                this.trace(Level.WARNING, CLASS_NAME, "createConnection", "", null, e, new Object[0]);
                if (null != connection) {
                    this.closeConnection(connection);
                }
                UCPErrorHandler.throwUniversalConnectionPoolException(257, e);
            }
            Connection connection2 = connection;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleDriverConnectionFactoryAdapter", "createConnection", "returning {0}", null, null, connection2);
            return connection2;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleDriverConnectionFactoryAdapter", "createConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public UniversalPooledConnection createPooledConnection(Object object, ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            void connectionRequestInfo;
            void connection;
            OracleUniversalPooledConnection pooledConnection;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleDriverConnectionFactoryAdapter", "createPooledConnection", "entering args ({0}, {1})", null, null, object, connectionRetrievalInfo);
            JDBCConnectionPool jdbccp = (JDBCConnectionPool)this.getUniversalConnectionPool();
            OracleUniversalPooledConnection oracleUniversalPooledConnection = pooledConnection = new OracleUniversalPooledConnection(jdbccp, (Object)connection, (ConnectionRetrievalInfo)connectionRequestInfo, jdbccp.isFailoverEnabled());
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleDriverConnectionFactoryAdapter", "createPooledConnection", "returning {0}", null, null, oracleUniversalPooledConnection);
            return oracleUniversalPooledConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleDriverConnectionFactoryAdapter", "createPooledConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }
}

