/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.datasource.impl.OracleConnectionBuilderImpl;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.jdbc.UCPConnectionBuilder;
import oracle.ucp.logging.annotations.Blind;
import oracle.ucp.util.OpaqueString;

public abstract class UCPConnectionBuilderImpl
implements UCPConnectionBuilder {
    private String user;
    private OpaqueString password;
    protected Properties labels = null;
    private String serviceName;
    protected int proxyType = -1;
    protected Properties proxyProperties;
    protected OracleShardingKey shardingKey = null;
    protected OracleShardingKey superShardingKey = null;
    private Properties pdbRoles;
    private SSLContext sslContext;
    private PoolDataSource.HostnameResolver hostNameResolver;
    private boolean readOnlyInstanceAllowed;
    protected Executor executor = ForkJoinPool.commonPool();

    public UCPConnectionBuilderImpl(PoolDataSourceImpl pds) {
        this.user = pds.getUser();
        this.password = pds.getPasswordInternal();
        this.pdbRoles = pds.getPdbRoles();
        this.sslContext = pds.getSSLContext();
        this.hostNameResolver = pds.getHostnameResolver();
        this.readOnlyInstanceAllowed = pds.isReadOnlyInstanceAllowed();
    }

    @Override
    public UCPConnectionBuilder user(String user) {
        this.user = user;
        return this;
    }

    @Override
    public UCPConnectionBuilder password(@Blind String password) {
        this.password = OpaqueString.newOpaqueString(password);
        return this;
    }

    UCPConnectionBuilder internalPassword(OpaqueString password) {
        this.password = password;
        return this;
    }

    @Override
    public UCPConnectionBuilder labels(Properties labels) {
        this.labels = labels;
        return this;
    }

    @Override
    public UCPConnectionBuilder serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public UCPConnectionBuilder proxyProperties(int proxyType, Properties proxyProperties) {
        this.proxyType = proxyType;
        this.proxyProperties = proxyProperties;
        return this;
    }

    @Override
    public UCPConnectionBuilder shardingKey(OracleShardingKey shardingKey) {
        this.shardingKey = shardingKey;
        return this;
    }

    @Override
    public UCPConnectionBuilder superShardingKey(OracleShardingKey superShardingKey) {
        if (superShardingKey != null) {
            ((OracleShardingKeyImpl)superShardingKey).markSuperShardingKey(true);
        }
        this.superShardingKey = superShardingKey;
        return this;
    }

    @Override
    public UCPConnectionBuilder pdbRoles(Properties pdbRoles) {
        this.pdbRoles = pdbRoles;
        return this;
    }

    UCPConnectionBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    UCPConnectionBuilder hostnameResolver(PoolDataSource.HostnameResolver hostnameResolver) {
        this.hostNameResolver = hostnameResolver;
        return this;
    }

    UCPConnectionBuilder readOnlyInstanceAllowed(boolean readOnlyInstanceAllowed) {
        this.readOnlyInstanceAllowed = readOnlyInstanceAllowed;
        return this;
    }

    @Override
    public abstract Connection build() throws SQLException;

    OracleConnectionBuilderImpl getUpdatedBuilderForAC(OracleConnectionBuilderImpl connectionBuilder) {
        return (OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)connectionBuilder.serviceName(this.getServiceName())).shardingKey(this.shardingKey)).superShardingKey(this.superShardingKey);
    }

    @Override
    public UCPConnectionBuilder executor(Executor executor) {
        if (Objects.isNull(executor)) {
            throw new IllegalArgumentException("executor should not be null");
        }
        this.executor = executor;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    OpaqueString getPassword() {
        return this.password;
    }

    String getServiceName() {
        return this.serviceName;
    }

    Properties getPdbRoles() {
        return this.pdbRoles;
    }

    SSLContext getSslContext() {
        return this.sslContext;
    }

    PoolDataSource.HostnameResolver getHostnameResolver() {
        return this.hostNameResolver;
    }

    boolean isReadOnlyInstanceAllowed() {
        return this.readOnlyInstanceAllowed;
    }
}

