/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.tasks.ui;

import com.dbeaver.ee.tasks.CompositeTaskSettings;
import com.dbeaver.ee.tasks.ui.CompositeTaskWizardPageSettings;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;

class CompositeTaskWizard
extends TaskConfigurationWizard<CompositeTaskSettings> {
    private CompositeTaskWizardPageSettings settingsPage;
    private final CompositeTaskSettings settings = new CompositeTaskSettings();

    CompositeTaskWizard() {
    }

    CompositeTaskWizard(@NotNull DBTTask task) {
        super(task);
        this.settings.loadConfiguration(task.getProperties(), task.getProject());
    }

    protected String getDefaultWindowTitle() {
        return "Composite task";
    }

    public String getTaskTypeId() {
        return "composite";
    }

    public void saveTaskState(DBRRunnableContext runnableContext, DBTTask task, Map<String, Object> state) {
        this.settingsPage.saveState();
        this.settings.saveConfiguration(state);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.settingsPage = new CompositeTaskWizardPageSettings();
    }

    public void addPages() {
        this.addTaskConfigPages();
        this.addPage((IWizardPage)this.settingsPage);
    }

    public CompositeTaskSettings getSettings() {
        return this.settings;
    }
}

