/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qm.db.impl;

import com.dbeaver.ee.qm.db.impl.DataSourceInfo;
import com.dbeaver.ee.qm.db.impl.QMDBEventCursor;
import com.dbeaver.ee.qm.db.impl.QMDBModel;
import com.dbeaver.ee.qm.db.impl.QMDBUserSessionRecord;
import com.dbeaver.ee.qm.db.model.QMDBUtils;
import com.dbeaver.model.qm.QMEventManager;
import com.dbeaver.model.qm.QMService;
import com.dbeaver.model.qm.ai.QMAIChatMessage;
import com.dbeaver.model.qm.ai.QMAIChatRole;
import com.dbeaver.model.qm.ai.QMAIChatStorage;
import com.dbeaver.model.qm.ai.QMAIContext;
import com.dbeaver.model.qm.ai.QMAIContextObject;
import com.dbeaver.model.qm.ai.QMAIContextObjectType;
import com.dbeaver.model.qm.ai.QMAIConversationHistory;
import com.dbeaver.model.qm.ai.QMAIDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPConnectionInformation;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCTransaction;
import org.jkiss.dbeaver.model.qm.QMDisposable;
import org.jkiss.dbeaver.model.qm.QMEventAction;
import org.jkiss.dbeaver.model.qm.QMEventCursor;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMSessionInfo;
import org.jkiss.dbeaver.model.qm.QMSessionProvider;
import org.jkiss.dbeaver.model.qm.QMTranslationHistoryItem;
import org.jkiss.dbeaver.model.qm.filters.QMAdminCursorFilter;
import org.jkiss.dbeaver.model.qm.filters.QMCursorFilter;
import org.jkiss.dbeaver.model.qm.filters.QMQueryFilter;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMDataSourceConnectErrorInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMDataSourceInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMProjectInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMUserInfo;
import org.jkiss.dbeaver.model.rm.RMUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.LongKeyMap;

public class QMEmbeddedService
implements QMService,
QMDisposable,
QMEventManager,
QMAIChatStorage {
    private static final Log log = Log.getLog(QMEmbeddedService.class);
    private static final int QM_SESSION_ID_WAITING_TIME = 300000;
    public static final String BOOL_YES = "Y";
    public static final String BOOL_NO = "N";
    public static final int CAPTION_MAX_LENGTH = 100;
    public static final int PROMPT_ID_MAX_LENGTH = 32;
    public static final int DATASOURCE_ID_MAX_LENGTH = 100;
    private final Map<String, Long> connectionMap = new HashMap<String, Long>();
    private final Map<String, DataSourceInfo> dataSourceCache = new HashMap<String, DataSourceInfo>();
    private final LongKeyMap<QMMConnectionInfo> connectionCache = new LongKeyMap();
    private final LongKeyMap<QMMProjectInfo> projectCache = new LongKeyMap();
    private final Map<String, QMDBUserSessionRecord> qmUserSessionCache = new WeakHashMap<String, QMDBUserSessionRecord>();
    private final Map<String, Long> projectIdsCache = new HashMap<String, Long>();
    private volatile QMDBModel qmdbModel;

    @NotNull
    public List<QMAIConversationHistory> findConversations(@NotNull String sessionId) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection connection = this.getModel().getDatabaseConnection();){
                ResultSet rs;
                Object var11_20;
                Throwable throwable2;
                PreparedStatement dbStat;
                QMMUserInfo userInfo = this.getUserBySession(sessionId, this.getModel(), connection);
                if ("@anonymous@".equals(userInfo.userName())) {
                    return Collections.emptyList();
                }
                LinkedHashMap<String, QMAIConversationHistory> chats = new LinkedHashMap<String, QMAIConversationHistory>();
                Throwable throwable3 = null;
                Object var8_13 = null;
                try {
                    dbStat = connection.prepareStatement("  SELECT *\n  FROM {table_prefix}QM_AI_CONVERSATION\n  WHERE USER_ID = ?\n  AND IS_DELETED <> 'Y'\n  ORDER BY LAST_MESSAGE_AT DESC\n");
                    try {
                        dbStat.setLong(1, userInfo.userId());
                        throwable2 = null;
                        var11_20 = null;
                        try {
                            rs = dbStat.executeQuery();
                            try {
                                while (rs.next()) {
                                    QMAIConversationHistory conversationHistory = this.mapRowToChatHistory(rs);
                                    chats.put(conversationHistory.getId(), conversationHistory);
                                }
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable3 == null) {
                        throwable3 = throwable5;
                    } else if (throwable3 != throwable5) {
                        throwable3.addSuppressed(throwable5);
                    }
                    throw throwable3;
                }
                throwable3 = null;
                var8_13 = null;
                try {
                    dbStat = connection.prepareStatement("SELECT *\nFROM {table_prefix}QM_AI_CONVERSATION C\nRIGHT JOIN {table_prefix}QM_AI_CONVERSATION_MESSAGE M ON M.CONVERSATION_ID = C.CONVERSATION_ID AND M.IS_DELETED <> 'Y'\nWHERE C.USER_ID = ? AND C.IS_DELETED <> 'Y'\nORDER BY M.CONVERSATION_ID,M.MESSAGE_ID\n");
                    try {
                        dbStat.setLong(1, userInfo.userId());
                        throwable2 = null;
                        var11_20 = null;
                        try {
                            rs = dbStat.executeQuery();
                            try {
                                while (rs.next()) {
                                    String convId = rs.getString("CONVERSATION_ID");
                                    QMAIConversationHistory chat = (QMAIConversationHistory)chats.get(convId);
                                    if (chat == null) {
                                        log.debug((Object)("Chat conversation '" + convId + "' not found"));
                                        continue;
                                    }
                                    chat.getMessages().add(this.mapRowToChatMessage(rs));
                                }
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable3 == null) {
                        throwable3 = throwable7;
                    } else if (throwable3 != throwable7) {
                        throwable3.addSuppressed(throwable7);
                    }
                    throw throwable3;
                }
                return new ArrayList<QMAIConversationHistory>(chats.values());
            }
            catch (Throwable throwable8) {
                if (throwable == null) {
                    throwable = throwable8;
                } else if (throwable != throwable8) {
                    throwable.addSuppressed(throwable8);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error loading AI chat history", (Throwable)e);
        }
    }

    public void saveConversation(@NotNull String sessionId, @NotNull QMAIConversationHistory chat) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = this.getModel().getDatabaseConnection();){
                String userName = this.getUserBySession(sessionId, this.getModel(), connection).userName();
                if ("@anonymous@".equals(userName)) {
                    return;
                }
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (JDBCTransaction txn = new JDBCTransaction(connection);){
                    this.saveAIChatMeta(sessionId, connection, chat);
                    this.saveAIChatMessages(connection, chat.getId(), chat.getMessages());
                    this.saveAIChatContext(connection, chat.getId(), chat.getContext().getObjects());
                    txn.commit();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error saving AI chat: " + e.getMessage(), (Throwable)e);
        }
    }

    public void appendMessages(@NotNull String conversationId, @NotNull List<QMAIChatMessage> messages) throws DBException {
        if (messages.isEmpty()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = this.getModel().getDatabaseConnection();){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCTransaction txn = new JDBCTransaction(connection);){
                    this.saveAIChatMessages(connection, conversationId, messages);
                    this.updateLastMessageAt(connection, conversationId, messages.getLast().timestamp());
                    this.updateNextMessageId(connection, conversationId, messages.getLast().id() + 1);
                    txn.commit();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error appending AI chat messages: " + e.getMessage(), (Throwable)e);
        }
    }

    private void updateNextMessageId(@NotNull Connection connection, @NotNull String conversationId, int messageId) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PreparedStatement dbStat = connection.prepareStatement("UPDATE {table_prefix}QM_AI_CONVERSATION SET NEXT_MESSAGE_ID = ? WHERE CONVERSATION_ID = ?");){
                dbStat.setInt(1, messageId);
                dbStat.setString(2, conversationId);
                dbStat.executeUpdate();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error updating AI chat next message id: " + e.getMessage(), (Throwable)e);
        }
    }

    public void deleteMessage(@NotNull String conversationId, int messageId) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = this.getModel().getDatabaseConnection();){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (PreparedStatement dbStat = connection.prepareStatement("DELETE FROM {table_prefix}QM_AI_CONVERSATION_MESSAGE WHERE CONVERSATION_ID = ? AND MESSAGE_ID = ?");){
                    dbStat.setString(1, conversationId);
                    dbStat.setInt(2, messageId);
                    dbStat.executeUpdate();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error deleting AI chat message: " + e.getMessage(), (Throwable)e);
        }
    }

    public void extendContext(@NotNull String conversationId, @NotNull Set<QMAIContextObject> extra) throws DBException {
        if (extra.isEmpty()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = this.getModel().getDatabaseConnection();){
                this.saveAIChatContext(connection, conversationId, extra);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error extending AI chat context: " + e.getMessage(), (Throwable)e);
        }
    }

    public void deleteConversation(@NotNull String conversationId) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection connection = this.getModel().getDatabaseConnection();){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (PreparedStatement dbStat = connection.prepareStatement("UPDATE {table_prefix}QM_AI_CONVERSATION SET IS_DELETED = 'Y' WHERE CONVERSATION_ID = ?");){
                    dbStat.setString(1, conversationId);
                    dbStat.executeUpdate();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error soft deleting AI chat: " + e.getMessage(), (Throwable)e);
        }
    }

    public void renameConversation(@NotNull String conversationId, @NotNull String newName) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = this.getModel().getDatabaseConnection();){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (PreparedStatement dbStat = connection.prepareStatement("UPDATE {table_prefix}QM_AI_CONVERSATION SET CAPTION = ? WHERE CONVERSATION_ID = ?");){
                    dbStat.setString(1, CommonUtils.truncateString((String)newName, (int)100));
                    dbStat.setString(2, conversationId);
                    dbStat.executeUpdate();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error renaming AI chat: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    private boolean isChatSaved(@NotNull Connection connection, @NotNull String sessionId, @NotNull String conversationId) throws SQLException, DBException {
        long userId = this.getUserBySession(sessionId, this.getModel(), connection).userId();
        String sql = "    SELECT 1\n    FROM {table_prefix}QM_AI_CONVERSATION\n    WHERE CONVERSATION_ID = ? AND USER_ID = ?\n";
        Throwable throwable = null;
        Object var8_8 = null;
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            boolean bl;
            ResultSet rs;
            Throwable throwable2;
            block19: {
                ps.setMaxRows(1);
                ps.setString(1, conversationId);
                ps.setLong(2, userId);
                throwable2 = null;
                Object var11_13 = null;
                rs = ps.executeQuery();
                bl = rs.next();
                if (rs == null) break block19;
                rs.close();
            }
            return bl;
            {
                catch (Throwable throwable3) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private void saveAIChatMeta(@NotNull String sessionId, @NotNull Connection dbConnection, @NotNull QMAIConversationHistory chat) throws SQLException, DBException {
        block19: {
            Timestamp lastMessageAtTs;
            QMMUserInfo userInfo = this.getUserBySession(sessionId, this.getModel(), dbConnection);
            Instant lastMessageAt = chat.getMessages().isEmpty() ? null : ((QMAIChatMessage)chat.getMessages().getLast()).timestamp();
            Timestamp timestamp = lastMessageAtTs = lastMessageAt == null ? null : Timestamp.from(lastMessageAt);
            if (this.isChatSaved(dbConnection, sessionId, chat.getId())) {
                Throwable throwable = null;
                Object var8_11 = null;
                try (PreparedStatement dbStat = dbConnection.prepareStatement("UPDATE {table_prefix}QM_AI_CONVERSATION\n    SET\n        CAPTION = ?,\n        CONTEXT_JSON = ?,\n        LAST_MESSAGE_AT = ?,\n        NEXT_MESSAGE_ID = ?,\n        IS_DELETED = ?\n    WHERE CONVERSATION_ID = ?\n");){
                    dbStat.setString(1, CommonUtils.truncateString((String)chat.getCaption(), (int)100));
                    dbStat.setString(2, chat.getContext().getContextJson());
                    dbStat.setTimestamp(3, lastMessageAtTs);
                    dbStat.setInt(4, chat.getNextMessageId());
                    dbStat.setString(5, chat.isDeleted() ? BOOL_YES : BOOL_NO);
                    dbStat.setString(6, chat.getId());
                    dbStat.executeUpdate();
                    break block19;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            Throwable throwable = null;
            Object var8_13 = null;
            try (PreparedStatement dbStat = dbConnection.prepareStatement("INSERT INTO {table_prefix}QM_AI_CONVERSATION\n    (CONVERSATION_ID, DATASOURCE_ID, USER_ID, CAPTION, PROMPT_ID, CONTEXT_JSON, LAST_MESSAGE_AT, NEXT_MESSAGE_ID, IS_DELETED)\nVALUES\n    (?, ?, ?, ?, ?, ?, ?, ?, ?)\n");){
                dbStat.setString(1, chat.getId());
                dbStat.setString(2, CommonUtils.truncateString((String)(chat.getDataSource() != null ? chat.getDataSource().asString() : null), (int)100));
                dbStat.setLong(3, userInfo.userId());
                dbStat.setString(4, CommonUtils.truncateString((String)chat.getCaption(), (int)100));
                dbStat.setString(5, CommonUtils.truncateString((String)chat.getPromptGeneratorId(), (int)32));
                dbStat.setString(6, chat.getContext().getContextJson());
                dbStat.setTimestamp(7, lastMessageAtTs);
                dbStat.setInt(8, chat.getNextMessageId());
                dbStat.setString(9, chat.isDeleted() ? BOOL_YES : BOOL_NO);
                dbStat.executeUpdate();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    private void saveAIChatMessages(@NotNull Connection connection, @NotNull String conversationId, @NotNull List<QMAIChatMessage> messages) throws SQLException {
        Set<Integer> savedMessageIds = this.getSavedMessageIds(connection, conversationId);
        List<QMAIChatMessage> messagesToSave = messages.stream().filter(it -> !savedMessageIds.contains(it.id())).toList();
        if (messagesToSave.isEmpty()) {
            return;
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO {table_prefix}QM_AI_CONVERSATION_MESSAGE\n    (CONVERSATION_ID, MESSAGE_ID, MESSAGE_ROLE, CONTENT, DISPLAY_MESSAGE, SENT_AT, IS_DELETED)\nVALUES\n    (?, ?, ?, ?, ?, ?, ?)\n");){
            for (QMAIChatMessage message : messagesToSave) {
                statement.setString(1, conversationId);
                statement.setInt(2, message.id());
                statement.setString(3, message.role().name());
                String content = message.content();
                String displayMessage = message.displayMessage();
                statement.setString(4, content);
                statement.setString(5, CommonUtils.equalObjects((Object)displayMessage, (Object)content) ? null : displayMessage);
                statement.setTimestamp(6, Timestamp.from(message.timestamp()));
                statement.setString(7, message.deleted() ? BOOL_YES : BOOL_NO);
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    private Set<Integer> getSavedMessageIds(@NotNull Connection connection, @NotNull String conversationId) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement dbStat = connection.prepareStatement("SELECT message_id FROM {table_prefix}QM_AI_CONVERSATION_MESSAGE\nWHERE CONVERSATION_ID = ? AND IS_DELETED <> 'Y'\n");){
            HashSet<Integer> hashSet;
            ResultSet rs;
            Throwable throwable2;
            block20: {
                dbStat.setString(1, conversationId);
                throwable2 = null;
                Object var7_10 = null;
                rs = dbStat.executeQuery();
                HashSet<Integer> messageIds = new HashSet<Integer>();
                while (rs.next()) {
                    messageIds.add(rs.getInt(1));
                }
                hashSet = messageIds;
                if (rs == null) break block20;
                rs.close();
            }
            return hashSet;
            {
                catch (Throwable throwable3) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private Set<QMAIContextObject> getAIChatContext(@NotNull Connection connection, @NotNull String conversationId) throws SQLException {
        HashSet<QMAIContextObject> contextObjects = new HashSet<QMAIContextObject>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (PreparedStatement dbStat = connection.prepareStatement("SELECT OBJECT_NAME, OBJECT_TYPE\nFROM {table_prefix}QM_AI_CONTEXT_HISTORY\nWHERE CONVERSATION_ID = ?\n");){
            dbStat.setString(1, conversationId);
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (ResultSet rs = dbStat.executeQuery();){
                while (rs.next()) {
                    contextObjects.add(new QMAIContextObject(rs.getString(1), QMAIContextObjectType.valueOf((String)rs.getString(2))));
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return contextObjects;
    }

    private void saveAIChatContext(@NotNull Connection connection, @NotNull String conversationId, @NotNull Set<QMAIContextObject> contextObjects) throws SQLException {
        Set<QMAIContextObject> saved = this.getAIChatContext(connection, conversationId);
        HashSet<QMAIContextObject> toSave = new HashSet<QMAIContextObject>(contextObjects);
        toSave.removeAll(saved);
        if (toSave.isEmpty()) {
            return;
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO {table_prefix}QM_AI_CONTEXT_HISTORY (CONVERSATION_ID, OBJECT_NAME, OBJECT_TYPE)\nVALUES (?, ?, ?)\n");){
            for (QMAIContextObject contextObject : toSave) {
                statement.setString(1, conversationId);
                statement.setString(2, contextObject.name());
                statement.setString(3, contextObject.type().name());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateLastMessageAt(@NotNull Connection connection, @NotNull String conversationId, @NotNull Instant lastMessageAt) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (PreparedStatement statement = connection.prepareStatement("UPDATE {table_prefix}QM_AI_CONVERSATION SET LAST_MESSAGE_AT = ? WHERE CONVERSATION_ID = ?\n");){
            statement.setTimestamp(1, Timestamp.from(lastMessageAt));
            statement.setString(2, conversationId);
            statement.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected synchronized QMDBModel getModel() {
        if (this.qmdbModel == null) {
            this.qmdbModel = QMDBModel.getInstance();
        }
        return this.qmdbModel;
    }

    @NotNull
    public QMEventCursor getQueryHistoryCursor(@NotNull QMCursorFilter cursorFilter) throws DBException {
        QMDBModel model = this.getModel();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection dbCon = model.getDatabaseConnection();){
                String qmAppSessionId = cursorFilter.getSessionId();
                if (CommonUtils.isEmpty((String)qmAppSessionId) && DBWorkbench.getPlatform().getApplication() instanceof QMSessionProvider) {
                    qmAppSessionId = this.tryToGetQmSessionId();
                }
                if (qmAppSessionId == null) {
                    throw new DBException("Cannot find QM session info");
                }
                QMDBUserSessionRecord userSessionRecord = this.getUserSessionRecord(dbCon, qmAppSessionId);
                String userName = this.getUserBySession(qmAppSessionId, model, dbCon).userName();
                if ("@anonymous@".equals(userName)) {
                    cursorFilter.getCriteria().setSessionId(userSessionRecord.sessionId());
                }
                QMAdminCursorFilter adminFilter = new QMAdminCursorFilter(cursorFilter, Set.of(userName));
                return this.getAdminQueryHistoryCursor(adminFilter);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error getting cursor:" + e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    public QMEventCursor getAdminQueryHistoryCursor(@NotNull QMAdminCursorFilter cursorFilter) throws DBException {
        try {
            return new QMDBEventCursor(this, cursorFilter.getAdminCriteria(), cursorFilter.getFilter(), this.getModel());
        }
        catch (SQLException e) {
            throw new DBException("Error getting filter history", (Throwable)e);
        }
    }

    @NotNull
    public QMEventCursor getSupervisorQueryHistoryCursor(@NotNull QMAdminCursorFilter cursorFilter) throws DBException {
        return this.getAdminQueryHistoryCursor(cursorFilter);
    }

    /*
     * Exception decompiling
     */
    public void saveEvents(List<QMMetaEvent> events) throws DBException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 13[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void saveQmMetaObjectInfo(@NotNull Connection dbCon, @NotNull QMDBUserSessionRecord record, @NotNull QMMObject object, @NotNull QMMetaEvent event) throws SQLException, DBException {
        if (object instanceof QMMConnectionInfo) {
            QMMConnectionInfo connectionInfo = (QMMConnectionInfo)object;
            this.saveConnectionInfo(dbCon, record, connectionInfo, event);
        } else if (object instanceof QMMTransactionInfo) {
            QMMTransactionInfo transactionInfo = (QMMTransactionInfo)object;
            this.saveTransactionInfo(dbCon, record, transactionInfo, event);
        } else if (object instanceof QMMStatementExecuteInfo) {
            QMMStatementExecuteInfo statementExecuteInfo = (QMMStatementExecuteInfo)object;
            this.saveStatementExecutionInfo(dbCon, record, statementExecuteInfo, event);
        }
    }

    private void saveTransactionInfo(Connection dbConnection, QMDBUserSessionRecord record, QMMTransactionInfo transactionInfo, QMMetaEvent event) throws DBException, SQLException {
        this.createEventInfo(dbConnection, record, (QMMObject)transactionInfo, event, transactionInfo.getConnection());
    }

    private void saveConnectionInfo(Connection dbConnection, QMDBUserSessionRecord record, QMMConnectionInfo connectionInfo, QMMetaEvent event) throws SQLException, DBException {
        QMEventAction action = event.getAction();
        if (action != QMEventAction.BEGIN && action != QMEventAction.END) {
            return;
        }
        if (action == QMEventAction.BEGIN) {
            this.saveOpenConnectionInfo(dbConnection, record, connectionInfo);
        }
        this.createEventInfo(dbConnection, record, (QMMObject)connectionInfo, event, connectionInfo);
        if (action == QMEventAction.END) {
            this.closeConnectionInfo(dbConnection, record.sessionId(), connectionInfo);
        }
    }

    private void saveStatementExecutionInfo(Connection dbConnection, QMDBUserSessionRecord record, QMMStatementExecuteInfo executeInfo, QMMetaEvent event) throws DBException, SQLException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (PreparedStatement dbStatStatement = dbConnection.prepareStatement("INSERT INTO {table_prefix}QM_STATEMENT (STATEMENT_ID,STATEMENT_PURPOSE,QUERY_ID,ROW_COUNT,ERROR_CODE,ERROR_MESSAGE,EXECUTE_TIME,FETCH_TIME,QUERY_SCHEMA,QUERY_CATALOG) VALUES(?,?,?,?,?,?,?,?,?,?)");){
            long eventId = this.createEventInfo(dbConnection, record, (QMMObject)executeInfo, event, executeInfo.getStatement().getConnection());
            if (eventId == -1L) {
                return;
            }
            if (event.getAction() != QMEventAction.END) {
                return;
            }
            long queryId = this.getQueryId(record.userInfo().userId(), executeInfo.getQueryString());
            dbStatStatement.setLong(1, eventId);
            dbStatStatement.setInt(2, executeInfo.getStatement().getPurpose().getId());
            dbStatStatement.setLong(3, queryId);
            long rowCount = executeInfo.getUpdateRowCount();
            if (rowCount < 0L) {
                rowCount = executeInfo.getFetchRowCount();
            }
            dbStatStatement.setLong(4, rowCount);
            dbStatStatement.setInt(5, executeInfo.getErrorCode());
            if (CommonUtils.isEmpty((String)executeInfo.getErrorMessage())) {
                dbStatStatement.setNull(6, 12);
            } else {
                dbStatStatement.setString(6, executeInfo.getErrorMessage());
            }
            dbStatStatement.setInt(7, (int)(executeInfo.getCloseTime() - executeInfo.getOpenTime()));
            long fetchEndTime = executeInfo.getFetchEndTime();
            dbStatStatement.setInt(8, (int)(fetchEndTime > 0L ? fetchEndTime - executeInfo.getFetchBeginTime() : 0L));
            dbStatStatement.setString(9, executeInfo.getSchema());
            dbStatStatement.setString(10, executeInfo.getCatalog());
            dbStatStatement.execute();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public Collection<String> getQueryFilterHistory(@NotNull String sessionId, @NotNull String query) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void saveQueryFilterValue(@NotNull String sessionId, @NotNull QMQueryFilter queryFilter) throws DBException {
        try {
            String query = queryFilter.getQuery();
            String filterValue = queryFilter.getFilterValue();
            QMDBModel model = this.getModel();
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection dbCon = model.getDatabaseConnection();){
                long userId = this.getUserBySession(sessionId, model, dbCon).userId();
                long queryId = this.getQueryId(userId, query);
                long filterHash = QMDBUtils.getHashCode(filterValue);
                String sqlUpdate = "UPDATE {table_prefix}QM_QUERY_FILTER SET FILTER_TEXT=? WHERE QUERY_ID=? AND FILTER_HASH=?";
                int updatedRows = JDBCUtils.executeUpdate((Connection)dbCon, (String)sqlUpdate, (Object[])new Object[]{filterValue, queryId, filterHash});
                if (updatedRows != 1) {
                    String sqlInsert = "INSERT INTO {table_prefix}QM_QUERY_FILTER (QUERY_ID,FILTER_HASH,FILTER_TEXT)  VALUES(?,?,?)";
                    JDBCUtils.executeInsertAutoIncrement((Connection)dbCon, (String)sqlInsert, (String)"FILTER_ID", (Object[])new Object[]{queryId, filterHash, filterValue});
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error saving filter history", (Throwable)e);
        }
    }

    public void deleteQueryFilterValue(@NotNull String sessionId, @NotNull QMQueryFilter queryFilter) throws DBException {
        try {
            QMDBModel model = this.getModel();
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection dbCon = model.getDatabaseConnection();){
                long userId = this.getUserBySession(sessionId, model, dbCon).userId();
                long queryId = this.getQueryId(userId, queryFilter.getQuery());
                long filterHash = QMDBUtils.getHashCode(queryFilter.getFilterValue());
                Throwable throwable2 = null;
                Object var14_15 = null;
                try (PreparedStatement dbStat = dbCon.prepareStatement("DELETE FROM {table_prefix}QM_QUERY_FILTER WHERE QUERY_ID=? AND FILTER_HASH=? AND (USER_ID IS NULL OR USER_ID=?)");){
                    dbStat.setLong(1, queryId);
                    dbStat.setLong(2, filterHash);
                    dbStat.setLong(2, userId);
                    dbStat.execute();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error deleting filter history", (Throwable)e);
        }
    }

    private long createEventInfo(Connection dbConnection, QMDBUserSessionRecord record, QMMObject object, QMMetaEvent event, QMMConnectionInfo connectionInfo) throws SQLException, DBException {
        PreparedStatement dbStatEvent = dbConnection.prepareStatement("INSERT INTO {table_prefix}QM_EVENT (CONNECTION_ID,SOURCE_ID,EVENT_ACTION,EVENT_TYPE,EVENT_TIME,USER_ID) VALUES(?,?,?,?,?,?)", JDBCUtils.getColumnList((String)"EVENT_ID"));
        Long connectionId = this.getConnectionId(dbConnection, record.sessionId(), connectionInfo);
        if (connectionId == null) {
            log.debug((Object)("Can't find QMDB connection info " + connectionInfo.getContainerId() + " for event " + String.valueOf(event.getAction()) + "."));
            return -1L;
        }
        dbStatEvent.setLong(1, connectionId);
        dbStatEvent.setNull(2, 12);
        dbStatEvent.setInt(3, event.getAction().getId());
        dbStatEvent.setInt(4, this.getEventTypeId(object));
        if (event.getTimestamp() <= 0L) {
            dbStatEvent.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
            log.debug((Object)(String.valueOf(connectionId) + ":" + connectionInfo.getProjectInfo().getId() + ":" + connectionInfo.getConnectionUserName() + " .Incorrect date for connection close. Connection reopen"));
        } else {
            dbStatEvent.setTimestamp(5, new Timestamp(event.getTimestamp()));
        }
        dbStatEvent.setLong(6, record.userInfo().userId());
        dbStatEvent.execute();
        return JDBCUtils.getGeneratedKey((PreparedStatement)dbStatEvent);
    }

    private int getEventTypeId(QMMObject object) {
        Class<?> eventClass = object.getClass();
        if (eventClass == QMMConnectionInfo.class) {
            return 1;
        }
        if (eventClass == QMMTransactionInfo.class) {
            return 2;
        }
        if (eventClass == QMMTransactionSavepointInfo.class) {
            return 3;
        }
        if (eventClass == QMMStatementInfo.class) {
            return 4;
        }
        if (eventClass == QMMStatementExecuteInfo.class) {
            return 5;
        }
        return -1;
    }

    private long saveOpenConnectionInfo(Connection dbConnection, QMDBUserSessionRecord record, QMMConnectionInfo connectionInfo) throws SQLException, DBException {
        QMDBModel model = this.getModel();
        Long projectId = this.getProjectId(connectionInfo);
        Long connectionId = this.getConnectionId(dbConnection, record.sessionId(), connectionInfo);
        if (connectionId != null) {
            log.debug((Object)"Connection info already exists. Mixed events?");
            return connectionId;
        }
        this.createDataSourceIfNeeded(model, dbConnection, (QMMDataSourceInfo)connectionInfo);
        connectionId = JDBCUtils.executeInsertAutoIncrement((Connection)dbConnection, (String)"INSERT INTO {table_prefix}QM_CONNECTION (RUN_ID,WORKSPACE_ID,PROJECT_ID,DATASOURCE_ID,SESSION_ID,INSTANCE_ID,CONTEXT_NAME,CONNECTION_USER,CONNECT_TIME) VALUES(?,?,?,?,?,?,?,?,CURRENT_TIMESTAMP)", (String)"CONNECTION_ID", (Object[])new Object[]{model.getRunId(), model.getWorkspaceId(), projectId, connectionInfo.getContainerId(), record.sessionId(), CommonUtils.truncateString((String)CommonUtils.notEmpty((String)connectionInfo.getInstanceId()), (int)64), CommonUtils.notEmpty((String)connectionInfo.getContextName()), CommonUtils.notEmpty((String)connectionInfo.getConnectionUserName())});
        this.connectionMap.put(QMEmbeddedService.makeConnectionKey(record.sessionId(), connectionInfo), connectionId);
        return connectionId;
    }

    private void createDataSourceIfNeeded(@NotNull QMDBModel model, @NotNull Connection dbConnection, @NotNull QMMDataSourceInfo dataSourceInfo) throws DBException, SQLException {
        boolean dataSourceExists = this.checkIfDataSourceExists(model, dbConnection, dataSourceInfo.getContainerId());
        String connectionURL = dataSourceInfo.getConnectionUrl() == null ? "?" : dataSourceInfo.getConnectionUrl();
        Long workspaceId = model.getWorkspaceId();
        if (!dataSourceExists) {
            JDBCUtils.executeSQL((Connection)dbConnection, (String)"INSERT INTO {table_prefix}QM_DATASOURCE (WORKSPACE_ID,DATASOURCE_ID,NAME,URL,DRIVER,UPDATE_TIME) VALUES(?,?,?,?,?,CURRENT_TIMESTAMP)", (Object[])new Object[]{workspaceId, CommonUtils.truncateString((String)dataSourceInfo.getContainerId(), (int)255), CommonUtils.truncateString((String)dataSourceInfo.getContainerName(), (int)255), CommonUtils.truncateString((String)CommonUtils.notEmpty((String)connectionURL), (int)1024), dataSourceInfo.getDriverId()});
        } else {
            JDBCUtils.executeSQL((Connection)dbConnection, (String)"UPDATE {table_prefix}QM_DATASOURCE SET NAME=?,URL=?,DRIVER=?,UPDATE_TIME=CURRENT_TIMESTAMP WHERE WORKSPACE_ID=? AND DATASOURCE_ID=?", (Object[])new Object[]{CommonUtils.truncateString((String)dataSourceInfo.getContainerName(), (int)255), CommonUtils.truncateString((String)CommonUtils.notEmpty((String)connectionURL), (int)1024), dataSourceInfo.getDriverId(), workspaceId, CommonUtils.truncateString((String)dataSourceInfo.getContainerId(), (int)255)});
        }
    }

    /*
     * Loose catch block
     */
    private boolean checkIfDataSourceExists(@NotNull QMDBModel model, @NotNull Connection dbCon, @NotNull String dataSourceId) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PreparedStatement stmt = dbCon.prepareStatement("SELECT 1 FROM {table_prefix}QM_DATASOURCE WHERE DATASOURCE_ID=?");){
                boolean bl;
                ResultSet dbResult;
                Throwable throwable2;
                block21: {
                    stmt.setString(1, dataSourceId);
                    throwable2 = null;
                    Object var8_12 = null;
                    dbResult = stmt.executeQuery();
                    bl = dbResult.next();
                    if (dbResult == null) break block21;
                    dbResult.close();
                }
                return bl;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error checking if datasource exists: " + e.getMessage(), (Throwable)e);
        }
    }

    private void closeConnectionInfo(Connection dbConnection, Long sessionId, QMMConnectionInfo sessionInfo) throws SQLException, DBException {
        Long connectionId = this.getConnectionId(dbConnection, sessionId, sessionInfo);
        if (connectionId == null) {
            log.debug((Object)("Can't find QMDB connection info " + sessionInfo.getContainerId() + " for close"));
            return;
        }
        JDBCUtils.executeSQL((Connection)dbConnection, (String)"UPDATE {table_prefix}QM_CONNECTION SET DISCONNECT_TIME=? WHERE CONNECTION_ID=?", (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), connectionId});
        this.connectionMap.remove(QMEmbeddedService.makeConnectionKey(sessionId, sessionInfo));
    }

    private Long getConnectionId(Connection dbConnection, Long sessionId, QMMConnectionInfo connectionInfo) throws SQLException, DBException {
        String connectionKey = QMEmbeddedService.makeConnectionKey(sessionId, connectionInfo);
        if (this.connectionMap.containsKey(connectionKey)) {
            return this.connectionMap.get(connectionKey);
        }
        Object sqlScript = "SELECT CONNECTION_ID FROM {table_prefix}QM_CONNECTION WHERE DATASOURCE_ID=? AND SESSION_ID=? AND DISCONNECT_TIME IS NULL";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(connectionInfo.getContainerId());
        params.add(sessionId);
        Long projectId = this.getProjectId(connectionInfo);
        if (projectId != null) {
            sqlScript = (String)sqlScript + " AND PROJECT_ID=?";
            params.add(projectId);
        }
        if (connectionInfo.getInstanceId() != null) {
            sqlScript = (String)sqlScript + " AND INSTANCE_ID=?";
            params.add(connectionInfo.getInstanceId());
        }
        if (connectionInfo.getContextName() != null) {
            sqlScript = (String)sqlScript + " AND CONTEXT_NAME=?";
            params.add(connectionInfo.getContextName());
        }
        return (Long)JDBCUtils.executeQuery((Connection)dbConnection, (String)sqlScript, (Object[])params.toArray());
    }

    private long createUserSession(Connection dbConnection, @NotNull Long runId, @Nullable Long userId, @NotNull String appSessionId, @NotNull String userIp) throws SQLException {
        return JDBCUtils.executeInsertAutoIncrement((Connection)dbConnection, (String)"INSERT INTO {table_prefix}QM_USER_SESSION (RUN_ID,APP_SESSION_ID,USER_ID,USER_IP,START_TIME) VALUES(?,?,?,?,CURRENT_TIMESTAMP)", (String)"SESSION_ID", (Object[])new Object[]{runId, appSessionId, userId, userIp});
    }

    protected QMDBUserSessionRecord getUserSessionRecord(@NotNull Connection dbConnection, @Nullable String qmAppSessionId) throws DBException {
        if (CommonUtils.isEmpty((String)qmAppSessionId)) {
            return null;
        }
        QMDBUserSessionRecord userSession = null;
        try {
            userSession = this.findUserSession(dbConnection, qmAppSessionId);
        }
        catch (SQLException e) {
            log.error((Object)"Error during find qm session", (Throwable)e);
        }
        if (userSession == null) {
            throw new DBException("Session not found in qm: " + qmAppSessionId);
        }
        return userSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Nullable
    private QMDBUserSessionRecord findUserSession(@NotNull Connection dbConnection, @NotNull String appSessionId) throws SQLException {
        Map<String, QMDBUserSessionRecord> map = this.qmUserSessionCache;
        // MONITORENTER : map
        if (this.qmUserSessionCache.containsKey(appSessionId)) {
            // MONITOREXIT : map
            return this.qmUserSessionCache.get(appSessionId);
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            QMDBUserSessionRecord qMDBUserSessionRecord;
            PreparedStatement dbStat = dbConnection.prepareStatement("SELECT US.USER_ID,US.SESSION_ID,US.USER_IP,U.USER_NAME FROM {table_prefix}QM_USER_SESSION US\nJOIN {table_prefix}QM_USER U ON U.USER_ID=US.USER_ID\nWHERE APP_SESSION_ID=?");
            try {
                dbStat.setObject(1, appSessionId);
                Throwable throwable2 = null;
                Object var8_11 = null;
                try {
                    ResultSet resultSet;
                    block18: {
                        resultSet = dbStat.executeQuery();
                        try {
                            if (!resultSet.next()) break block18;
                            long userId = resultSet.getLong(1);
                            long sessionId = resultSet.getLong(2);
                            String userIp = resultSet.getString(3);
                            String userName = resultSet.getString(4);
                            QMDBUserSessionRecord record = new QMDBUserSessionRecord(new QMMUserInfo(userId, userName), sessionId, userIp);
                            this.qmUserSessionCache.put(appSessionId, record);
                            qMDBUserSessionRecord = record;
                            if (resultSet == null) return qMDBUserSessionRecord;
                        }
                        catch (Throwable throwable3) {
                            if (resultSet == null) throw throwable3;
                            resultSet.close();
                            throw throwable3;
                        }
                        resultSet.close();
                        return qMDBUserSessionRecord;
                    }
                    if (resultSet == null) return null;
                    resultSet.close();
                    return null;
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
            finally {
                if (dbStat == null) {
                    // MONITOREXIT : map
                    return qMDBUserSessionRecord;
                }
                dbStat.close();
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private String tryToGetQmSessionId() {
        String qmSessionId;
        DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
        if (!(dBPApplication instanceof QMSessionProvider)) {
            return null;
        }
        QMSessionProvider qMSessionProvider = (QMSessionProvider)dBPApplication;
        long startTime = System.currentTimeMillis();
        do {
            void qmSessionReceiver;
            if ((qmSessionId = qmSessionReceiver.getQueryManagerSessionId()) != null) {
                return qmSessionId;
            }
            RuntimeUtils.pause((int)100);
        } while (System.currentTimeMillis() - startTime < 300000L);
        return qmSessionId;
    }

    public void dispose() {
    }

    /*
     * Exception decompiling
     */
    private long getQueryId(long userId, String query) throws SQLException, DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 21[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String openSession(@NotNull QMSessionInfo sessionInfo) throws DBException {
        QMDBModel model = this.getModel();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection dbCon = model.getDatabaseConnection();){
                long userId = model.findOrCreateUser(sessionInfo.getUserName(), sessionInfo.getUserDomain());
                UUID qmSessionUuid = UUID.randomUUID();
                String qmSessionId = qmSessionUuid.toString();
                String userIp = sessionInfo.getUserIp() != null ? sessionInfo.getUserIp().replaceAll("[\\[\\]]", "") : null;
                long sessionId = this.createUserSession(dbCon, model.getRunId(), userId, qmSessionId, userIp);
                Map<String, QMDBUserSessionRecord> map = this.qmUserSessionCache;
                synchronized (map) {
                    this.qmUserSessionCache.put(qmSessionId, new QMDBUserSessionRecord(new QMMUserInfo(userId, sessionInfo.getUserName()), sessionId, userIp));
                }
                return qmSessionId;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error during open new qm session", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(String appSessionId) {
        Map<String, QMDBUserSessionRecord> map = this.qmUserSessionCache;
        synchronized (map) {
            this.qmUserSessionCache.remove(appSessionId);
        }
    }

    @NotNull
    private static String makeConnectionKey(Long sessionId, QMMConnectionInfo connectionInfo) {
        return connectionInfo.getContainerId() + ":" + connectionInfo.getInstanceId() + ":" + connectionInfo.getContextName() + ":" + String.valueOf(sessionId) + ":" + connectionInfo.getProjectInfo().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QMMConnectionInfo getConnectionInfo(Connection dbConnection, long projectId, long connectionId, String containerId, String instanceId, String contextName, long eventStart) throws DBException {
        LongKeyMap<QMMConnectionInfo> longKeyMap = this.connectionCache;
        synchronized (longKeyMap) {
            QMMConnectionInfo connectionInfo = (QMMConnectionInfo)this.connectionCache.get(connectionId);
            if (connectionInfo == null) {
                DataSourceInfo dataSourceInfo = this.getDataSourceInfo(dbConnection, containerId);
                QMMProjectInfo projectInfo = this.getProjectInfo(dbConnection, projectId);
                DBPConnectionConfiguration config = new DBPConnectionConfiguration();
                config.setUrl(dataSourceInfo.getUrl());
                connectionInfo = new QMMConnectionInfo(eventStart, eventStart, projectInfo, containerId, dataSourceInfo.getName(), dataSourceInfo.getDriverID(), config, instanceId, contextName, false);
                this.connectionCache.put(connectionId, (Object)connectionInfo);
            }
            return connectionInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSourceInfo getDataSourceInfo(Connection dbConnection, String containerId) throws DBException {
        Map<String, DataSourceInfo> map = this.dataSourceCache;
        synchronized (map) {
            DataSourceInfo dataSourceInfo = this.dataSourceCache.get(containerId);
            if (dataSourceInfo == null) {
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (PreparedStatement stmt = dbConnection.prepareStatement("SELECT * FROM {table_prefix}QM_DATASOURCE WHERE DATASOURCE_ID=?");){
                        stmt.setString(1, containerId);
                        Throwable throwable2 = null;
                        Object var9_13 = null;
                        try (ResultSet dbResult = stmt.executeQuery();){
                            if (dbResult.next()) {
                                String name = dbResult.getString("NAME");
                                String url = dbResult.getString("URL");
                                String driverID = dbResult.getString("DRIVER");
                                dataSourceInfo = new DataSourceInfo(containerId, driverID, name, url);
                            } else {
                                dataSourceInfo = new DataSourceInfo(containerId);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBException("Error reading datasource info", (Throwable)e);
                }
                this.dataSourceCache.put(containerId, dataSourceInfo);
            }
            return dataSourceInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Long getProjectId(QMMConnectionInfo connectionInfo) throws SQLException, DBException {
        QMMProjectInfo projectInfo = connectionInfo.getProjectInfo();
        String projectUniqueName = projectInfo.getId();
        Map<String, Long> map = this.projectIdsCache;
        synchronized (map) {
            if (this.projectIdsCache.containsKey(projectUniqueName)) {
                return this.projectIdsCache.get(projectUniqueName);
            }
            Long projectId = this.getModel().findOrCreateQMDBeaverProject(projectInfo);
            this.projectIdsCache.put(projectUniqueName, projectId);
            return projectId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QMMProjectInfo getProjectInfo(Connection dbConnection, Long projectId) throws DBException {
        LongKeyMap<QMMProjectInfo> longKeyMap = this.projectCache;
        synchronized (longKeyMap) {
            QMMProjectInfo projectInfo = (QMMProjectInfo)this.projectCache.get((Object)projectId);
            if (projectInfo != null) {
                return projectInfo;
            }
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (PreparedStatement stmt = dbConnection.prepareStatement("SELECT * FROM {table_prefix}QM_DBEAVER_PROJECT WHERE PROJECT_ID=?");){
                    stmt.setLong(1, projectId);
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (ResultSet dbResult = stmt.executeQuery();){
                        if (dbResult.next()) {
                            String projectIdString;
                            String projectName = projectIdString = dbResult.getString("PROJECT_NAME");
                            if (DBWorkbench.isDistributed() && projectName.contains("_")) {
                                projectName = RMUtils.getProjectName((String)projectName);
                            }
                            projectInfo = QMMProjectInfo.builder().setId(projectIdString).setName(projectName).setPath(dbResult.getString("PROJECT_PATH")).setAnonymous(dbResult.getBoolean("IS_ANONYMOUS")).build();
                        } else {
                            projectInfo = QMMProjectInfo.builder().build();
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException("Error reading project info", (Throwable)e);
            }
            this.projectCache.put(projectId, (Object)projectInfo);
            return projectInfo;
        }
    }

    /*
     * Exception decompiling
     */
    public List<QMTranslationHistoryItem> readSmartCompletionHistory(@NotNull String sessionId, @NotNull String dataSourceId, @NotNull String logicalDataSourceName, @Nullable String currentCatalog, @Nullable String currentSchema, int maxCount) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QMMUserInfo getUserBySession(@NotNull String sessionId, QMDBModel model, Connection dbConnection) throws DBException {
        QMDBUserSessionRecord userSessionRecord;
        Map<String, QMDBUserSessionRecord> map = this.qmUserSessionCache;
        synchronized (map) {
            userSessionRecord = this.qmUserSessionCache.get(sessionId);
            if (userSessionRecord != null) {
                return userSessionRecord.userInfo();
            }
        }
        userSessionRecord = this.getUserSessionRecord(dbConnection, sessionId);
        if (userSessionRecord == null) {
            throw new DBException("Cannot find connection ID for session " + sessionId);
        }
        return userSessionRecord.userInfo();
    }

    public void saveSmartCompletionHistory(@NotNull String sessionId, @NotNull String dataSourceId, @NotNull String logicalDataSourceName, @Nullable String currentCatalog, @Nullable String currentSchema, @NotNull String naturalText, @NotNull String sqlText) throws DBException {
        block56: {
            QMDBModel model = this.getModel();
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (Connection dbCon = model.getDatabaseConnection();){
                    Throwable e2;
                    PreparedStatement stmt;
                    Object var17_24;
                    long userId = this.getUserBySession(sessionId, model, dbCon).userId();
                    long completionId = -1L;
                    try {
                        Throwable throwable2 = null;
                        var17_24 = null;
                        try {
                            stmt = dbCon.prepareStatement("SELECT COMPLETION_ID FROM {table_prefix}QM_AI_COMPLETION_HISTORY\nWHERE USER_ID=? AND DATASOURCE_ID=? AND LOGICAL_DATASOURCE_NAME=?\nAND DEFAULT_CATALOG=? AND DEFAULT_SCHEMA=? AND %s".formatted(model.getDialect().getClobComparingPart("NATURAL_TEXT")));
                            try {
                                stmt.setLong(1, userId);
                                stmt.setString(2, dataSourceId);
                                stmt.setString(3, logicalDataSourceName);
                                stmt.setString(4, CommonUtils.notEmpty((String)currentCatalog));
                                stmt.setString(5, CommonUtils.notEmpty((String)currentSchema));
                                stmt.setString(6, naturalText);
                                Throwable throwable3 = null;
                                Object var20_31 = null;
                                try (ResultSet dbResult = stmt.executeQuery();){
                                    if (dbResult.next()) {
                                        completionId = dbResult.getLong(1);
                                    }
                                }
                                catch (Throwable throwable4) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable4;
                                    } else if (throwable3 != throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                    throw throwable3;
                                }
                            }
                            finally {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    catch (SQLException e2) {
                        throw new DBException("Error reading completion info", (Throwable)e2);
                    }
                    if (completionId == -1L) {
                        try {
                            e2 = null;
                            var17_24 = null;
                            try {
                                stmt = dbCon.prepareStatement("INSERT INTO {table_prefix}QM_AI_COMPLETION_HISTORY (USER_ID,DATASOURCE_ID,LOGICAL_DATASOURCE_NAME,DEFAULT_CATALOG,DEFAULT_SCHEMA,NATURAL_TEXT,SQL_TEXT,FIRST_COMPLETION_TIME,LAST_COMPLETION_TIME,COMPLETION_COUNT) VALUES(?,?,?,?,?,?,?,?,?,?)");
                                try {
                                    stmt.setLong(1, userId);
                                    stmt.setString(2, dataSourceId);
                                    stmt.setString(3, logicalDataSourceName);
                                    stmt.setString(4, CommonUtils.notEmpty((String)currentCatalog));
                                    stmt.setString(5, CommonUtils.notEmpty((String)currentSchema));
                                    stmt.setString(6, naturalText);
                                    stmt.setString(7, sqlText);
                                    stmt.setTimestamp(8, new Timestamp(System.currentTimeMillis()));
                                    stmt.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
                                    stmt.setInt(10, 1);
                                    stmt.execute();
                                    break block56;
                                }
                                finally {
                                    if (stmt != null) {
                                        stmt.close();
                                    }
                                }
                            }
                            catch (Throwable throwable6) {
                                if (e2 == null) {
                                    e2 = throwable6;
                                } else if (e2 != throwable6) {
                                    e2.addSuppressed(throwable6);
                                }
                                throw e2;
                            }
                        }
                        catch (SQLException e3) {
                            throw new DBException("Error inserting smart completion info: " + e3.getMessage(), (Throwable)e3);
                        }
                    }
                    try {
                        e2 = null;
                        var17_24 = null;
                        try {
                            stmt = dbCon.prepareStatement("UPDATE {table_prefix}QM_AI_COMPLETION_HISTORY SET LAST_COMPLETION_TIME=?,COMPLETION_COUNT=COMPLETION_COUNT+1 WHERE USER_ID=? AND COMPLETION_ID=?");
                            try {
                                stmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                                stmt.setLong(2, userId);
                                stmt.setLong(3, completionId);
                                stmt.execute();
                            }
                            finally {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                        }
                        catch (Throwable throwable7) {
                            if (e2 == null) {
                                e2 = throwable7;
                            } else if (e2 != throwable7) {
                                e2.addSuppressed(throwable7);
                            }
                            throw e2;
                        }
                    }
                    catch (SQLException e4) {
                        throw new DBException("Error inserting smart completion info: " + e4.getMessage(), (Throwable)e4);
                    }
                }
                catch (Throwable throwable8) {
                    if (throwable == null) {
                        throwable = throwable8;
                    } else if (throwable != throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException("Error saving smart completion info: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void saveDataSourceConnectError(@NotNull String sessionId, @NotNull QMMDataSourceConnectErrorInfo dataSourceInfo) throws DBException {
        QMDBModel model = this.getModel();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection dbCon = model.getDatabaseConnection();){
                long userId = this.getUserBySession(sessionId, model, dbCon).userId();
                this.createDataSourceIfNeeded(model, dbCon, (QMMDataSourceInfo)dataSourceInfo);
                Throwable throwable2 = null;
                Object var10_13 = null;
                try (PreparedStatement stmt = dbCon.prepareStatement("INSERT INTO {table_prefix}QM_CONNECT_ERROR\n(DATASOURCE_ID,USER_ID,CONNECTION_TIME,ERROR_TYPE,ERROR_MESSAGE)\nVALUES(?,?,?,?,?)");){
                    stmt.setString(1, dataSourceInfo.getContainerId());
                    stmt.setLong(2, userId);
                    stmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                    stmt.setString(4, dataSourceInfo.getErrorType());
                    stmt.setString(5, CommonUtils.truncateString((String)dataSourceInfo.getErrorMessage(), (int)128));
                    stmt.execute();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error saving data source connect error: " + e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    public DBPConnectionInformation getInternalDatabaseInformation() {
        return this.getModel().getMetaDataInfo();
    }

    public String ping() {
        return "pong (QM)";
    }

    private QMAIConversationHistory mapRowToChatHistory(ResultSet resultSet) throws SQLException {
        String datasourceId = resultSet.getString("DATASOURCE_ID");
        QMAIDataSource dataSource = QMAIDataSource.fromString((String)datasourceId);
        if (dataSource == null && datasourceId != null) {
            log.debug((Object)("Failed to parse datasource id " + datasourceId));
        }
        return new QMAIConversationHistory(resultSet.getString("CONVERSATION_ID"), resultSet.getString("CAPTION"), resultSet.getString("PROMPT_ID"), dataSource, new ArrayList(), new QMAIContext(resultSet.getString("CONTEXT_JSON"), Set.of()), resultSet.getInt("NEXT_MESSAGE_ID"), CommonUtils.equalObjects((Object)resultSet.getString("IS_DELETED"), (Object)BOOL_YES));
    }

    private QMAIChatMessage mapRowToChatMessage(ResultSet rs) throws SQLException {
        return new QMAIChatMessage(rs.getInt("MESSAGE_ID"), rs.getString("CONTENT"), rs.getString("DISPLAY_MESSAGE"), (QMAIChatRole)CommonUtils.valueOf(QMAIChatRole.class, (String)rs.getString("MESSAGE_ROLE"), (Enum)QMAIChatRole.USER), rs.getTimestamp("SENT_AT").toInstant(), CommonUtils.equalObjects((Object)rs.getString("IS_DELETED"), (Object)BOOL_YES));
    }
}

