/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ActionCompletedEvent;
import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileFilter;
import com.ibm.as400.vaccess.ErrorEvent;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import java.awt.List;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Vector;

class IFSList
extends List
implements IFSFileFilter {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private AS400 sys_;
    private String path_ = "/";
    private String filter_ = "*";
    private boolean sort_ = true;
    private IFSFile ifsFile_;
    private int directory_ = 1;
    private Vector fList;
    private Vector actionEventList = new Vector();
    private Vector errorEventList = new Vector();
    private PropertyChangeSupport propertyList = new PropertyChangeSupport(this);
    public static final int DIRECTORYONLY = 1;
    public static final int FILEONLY = 2;
    public static final int BOTH = 3;

    @Override
    public boolean accept(IFSFile file) {
        boolean fAccept = false;
        try {
            switch (this.directory_) {
                case 1: {
                    if (file.isDirectory()) {
                        fAccept = true;
                        break;
                    }
                    fAccept = false;
                    break;
                }
                case 2: {
                    if (file.isFile()) {
                        fAccept = true;
                        break;
                    }
                    fAccept = false;
                    break;
                }
                case 3: {
                    fAccept = true;
                    break;
                }
                default: {
                    fAccept = false;
                    break;
                }
            }
        }
        catch (IOException e) {
            this.fireError(e, "accept");
            return false;
        }
        if (fAccept) {
            if (this.sort_) {
                int i;
                for (i = 0; i < this.fList.size(); ++i) {
                    String temp = (String)this.fList.elementAt(i);
                    if (temp.toUpperCase().compareTo(file.getName().toUpperCase()) <= 0) continue;
                    this.fList.insertElementAt(file.getName(), i);
                    break;
                }
                if (i == this.fList.size()) {
                    this.fList.addElement(file.getName());
                }
            } else {
                this.add(file.getName());
            }
        }
        return fAccept;
    }

    public synchronized void addActionCompletedListener(ActionCompletedListener listener) {
        this.actionEventList.addElement(listener);
    }

    public synchronized void addErrorListener(ErrorListener listener) {
        this.errorEventList.addElement(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyList.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAction(String sourceMethod) {
        Vector targets;
        IFSList iFSList = this;
        synchronized (iFSList) {
            targets = (Vector)this.actionEventList.clone();
        }
        ActionCompletedEvent actionEvt = new ActionCompletedEvent(this);
        for (int i = 0; i < targets.size(); ++i) {
            ActionCompletedListener target = (ActionCompletedListener)targets.elementAt(i);
            target.actionCompleted(actionEvt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireError(Exception e, String sourceMethod) {
        Vector targets;
        IFSList iFSList = this;
        synchronized (iFSList) {
            targets = (Vector)this.errorEventList.clone();
        }
        ErrorEvent errorEvt = new ErrorEvent(this, e);
        for (int i = 0; i < targets.size(); ++i) {
            ErrorListener target = (ErrorListener)targets.elementAt(i);
            target.errorOccurred(errorEvt);
        }
    }

    public String getFilter() {
        return this.filter_;
    }

    public String getPath() {
        return this.path_;
    }

    public boolean isSort() {
        return this.sort_;
    }

    public int getListType() {
        return this.directory_;
    }

    public AS400 getSystem() {
        return this.sys_;
    }

    public void populateList() throws IOException {
        this.setVisible(false);
        this.removeAll();
        this.setVisible(true);
        if (this.sys_ == null) {
            this.sys_ = new AS400();
        }
        if (this.ifsFile_ == null) {
            this.ifsFile_ = new IFSFile(this.sys_, this.path_);
        }
        if (this.directory_ == 1 || this.directory_ == 3) {
            this.add(".");
            this.add("..");
        }
        this.fList = new Vector();
        if (this.filter_ != null) {
            this.ifsFile_.list(this, this.filter_);
        } else {
            this.ifsFile_.list(this);
        }
        for (int i = 0; i < this.fList.size(); ++i) {
            this.add((String)this.fList.elementAt(i));
        }
        this.fireAction("populateList");
    }

    public void setFilter(String filter) {
        String old = this.filter_;
        this.filter_ = filter.compareTo("*.*") == 0 ? "*" : filter;
        this.propertyList.firePropertyChange("filter", old, this.filter_);
    }

    public void setListType(int listType) {
        Integer old = this.directory_;
        this.directory_ = listType;
        this.propertyList.firePropertyChange("listType", old, (Object)listType);
    }

    public void setPath(String path) {
        String old = this.path_;
        this.path_ = path;
        this.ifsFile_ = null;
        this.propertyList.firePropertyChange("path", old, this.path_);
    }

    public void setSort(boolean sort) {
        Boolean old = this.sort_;
        this.sort_ = sort;
        this.propertyList.firePropertyChange("sort", old, (Object)this.sort_);
    }

    public void setSystem(AS400 system) {
        AS400 old = this.sys_;
        this.sys_ = system;
        this.propertyList.firePropertyChange("system", old, this.sys_);
    }
}

