/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.util.commtrace.AH;
import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Data;
import com.ibm.as400.util.commtrace.Destination;
import com.ibm.as400.util.commtrace.ESP;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.Fragmentation;
import com.ibm.as400.util.commtrace.HopByHop;
import com.ibm.as400.util.commtrace.ICMP4Header;
import com.ibm.as400.util.commtrace.ICMP6Header;
import com.ibm.as400.util.commtrace.IP4Header;
import com.ibm.as400.util.commtrace.IP6Header;
import com.ibm.as400.util.commtrace.Routing;
import com.ibm.as400.util.commtrace.TCPHeader;
import com.ibm.as400.util.commtrace.UDPHeader;
import com.ibm.as400.util.commtrace.UnknownHeader;
import java.io.StringWriter;

public abstract class Header {
    BitBuf rawheader;
    BitBuf rawpayload;
    Header next;
    int type;
    public static final int ICMP6 = 58;
    public static final int IP6 = 41;
    public static final int ICMP4 = 1;
    public static final int IP4 = 23;
    public static final int TCP = 6;
    public static final int UDP = 17;
    public static final int EXTHOPBYHOP = 0;
    public static final int EXTROUTE = 43;
    public static final int EXTFRAG = 44;
    public static final int EXTESP = 50;
    public static final int EXTAH = 51;
    public static final int EXTDEST = 60;
    public static final int UNK = 255;

    Header(BitBuf data) {
        this.rawheader = data;
        this.rawheader = data.slice(0, this.getHeaderLen());
        this.rawpayload = data.slice(this.getHeaderLen());
        this.next = this.getNextHeader();
    }

    static Header createHeader(byte p, BitBuf data) {
        int protocol = p & 0xFF;
        if (data.getBitSize() == 0) {
            return null;
        }
        if (protocol == 58) {
            return new ICMP6Header(data);
        }
        if (protocol == 41) {
            return new IP6Header(data);
        }
        if (protocol == 1) {
            return new ICMP4Header(data);
        }
        if (protocol == 23) {
            return new IP4Header(data);
        }
        if (protocol == 6) {
            return new TCPHeader(data);
        }
        if (protocol == 17) {
            return new UDPHeader(data);
        }
        if (protocol == 0) {
            return new HopByHop(data);
        }
        if (protocol == 43) {
            return new Routing(data);
        }
        if (protocol == 44) {
            return new Fragmentation(data);
        }
        if (protocol == 50) {
            return new ESP(data);
        }
        if (protocol == 51) {
            return new AH(data);
        }
        if (protocol == 59) {
            return null;
        }
        if (protocol == 60) {
            return new Destination(data);
        }
        return new UnknownHeader(data);
    }

    String fielddump() {
        StringWriter out = new StringWriter();
        java.lang.reflect.Field[] fieldlist = this.getClass().getFields();
        out.write("Fields from " + this.getName() + ":\n");
        for (int i = 0; i < fieldlist.length; ++i) {
            if (!Field.class.isAssignableFrom(fieldlist[i].getType())) continue;
            try {
                out.write("\t" + fieldlist[i].getName() + ":  " + fieldlist[i].get(this) + "\n");
                continue;
            }
            catch (Throwable x) {
                out.write("\n\nfielddump: Caught exception:  " + x.toString() + "\n");
            }
        }
        return out.toString();
    }

    public byte[] getHeaderData() {
        return this.rawheader.getBytes();
    }

    public int getHeaderLen() {
        return 0;
    }

    public String getName() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
    }

    public Header getNextHeader() {
        return null;
    }

    public String printHexHeader() {
        String name = this.getName();
        int i = name.indexOf("$");
        if (i != -1) {
            name = name.substring(i + 1);
            name = name + " Header";
        }
        Object[] args = new Object[]{name, this.rawheader.toHexString(32, "\n\t\t\t ")};
        return Formatter.jsprintf("\t    {0} :  {1}\n", args);
    }

    public byte[] getPayLoad() {
        return this.rawpayload.getBytes();
    }

    String printnext() {
        if (this.next == null) {
            return "";
        }
        return this.next.toString();
    }

    String printnext(FormatProperties filter) {
        if (this.next == null) {
            return "";
        }
        return this.next.toString(filter);
    }

    public String toString() {
        return this.fielddump() + this.printnext();
    }

    public String toString(FormatProperties filter) {
        return this.fielddump() + this.printnext(filter);
    }

    public String toHexString() {
        return this.rawheader.toHexString();
    }

    public String getPayloadHexString() {
        return this.rawpayload.toHexString();
    }

    public byte[] getPayloadBytes() {
        return this.rawpayload.getBytes();
    }

    public String getPayload() {
        return new Data(this.rawpayload).toString();
    }

    public int getType() {
        return this.type;
    }
}

