/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.impl;

import com.dbeaver.data.compare.model.DCChangeList;
import com.dbeaver.data.compare.model.DCChangeOrder;
import com.dbeaver.data.compare.model.DCChangeSet;
import com.dbeaver.data.compare.model.DCChangeType;
import com.dbeaver.data.compare.model.DCIterator;
import com.dbeaver.data.compare.model.impl.DCChangeSetMemory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;

public class DCChangeListMemory
implements DCChangeList {
    private final List<DCChangeSetMemory> changeSets = new ArrayList<DCChangeSetMemory>();

    @Override
    public void addInsert(@NotNull DBDAttributeValue[] keys, @NotNull DBDAttributeValue[] targetValues) {
        this.changeSets.add(new DCChangeSetMemory(DCChangeType.INSERT, keys, targetValues));
    }

    @Override
    public void addUpdate(@NotNull DBDAttributeValue[] keys, @NotNull DBDAttributeValue[] sourceValues, @NotNull DBDAttributeValue[] targetValues) {
        this.changeSets.add(new DCChangeSetMemory(DCChangeType.UPDATE, keys, sourceValues, targetValues));
    }

    @Override
    public void addDelete(@NotNull DBDAttributeValue[] keys, @NotNull DBDAttributeValue[] sourceValues) {
        this.changeSets.add(new DCChangeSetMemory(DCChangeType.DELETE, keys, sourceValues));
    }

    @Override
    public int size() {
        return this.changeSets.size();
    }

    @Override
    @NotNull
    public DCIterator<DCChangeSet> iterator(long offset, long count, @NotNull DCChangeOrder order) {
        Stream<Object> stream = this.changeSets.stream().skip(offset).limit(count);
        if (order == DCChangeOrder.BY_TYPE) {
            stream = stream.sorted(Comparator.comparing(DCChangeSetMemory::getChangeType));
        }
        return new IteratorAdapter(stream.iterator());
    }

    @NotNull
    public List<DCChangeSetMemory> getChangeSets() {
        return this.changeSets;
    }

    @Override
    public void close() {
        this.changeSets.clear();
    }

    private record IteratorAdapter(@NotNull Iterator<DCChangeSetMemory> it) implements DCIterator<DCChangeSet>
    {
        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        @NotNull
        public DCChangeSet next() {
            return this.it.next();
        }

        @Override
        public void close() {
        }
    }
}

