/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.impl;

import com.dbeaver.data.compare.model.DCChangeList;
import com.dbeaver.data.compare.model.DCChangeOrder;
import com.dbeaver.data.compare.model.DCChangeSet;
import com.dbeaver.data.compare.model.DCChangeType;
import com.dbeaver.data.compare.model.DCIterator;
import com.dbeaver.data.compare.model.DCSettings;
import com.dbeaver.data.compare.model.impl.DCChangeSetMemory;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.data.DefaultValueHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.IOUtils;

public class DCChangeListH2
implements DCChangeList {
    private static final Log log = Log.getLog(DCChangeListH2.class);
    private static final String DRIVER_ID = "h2_embedded_v2";
    private final Path databasePath;
    private final DBSAttributeBase[] keyAttributes;
    private final DBSAttributeBase[] sourceAttributes;
    private final DBSAttributeBase[] targetAttributes;
    private final Map<DBSAttributeBase, DBDValueHandler> handlers = new IdentityHashMap<DBSAttributeBase, DBDValueHandler>();
    private DBCSession sourceSession;
    private DBCSession targetSession;
    private DBPDataSourceContainer databaseContainer;
    private JDBCSession databaseSession;
    private JDBCPreparedStatement databaseInsertStatement;
    private int size;

    public DCChangeListH2(@NotNull DBRProgressMonitor monitor, @NotNull DCSettings settings) throws DBException {
        List<Map.Entry<DBSAttributeBase, DBSAttributeBase>> mappings = List.copyOf(settings.getMappings().entrySet());
        this.keyAttributes = settings.getLeftInput().getKeys();
        this.sourceAttributes = (DBSAttributeBase[])mappings.stream().map(Map.Entry::getKey).toArray(DBSAttributeBase[]::new);
        this.targetAttributes = (DBSAttributeBase[])mappings.stream().map(Map.Entry::getValue).toArray(DBSAttributeBase[]::new);
        this.sourceSession = settings.getLeftInput().getExecutionContext().openSession(monitor, DBCExecutionPurpose.UTIL, "Read data for data compare (source table)");
        this.targetSession = settings.getRightInput().getExecutionContext().openSession(monitor, DBCExecutionPurpose.UTIL, "Read data for data compare (target table)");
        this.databasePath = DCChangeListH2.makeDatabasePath(monitor);
        this.databaseContainer = DCChangeListH2.createDataSource(monitor, this.databasePath);
        this.databaseSession = (JDBCSession)DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)this.databaseContainer, (String)"Internal data compare session");
        this.databaseSession.enableLogging(false);
        this.databaseInsertStatement = this.prepareInsertStatement();
    }

    @Override
    public void addInsert(@NotNull DBDAttributeValue[] keys, @NotNull DBDAttributeValue[] targetValues) {
        this.insert(DCChangeType.INSERT, keys, targetValues, targetValues);
    }

    @Override
    public void addUpdate(@NotNull DBDAttributeValue[] keys, @NotNull DBDAttributeValue[] sourceValues, @NotNull DBDAttributeValue[] targetValues) {
        this.insert(DCChangeType.UPDATE, keys, sourceValues, targetValues);
    }

    @Override
    public void addDelete(@NotNull DBDAttributeValue[] keys, @NotNull DBDAttributeValue[] sourceValues) {
        this.insert(DCChangeType.DELETE, keys, sourceValues, sourceValues);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @NotNull
    public DCIterator<DCChangeSet> iterator(long offset, long count, @NotNull DCChangeOrder order) throws DBException {
        try {
            return new H2Iterator(offset, count, order);
        }
        catch (SQLException e) {
            throw new DBException("Error creating iterator", (Throwable)e);
        }
    }

    @Override
    public void close() throws DBException {
        this.sourceSession.close();
        this.sourceSession = null;
        this.targetSession.close();
        this.targetSession = null;
        this.databaseInsertStatement.close();
        this.databaseInsertStatement = null;
        this.databaseSession.enableLogging(true);
        this.databaseSession.close();
        this.databaseSession = null;
        this.databaseContainer.disconnect((DBRProgressMonitor)new VoidProgressMonitor());
        this.databaseContainer.dispose();
        this.databaseContainer = null;
        try {
            IOUtils.deleteDirectory((Path)this.databasePath);
        }
        catch (IOException e) {
            log.warn((Object)("Error deleting temp database files: " + e.getMessage()));
        }
    }

    @NotNull
    private static DBPDataSourceContainer createDataSource(@NotNull DBRProgressMonitor monitor, @NotNull Path path) throws DBException {
        DBPDriver driver = DataSourceProviderRegistry.getInstance().findDriver(DRIVER_ID);
        if (driver == null) {
            throw new DBException("Could not find H2 driver: h2_embedded_v2");
        }
        DBPConnectionConfiguration configuration = new DBPConnectionConfiguration();
        configuration.setUrl("jdbc:h2:file:" + String.valueOf(path.toAbsolutePath()));
        DataSourceDescriptor dataSourceDescriptor = (DataSourceDescriptor)DBWorkbench.getPlatform().getWorkspace().getActiveProject().getDataSourceRegistry().createDataSource(DataSourceDescriptor.generateNewId((DBPDriver)driver), driver, configuration);
        dataSourceDescriptor.setName("Data Compare DB");
        dataSourceDescriptor.setSavePassword(true);
        dataSourceDescriptor.setTemporary(true);
        dataSourceDescriptor.connect(monitor, true, true);
        return dataSourceDescriptor;
    }

    @NotNull
    private static Path makeDatabasePath(@NotNull DBRProgressMonitor monitor) throws DBException {
        try {
            return DBWorkbench.getPlatform().getTempFolder(monitor, "data-compare").resolve("db-" + System.currentTimeMillis());
        }
        catch (IOException e) {
            throw new DBException("Error creating temp folder", (Throwable)e);
        }
    }

    @NotNull
    private JDBCPreparedStatement prepareInsertStatement() throws DBException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (JDBCStatement stmt = this.databaseSession.createStatement();){
                stmt.execute(this.buildCreateTableScript());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error creating schema", (Throwable)e);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO CHANGE_LIST (");
        this.appendAllAttributes(builder, false);
        builder.append(") VALUES (");
        this.appendAllPlaceholders(builder);
        builder.append(");");
        try {
            return this.databaseSession.prepareStatement(builder.toString());
        }
        catch (SQLException e) {
            throw new DBException("Error preparing insert statement", (Throwable)e);
        }
    }

    @NotNull
    private JDBCPreparedStatement prepareSelectStatement(@NotNull DCChangeOrder order) throws DBException {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        this.appendAllAttributes(builder, false);
        builder.append(" FROM CHANGE_LIST WHERE ID > ? ORDER BY ");
        builder.append(switch (order) {
            case DCChangeOrder.DEFAULT -> "ID";
            case DCChangeOrder.BY_TYPE -> "CHANGE_TYPE";
            default -> throw new MatchException(null, null);
        });
        builder.append(" LIMIT ?");
        try {
            return this.databaseSession.prepareStatement(builder.toString());
        }
        catch (SQLException e) {
            throw new DBException("Error preparing select statement", (Throwable)e);
        }
    }

    @NotNull
    private String buildCreateTableScript() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE CHANGE_LIST (");
        builder.append("ID IDENTITY NOT NULL PRIMARY KEY, ");
        this.appendAllAttributes(builder, true);
        builder.append(");\n");
        builder.append("CREATE INDEX CHANGE_LIST_IDX ON CHANGE_LIST (");
        this.appendAttributes(builder, this.keyAttributes, "KEY_", null);
        builder.append(");");
        return builder.toString();
    }

    private void appendAllPlaceholders(@NotNull StringBuilder builder) {
        int count = 1 + this.keyAttributes.length + this.sourceAttributes.length + this.targetAttributes.length;
        int i = 0;
        while (i < count) {
            builder.append("?");
            if (i < count - 1) {
                builder.append(", ");
            }
            ++i;
        }
    }

    private void appendAllAttributes(@NotNull StringBuilder builder, boolean includeType) {
        builder.append("CHANGE_TYPE");
        if (includeType) {
            builder.append(" CHAR(1) NOT NULL");
        }
        String postfix = includeType ? "VARCHAR" : null;
        this.appendAttributes(builder.append(", "), this.keyAttributes, "KEY_", postfix);
        if (this.sourceAttributes.length > 0) {
            this.appendAttributes(builder.append(", "), this.sourceAttributes, "VALUE_SOURCE_", postfix);
            this.appendAttributes(builder.append(", "), this.targetAttributes, "VALUE_TARGET_", postfix);
        }
    }

    private void appendAttributes(@NotNull StringBuilder builder, @NotNull DBSAttributeBase[] attributes, @NotNull String prefix, @Nullable String postfix) {
        int i = 0;
        while (i < attributes.length) {
            builder.append(prefix).append(i);
            if (postfix != null) {
                builder.append(" ").append(postfix);
            }
            if (i < attributes.length - 1) {
                builder.append(", ");
            }
            ++i;
        }
    }

    private void insert(@NotNull DCChangeType type, @NotNull DBDAttributeValue[] keys, @NotNull DBDAttributeValue[] sourceValues, @NotNull DBDAttributeValue[] targetValues) {
        try {
            int index;
            this.databaseInsertStatement.setString(1, String.valueOf(DCChangeListH2.encodeChangeType(type)));
            int i = 0;
            while (i < keys.length) {
                this.databaseInsertStatement.setString(2 + i, this.getValueString(keys[i]));
                ++i;
            }
            int index2 = 0;
            while (index2 < this.sourceAttributes.length + this.targetAttributes.length) {
                this.databaseInsertStatement.setNull(2 + keys.length + index2, 12);
                ++index2;
            }
            DBDAttributeValue[] dBDAttributeValueArray = sourceValues;
            int n = sourceValues.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeValue value = dBDAttributeValueArray[n2];
                index = ArrayUtils.indexOf((Object[])this.sourceAttributes, (Object)value.getAttribute());
                if (index >= 0) {
                    this.databaseInsertStatement.setString(2 + keys.length + index, this.getValueString(value));
                }
                ++n2;
            }
            dBDAttributeValueArray = targetValues;
            n = targetValues.length;
            n2 = 0;
            while (n2 < n) {
                DBDAttributeValue value = dBDAttributeValueArray[n2];
                index = ArrayUtils.indexOf((Object[])this.targetAttributes, (Object)value.getAttribute());
                if (index >= 0) {
                    this.databaseInsertStatement.setString(2 + keys.length + this.sourceAttributes.length + index, this.getValueString(value));
                }
                ++n2;
            }
            this.databaseInsertStatement.execute();
            ++this.size;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error inserting into H2", e);
        }
    }

    @Nullable
    private String getValueString(@NotNull DBDAttributeValue value) {
        if (DBUtils.isNullValue((Object)value.getValue())) {
            return null;
        }
        DBDValueHandler handler = this.getValueHandler(value.getAttribute());
        return handler.getValueDisplayString((DBSTypedObject)value.getAttribute(), value.getValue(), DBDDisplayFormat.NATIVE);
    }

    @NotNull
    private DBDAttributeValue fetchValue(@NotNull DBCSession session, @NotNull JDBCResultSet resultSet, @NotNull DBSAttributeBase attribute, int index) throws SQLException, DBException {
        String string = resultSet.getString(index + 1);
        Object value = string != null ? this.getValueHandler(attribute).getValueFromObject(session, (DBSTypedObject)attribute, (Object)string, false, false) : null;
        return new DBDAttributeValue(attribute, value);
    }

    @NotNull
    private DBDValueHandler getValueHandler(@NotNull DBSAttributeBase attribute) {
        return this.handlers.computeIfAbsent(attribute, DCChangeListH2::createValueHandler);
    }

    @NotNull
    private static DBDValueHandler createValueHandler(@NotNull DBSAttributeBase attribute) {
        DBSObject object;
        if (attribute instanceof DBSObject && (object = (DBSObject)attribute).getDataSource() != null) {
            return DBUtils.findValueHandler((DBPDataSource)object.getDataSource(), (DBSTypedObject)attribute);
        }
        return DefaultValueHandler.INSTANCE;
    }

    private static char encodeChangeType(@NotNull DCChangeType type) {
        return (char)(48 + type.ordinal());
    }

    @NotNull
    private static DCChangeType decodeChangeType(char code) {
        return DCChangeType.values()[code - 48];
    }

    private class H2Iterator
    implements DCIterator<DCChangeSet> {
        private static final int SEGMENT_SIZE = 1000;
        private final JDBCPreparedStatement statement;
        private final long offset;
        private final long limit;
        private JDBCResultSet resultSet;
        private boolean hasNext;
        private long position;

        public H2Iterator(long offset, @NotNull long limit, DCChangeOrder order) throws SQLException, DBException {
            this.statement = DCChangeListH2.this.prepareSelectStatement(order);
            this.offset = offset;
            this.limit = limit;
            this.fetchNextSegment();
        }

        private void fetchNextSegment() throws DBException {
            try {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
                this.statement.setLong(1, (long)Math.toIntExact(this.offset + this.position));
                this.statement.setLong(2, Math.min(1000L, this.limit - this.position));
                this.statement.executeStatement();
                this.resultSet = this.statement.getResultSet();
                this.hasNext = this.resultSet.next();
            }
            catch (SQLException e) {
                throw new DBException("Error reading from result set", (Throwable)e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        @NotNull
        public DCChangeSet next() throws DBException {
            try {
                DCChangeType type = DCChangeListH2.decodeChangeType(this.resultSet.getString(1).charAt(0));
                ArrayList<DBDAttributeValue> keyValues = new ArrayList<DBDAttributeValue>();
                ArrayList<DBDAttributeValue> sourceValues = new ArrayList<DBDAttributeValue>();
                ArrayList<DBDAttributeValue> targetValues = new ArrayList<DBDAttributeValue>();
                int i = 0;
                while (i < DCChangeListH2.this.keyAttributes.length) {
                    keyValues.add(DCChangeListH2.this.fetchValue(DCChangeListH2.this.sourceSession, this.resultSet, DCChangeListH2.this.keyAttributes[i], 1 + i));
                    ++i;
                }
                switch (type) {
                    case DELETE: {
                        sourceValues.addAll(keyValues);
                        break;
                    }
                    case INSERT: {
                        targetValues.addAll(keyValues);
                    }
                }
                i = 0;
                while (i < DCChangeListH2.this.sourceAttributes.length) {
                    sourceValues.add(DCChangeListH2.this.fetchValue(DCChangeListH2.this.sourceSession, this.resultSet, DCChangeListH2.this.sourceAttributes[i], 1 + DCChangeListH2.this.keyAttributes.length + i));
                    ++i;
                }
                i = 0;
                while (i < DCChangeListH2.this.targetAttributes.length) {
                    targetValues.add(DCChangeListH2.this.fetchValue(DCChangeListH2.this.targetSession, this.resultSet, DCChangeListH2.this.targetAttributes[i], 1 + DCChangeListH2.this.keyAttributes.length + DCChangeListH2.this.sourceAttributes.length + i));
                    ++i;
                }
                if (type == DCChangeType.UPDATE) {
                    i = 0;
                    while (i < sourceValues.size()) {
                        DBDAttributeValue sourceValue = (DBDAttributeValue)sourceValues.get(i);
                        DBDAttributeValue targetValue = (DBDAttributeValue)targetValues.get(i);
                        if (sourceValue.getValue() == null && targetValue.getValue() == null) {
                            sourceValues.remove(i);
                            targetValues.remove(i);
                            --i;
                        }
                        ++i;
                    }
                }
                this.hasNext = this.resultSet.next();
                ++this.position;
                if (!this.hasNext && this.position < this.limit && this.position % 1000L == 0L) {
                    this.fetchNextSegment();
                }
                return new DCChangeSetMemory(type, (DBDAttributeValue[])keyValues.toArray(DBDAttributeValue[]::new), (DBDAttributeValue[])sourceValues.toArray(DBDAttributeValue[]::new), (DBDAttributeValue[])targetValues.toArray(DBDAttributeValue[]::new));
            }
            catch (SQLException e) {
                throw new DBException("Error reading from result set", (Throwable)e);
            }
        }

        @Override
        public void close() {
            this.statement.close();
        }
    }
}

