/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.splittable;

import liquibase.change.DatabaseChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.ext.ora.AbstractOracleChange;
import liquibase.ext.ora.splittable.SplitTableStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="splitTable", description="Split table", priority=201)
public class SplitTableChange
extends AbstractOracleChange {
    private String splitTableName;
    private String splitTableSchemaName;
    private String newTableName;
    private String newTableSchemaName;
    private String columnNameList;
    private String primaryKeyColumnName;

    public String getSplitTableName() {
        return this.splitTableName;
    }

    public void setSplitTableName(String splitTableName) {
        this.splitTableName = splitTableName;
    }

    public String getSplitTableSchemaName() {
        return this.splitTableSchemaName;
    }

    public void setSplitTableSchemaName(String splitTableSchemaName) {
        this.splitTableSchemaName = splitTableSchemaName;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public void setNewTableName(String newTableName) {
        this.newTableName = newTableName;
    }

    public String getNewTableSchemaName() {
        return this.newTableSchemaName;
    }

    public void setNewTableSchemaName(String newTableSchemaName) {
        this.newTableSchemaName = newTableSchemaName;
    }

    public String getColumnNameList() {
        return this.columnNameList;
    }

    public void setColumnNameList(String columnNameList) {
        this.columnNameList = columnNameList;
    }

    public String getPrimaryKeyColumnName() {
        return this.primaryKeyColumnName;
    }

    public void setPrimaryKeyColumnName(String primaryKeyColumnName) {
        this.primaryKeyColumnName = primaryKeyColumnName;
    }

    public SqlStatement[] generateStatements(Database database) {
        String splitTableSchemaName = this.getSplitTableSchemaName() == null ? database.getDefaultSchemaName() : this.getSplitTableSchemaName();
        String newTableSchemaName = this.getNewTableSchemaName() == null ? database.getDefaultSchemaName() : this.getNewTableSchemaName();
        SplitTableStatement statement = new SplitTableStatement(this.getSplitTableName(), splitTableSchemaName, this.getNewTableName(), newTableSchemaName, this.getRefactoringLevel());
        statement.setColumnNameList(this.getColumnNameList());
        statement.setPrimaryKeyColumnName(this.getPrimaryKeyColumnName());
        return new SqlStatement[]{statement};
    }

    public String getRefactoringLevel() {
        String level = null;
        ChangeSet changeSet = this.getChangeSet();
        level = changeSet != null && changeSet.getContexts() != null ? (super.getChangeSet().getContexts().toString().contains("TRANSITION".toLowerCase()) ? "TRANSITION" : (super.getChangeSet().getContexts().toString().contains("RESULTING".toLowerCase()) ? "RESULTING" : "BASIC")) : "BASIC";
        return level;
    }

    public String getConfirmationMessage() {
        return this.getSplitTableName() + " splitted. Created new table " + this.getNewTableName();
    }
}

