/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.settransaction;

import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.AbstractOracleChange;
import liquibase.ext.ora.settransaction.SetTransactionStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="setTransaction", description="Set Transaction", priority=201)
public class SetTransactionChange
extends AbstractOracleChange {
    private String transactionName;
    private String rollbackSegment;
    private String isolationLevel;
    private String readOnlyWrite;

    public String getTransactionName() {
        return this.transactionName;
    }

    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }

    public String getRollbackSegment() {
        return this.rollbackSegment;
    }

    public void setRollbackSegment(String rollbackSegment) {
        this.rollbackSegment = rollbackSegment;
    }

    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(String isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public String getReadOnlyWrite() {
        return this.readOnlyWrite;
    }

    public void setReadOnlyWrite(String readOnlyWrite) {
        this.readOnlyWrite = readOnlyWrite;
    }

    public String getConfirmationMessage() {
        return "Transaction has been set";
    }

    public SqlStatement[] generateStatements(Database database) {
        SetTransactionStatement statement = new SetTransactionStatement(this.getTransactionName(), this.getIsolationLevel(), this.getRollbackSegment(), this.getReadOnlyWrite());
        return new SqlStatement[]{statement};
    }
}

