/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.DeploymentIdFilter;
import com.datical.liquibase.ext.command.AbstractRollbackOneCommand;
import com.datical.liquibase.ext.command.ProTagCommandStep;
import com.datical.liquibase.ext.command.RollbackReportGenerator;
import com.datical.liquibase.ext.command.helpers.ReportCommandArguments;
import com.datical.liquibase.ext.reports.ReportArguments;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.AbstractChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.DefaultChangeExecListener;
import liquibase.changelog.visitor.RollbackVisitor;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.TagCommandStep;
import liquibase.command.core.helpers.DatabaseChangelogCommandStep;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockService;
import liquibase.logging.Logger;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.MdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsRolledback;
import liquibase.logging.mdc.customobjects.ExceptionDetails;
import liquibase.report.RollbackReportParameters;
import liquibase.util.StringUtil;

public class RollbackOneUpdateCommandStep
extends AbstractRollbackOneCommand {
    public static final String[] COMMAND_NAME = new String[]{"rollbackOneUpdate"};
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    public static final CommandArgumentDefinition<String> DEPLOYMENT_ID_ARG;
    public static CommandArgumentDefinition<Boolean> FORCE_ARG;
    public static final CommandArgumentDefinition<String> ROLLBACK_SCRIPT_ARG;
    public static final CommandArgumentDefinition<Boolean> SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Rollback one update from the database"));
    }

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(Database.class, LockService.class, DatabaseChangeLog.class, ChangeExecListener.class, ChangeLogParameters.class, ReportCommandArguments.class);
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        RollbackReportParameters rollbackReportParameters = new RollbackReportParameters();
        rollbackReportParameters.setCommandTitle(StringUtil.upperCaseFirst((String)Arrays.toString(this.defineCommandNames()[0]).replace("[", "").replace("]", "").replace("rollback", "rollback ").trim()));
        resultsBuilder.addResult("rollbackReport", (Object)rollbackReportParameters);
        Database database = (Database)resultsBuilder.getCommandScope().getDependency(Database.class);
        try {
            this.doRun(resultsBuilder, rollbackReportParameters);
        }
        catch (Exception exception) {
            rollbackReportParameters.getOperationInfo().setOperationOutcome("fail");
            rollbackReportParameters.getOperationInfo().setOperationOutcomeErrorMsg(exception.getMessage());
            ExceptionDetails exceptionDetails = new ExceptionDetails((Throwable)exception, ExceptionDetails.findSource((Database)database));
            rollbackReportParameters.setRollbackException(exceptionDetails);
            rollbackReportParameters.setSuccess(Boolean.valueOf(false));
            throw exception;
        }
        finally {
            CommandScope commandScope = resultsBuilder.getCommandScope();
            ReportArguments reportArguments = (ReportArguments)commandScope.getDependency(ReportCommandArguments.class);
            new RollbackReportGenerator().run(resultsBuilder, reportArguments);
        }
    }

    private void doRun(CommandResultsBuilder resultsBuilder, RollbackReportParameters rollbackReportParameters) throws Exception {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Boolean force = (Boolean)commandScope.getArgumentValue(FORCE_ARG);
        String rollbackScript = (String)commandScope.getArgumentValue(ROLLBACK_SCRIPT_ARG);
        ChangeLogParameters changeLogParameters = (ChangeLogParameters)commandScope.getDependency(ChangeLogParameters.class);
        DatabaseChangeLog databaseChangeLog = (DatabaseChangeLog)commandScope.getDependency(DatabaseChangeLog.class);
        Database database = (Database)commandScope.getDependency(Database.class);
        rollbackReportParameters.getDatabaseInfo().setDatabaseType(database.getDatabaseProductName());
        rollbackReportParameters.getDatabaseInfo().setVersion(database.getDatabaseProductVersion());
        rollbackReportParameters.getDatabaseInfo().setDatabaseUrl(database.getConnection().getURL());
        rollbackReportParameters.setJdbcUrl(database.getConnection().getURL());
        String changelogFile = (String)commandScope.getArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_FILE_ARG);
        rollbackReportParameters.setChangelogArgValue(changelogFile);
        Contexts contexts = changeLogParameters.getContexts();
        LabelExpression labelExpression = changeLogParameters.getLabels();
        ChangeExecListener changeExecListener = (ChangeExecListener)commandScope.getDependency(ChangeExecListener.class);
        List ranChangeSetList = database.getRanChangeSetList();
        boolean shouldLogMdcChangesetsRolledBack = (Boolean)commandScope.getArgumentValue(SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK);
        String deploymentId = (String)commandScope.getArgumentValue(DEPLOYMENT_ID_ARG);
        if (force == null || !force.booleanValue()) {
            String messageString = "\nWARNING: Targeted rollback of this update may result in unexpected outcomes.  To review the rollback\nSQL before executing it, please run 'rollback-one-update-sql'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException(messageString, Level.WARNING);
        }
        Scope.getCurrentScope().addMdcValue("rollbackScript", rollbackScript);
        Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", JdbcConnection.sanitizeUrl((String)database.getConnection().getURL()));
        Scope.getCurrentScope().addMdcValue("rollbackOneUpdateForce", String.valueOf(force));
        if (deploymentId == null) {
            deploymentId = this.findLatestDeploymentId(database);
            Scope.getCurrentScope().getUI().sendMessage("Defaulting to last deployment ID '" + deploymentId + "'");
        } else {
            this.validateDeploymentId(deploymentId, ranChangeSetList, rollbackReportParameters);
        }
        rollbackReportParameters.setDeploymentId(deploymentId);
        Scope.getCurrentScope().addMdcValue("deploymentId", deploymentId);
        DeploymentIdFilter deploymentIdFilter = new DeploymentIdFilter(deploymentId, database, ranChangeSetList, databaseChangeLog, COMMAND_NAME[0]);
        ChangeLogIterator runChangeLogIterator = this.createChangeLogIterator(ranChangeSetList, deploymentIdFilter, databaseChangeLog, contexts, labelExpression, database);
        List<RanChangeSet> tagChangeSets = RollbackOneUpdateCommandStep.getTagChangeSets(deploymentId, ranChangeSetList, database);
        try {
            databaseChangeLog.validate(database, contexts, labelExpression);
            ArrayList<ChangeSet> processedChangesets = new ArrayList<ChangeSet>();
            if (rollbackScript == null) {
                this.validateDeploymentIdFilter(deploymentId, deploymentIdFilter);
                runChangeLogIterator.run((ChangeSetVisitor)this.createRollbackVisitor(processedChangesets, database, changeExecListener), new RuntimeEnvironment(database, contexts, labelExpression));
            } else {
                this.executeRollbackScript(rollbackScript, deploymentId, contexts, labelExpression, databaseChangeLog, processedChangesets, runChangeLogIterator, changeLogParameters, database, changeExecListener);
                this.removeRunStatus(runChangeLogIterator, contexts, labelExpression, database);
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executed rollback script " + rollbackScript);
            }
            RollbackOneUpdateCommandStep.removeTagsFromDBCL(tagChangeSets, database);
            try (MdcObject deploymentOutcomeMdc = Scope.getCurrentScope().getMdcManager().put("deploymentOutcome", "success");){
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command completed successfully.");
            }
            if (shouldLogMdcChangesetsRolledBack) {
                Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)ChangesetsRolledback.fromChangesetList(processedChangesets), false);
            }
            this.logSuccess(databaseChangeLog, rollbackReportParameters);
            rollbackReportParameters.getChangesetInfo().setChangesetCount(processedChangesets.size());
            rollbackReportParameters.getChangesetInfo().addAllToChangesetInfoList(processedChangesets, true);
            resultsBuilder.addResult("processedChangesets", processedChangesets);
            resultsBuilder.addResult("statusCode", (Object)0);
        }
        catch (LiquibaseException exception) {
            resultsBuilder.addResult("statusCode", (Object)1);
            rollbackReportParameters.setSuccess(Boolean.valueOf(false));
            this.setRollbackReportException(rollbackReportParameters, (Exception)((Object)exception), database);
            if (changeExecListener instanceof DefaultChangeExecListener) {
                DefaultChangeExecListener defaultListener = (DefaultChangeExecListener)changeExecListener;
                List failedChangeSets = defaultListener.getFailedRollbackChangeSets();
                List rolledBackChangeSets = defaultListener.getRolledBackChangeSets();
                List pendingChangeSets = runChangeLogIterator.getSkippedDueToExceptionChangeSets();
                HashMap pendingChangeSetMap = new HashMap();
                pendingChangeSets.forEach(changeSet -> pendingChangeSetMap.put(changeSet, "Unexpected error running Liquibase."));
                rollbackReportParameters.getChangesetInfo().setChangesetCount(failedChangeSets.size() + rolledBackChangeSets.size());
                rollbackReportParameters.getChangesetInfo().addAllToChangesetInfoList(rolledBackChangeSets, true);
                rollbackReportParameters.getChangesetInfo().addAllToChangesetInfoList(failedChangeSets, true);
                rollbackReportParameters.getChangesetInfo().setFailedChangesetCount(failedChangeSets.size());
                rollbackReportParameters.getChangesetInfo().addAllToPendingChangesetInfoList(pendingChangeSetMap);
                rollbackReportParameters.setFailedChangeset(failedChangeSets.stream().map(ChangeSet::toString).collect(Collectors.joining(", ")));
            }
            this.handleRollbackError((Exception)((Object)exception), deploymentId, changeExecListener, databaseChangeLog, database, rollbackReportParameters);
        }
        Scope.getCurrentScope().getUI().sendMessage("rollback-one-update executed for " + database.getConnection().getConnectionUserName() + "@" + database.getConnection().getURL());
    }

    private static void removeTagsFromDBCL(List<RanChangeSet> tagChangeSets, Database database) throws DatabaseException {
        for (RanChangeSet ranChangeSet : tagChangeSets) {
            ChangeSet changeSet = new ChangeSet(ranChangeSet.getId(), ranChangeSet.getAuthor(), false, false, ranChangeSet.getChangeLog(), null, null, "jdbc", null, true, database.getObjectQuotingStrategy(), null);
            Scope.getCurrentScope().getUI().sendMessage(String.format("Removing tag: %s", ranChangeSet.getTag()));
            database.removeRanStatus(changeSet);
        }
    }

    private static List<RanChangeSet> getTagChangeSets(String deploymentId, List<RanChangeSet> ranChangeSetList, Database database) {
        return ranChangeSetList.stream().filter(ranChangeSet -> ranChangeSet.getDeploymentId().equalsIgnoreCase(deploymentId) && RollbackOneUpdateCommandStep.matchesTagChange(ranChangeSet, database)).collect(Collectors.toList());
    }

    public String findLatestDeploymentId(Database database) throws LiquibaseException {
        String deploymentId = ((AbstractChangeLogHistoryService)ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database)).getLastDeploymentId();
        if (deploymentId == null) {
            throw new LiquibaseException(String.format(coreBundle.getString("no.deployment.ids.found"), new Object[0]));
        }
        return deploymentId;
    }

    private void validateDeploymentId(String deploymentId, List<RanChangeSet> ranChangeSetList, RollbackReportParameters reportParameters) throws LiquibaseException {
        boolean found = false;
        for (RanChangeSet ranChangeSet : ranChangeSetList) {
            if (!deploymentId.equals(ranChangeSet.getDeploymentId())) continue;
            found = true;
            break;
        }
        if (!found) {
            String message = String.format(coreBundle.getString("no.change.sets.found.for.deployment.id"), deploymentId);
            LiquibaseException exception = new LiquibaseException("\n" + message);
            this.setRollbackReportException(reportParameters, (Exception)((Object)exception), null);
            reportParameters.setSuccess(Boolean.valueOf(false));
            throw exception;
        }
    }

    private void validateDeploymentIdFilter(String deploymentId, DeploymentIdFilter deploymentIdFilter) throws LiquibaseException {
        if (!deploymentIdFilter.getNoInverseChangeSets().isEmpty()) {
            String warningMessage = "\n\nThere are changesets associated with the deployment ID '" + deploymentId + "' which cannot be rolled back.\nNo rollback was performed.\n";
            warningMessage = warningMessage + "\nChangesets which cannot be rolled back:\n";
            Map<String, ChangeSet> noInverseChangeSets = deploymentIdFilter.getNoInverseChangeSets();
            for (Map.Entry<String, ChangeSet> entry : noInverseChangeSets.entrySet()) {
                warningMessage = warningMessage + entry.getKey();
                warningMessage = warningMessage + "\n";
            }
            throw new LiquibaseException("\n" + warningMessage);
        }
        if (deploymentIdFilter.isEmpty()) {
            String warningMessage = "\n\nThere are no changesets associated with the deployment ID '" + deploymentId + "'.\nPlease check your parameters.  No rollback was performed.\n";
            throw new LiquibaseException("\n" + warningMessage);
        }
    }

    private void handleRollbackError(Exception exception, String deploymentId, ChangeExecListener changeExecListener, DatabaseChangeLog databaseChangeLog, Database database, RollbackReportParameters rollbackReportParameters) throws LiquibaseException {
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        Throwable t = exception.getCause();
        try (MdcObject deploymentOutcomeMdc = Scope.getCurrentScope().addMdcValue("deploymentOutcome", "fail");){
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command encountered an exception.");
        }
        rollbackReportParameters.getOperationInfo().setOperationOutcome("fail");
        if (t instanceof RollbackImpossibleException) {
            String message = "\nError executing rollback:\nThe rollback for deployment ID '" + deploymentId + "' has at least one changeset without a rollback defined\nPlease add a rollback change in the appropriate changeset.\n";
            log.severe(message, (Throwable)exception);
            if (changeExecListener != null) {
                changeExecListener.runFailed(null, databaseChangeLog, database, exception);
            }
            throw new LiquibaseException(message, (Throwable)exception);
        }
        log.severe("\nError executing rollback for the deployment ID '" + deploymentId + "'.");
        throw new LiquibaseException("\nError executing rollback for the deployment ID '" + deploymentId + "':\n" + exception.getMessage(), (Throwable)exception);
    }

    private void executeRollbackScript(String rollbackScript, String deploymentId, Contexts contexts, LabelExpression labels, DatabaseChangeLog changeLog, List<ChangeSet> processedChangesets, ChangeLogIterator deploymentIdIterator, ChangeLogParameters changeLogParameters, Database database, ChangeExecListener changeExecListener) throws LiquibaseException {
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        String rollbackScriptContents = this.getRollbackScriptContents(rollbackScript, executor.toString(), changeLogParameters, changeLog);
        RawSQLChange rollbackChange = this.buildRawSQLChange(rollbackScriptContents);
        try {
            this.updateListener(deploymentIdIterator, contexts, labels, database, changeExecListener, processedChangesets, ListenerStatus.WILL_ROLLBACK, null);
            Scope.getCurrentScope().getUI().sendMessage("Rolling back deploymentId: " + deploymentId);
            executor.execute((Change)rollbackChange);
            this.updateListener(deploymentIdIterator, contexts, labels, database, changeExecListener, processedChangesets, ListenerStatus.ROLLED_BACK, null);
        }
        catch (DatabaseException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Error executing rollback script: " + e.getMessage());
            this.updateListener(deploymentIdIterator, contexts, labels, database, changeExecListener, processedChangesets, ListenerStatus.ROLLBACK_FAILED, (Exception)((Object)e));
            throw new LiquibaseException("\nError executing rollback for the deploymentId '" + deploymentId + "':\n" + e.getMessage(), (Throwable)e);
        }
        database.commit();
        if (rollbackScriptContents.length() == 0) {
            Scope.getCurrentScope().getUI().sendMessage("No rollback logic defined in empty rollback script. Changesets have been removed from the DATABASECHANGELOG table but no other logic was performed.");
        }
    }

    private void updateListener(ChangeLogIterator changeLogIterator, Contexts contexts, LabelExpression labelExpression, Database database, final ChangeExecListener listener, final List<ChangeSet> processedChangeSets, final ListenerStatus status, final Exception exception) throws LiquibaseException {
        changeLogIterator.run((ChangeSetVisitor)new RollbackVisitor(database, listener, processedChangeSets){

            public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> filterResults) throws LiquibaseException {
                if (listener != null) {
                    switch (status) {
                        case ROLLED_BACK: {
                            processedChangeSets.add(changeSet);
                            listener.rolledBack(changeSet, databaseChangeLog, database);
                            break;
                        }
                        case WILL_ROLLBACK: {
                            listener.willRollback(changeSet, databaseChangeLog, database);
                            break;
                        }
                        case ROLLBACK_FAILED: {
                            listener.rollbackFailed(changeSet, databaseChangeLog, database, exception);
                        }
                    }
                }
            }
        }, new RuntimeEnvironment(database, contexts, labelExpression));
    }

    public static boolean matchesTagChange(RanChangeSet ranChangeSet, Database database) {
        if (ranChangeSet.getTag() != null && RollbackOneUpdateCommandStep.looksLikeGeneratedId(ranChangeSet.getId())) {
            ChangeSet tagCommandChange = TagCommandStep.getEmptyTagChangeSet((Database)database);
            if (ranChangeSet.getChangeLog().equalsIgnoreCase(tagCommandChange.getFilePath()) && ranChangeSet.getAuthor().equalsIgnoreCase(tagCommandChange.getAuthor())) {
                return true;
            }
            ChangeSet proTagCommandChange = ProTagCommandStep.getEmptyTagChangeSet();
            if (ranChangeSet.getChangeLog().equalsIgnoreCase(proTagCommandChange.getFilePath()) && ranChangeSet.getAuthor().equalsIgnoreCase(proTagCommandChange.getAuthor())) {
                return true;
            }
        }
        return false;
    }

    public static boolean looksLikeGeneratedId(String id) {
        if (id.startsWith("liquibasetagcommand-")) {
            return true;
        }
        try {
            long epoch = Long.parseLong(id);
            Instant instant = Instant.ofEpochSecond(epoch);
            return instant != null;
        }
        catch (NumberFormatException | DateTimeParseException e) {
            return false;
        }
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        DEPLOYMENT_ID_ARG = builder.argument("deploymentId", String.class).description("The deployment ID of the update to rollback").build();
        FORCE_ARG = builder.argument("force", Boolean.class).description("A required safety flag to indicate you intend to use this feature").defaultValue((Object)false).build();
        ROLLBACK_SCRIPT_ARG = builder.argument("rollbackScript", String.class).description("The path to the script to use to perform the rollback").build();
        SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK = builder.argument("shouldLogMdcChangesetsRolledBack", Boolean.class).hidden().defaultValue((Object)true).build();
    }

    private static enum ListenerStatus {
        WILL_ROLLBACK,
        ROLLED_BACK,
        ROLLBACK_FAILED;

    }
}

