/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.type;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.statement.compositetype.RenameCompositeTypeStatement;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.license.pro.LicenseTier;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="renameCompositeType", description="alter Composite Type to change its name", priority=5)
public class RenameCompositeTypeChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String oldTypeName;
    private String newTypeName;

    public boolean supports(Database database) {
        return database instanceof PostgresDatabase;
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors errors = LicenseValidationChange.checkForValidLicense(LicenseTier.PRO, (Change)this);
        if (errors.hasErrors()) {
            return errors;
        }
        return super.validate(database);
    }

    public String getConfirmationMessage() {
        return "Composite Type '" + this.oldTypeName + "' renamed to '" + this.newTypeName + "'.";
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new RenameCompositeTypeStatement(this.catalogName, this.schemaName, this.oldTypeName, this.newTypeName)};
    }

    protected Change[] createInverses() {
        RenameCompositeTypeChange inverse = new RenameCompositeTypeChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setCatalogName(this.getCatalogName());
        inverse.setOldTypeName(this.getNewTypeName());
        inverse.setNewTypeName(this.getOldTypeName());
        return new Change[]{inverse};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setOldTypeName(String oldTypeName) {
        this.oldTypeName = oldTypeName;
    }

    @Generated
    public void setNewTypeName(String newTypeName) {
        this.newTypeName = newTypeName;
    }

    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getOldTypeName() {
        return this.oldTypeName;
    }

    @Generated
    public String getNewTypeName() {
        return this.newTypeName;
    }
}

