/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.type;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.statement.compositetype.DropCompositeTypeStatement;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.license.pro.LicenseTier;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="dropCompositeType", description="Drop existing Composite Type", priority=5)
public class DropCompositeTypeChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String typeName;
    private Boolean ifExists;
    private String onDelete;

    public boolean supports(Database database) {
        return database instanceof PostgresDatabase;
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors errors = LicenseValidationChange.checkForValidLicense(LicenseTier.PRO, (Change)this);
        if (errors.hasErrors()) {
            return errors;
        }
        return super.validate(database);
    }

    public String getConfirmationMessage() {
        return "Composite type '" + this.typeName + "' successfully dropped.";
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new DropCompositeTypeStatement(this.catalogName, this.schemaName, this.typeName, this.ifExists, this.onDelete)};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    public void setIfExists(Boolean ifExists) {
        this.ifExists = ifExists;
    }

    @Generated
    public void setOnDelete(String onDelete) {
        this.onDelete = onDelete;
    }

    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public Boolean getIfExists() {
        return this.ifExists;
    }

    @Generated
    public String getOnDelete() {
        return this.onDelete;
    }
}

