/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.ui.config;

import com.dbeaver.db.teradata.model.TeradataRole;
import com.dbeaver.db.teradata.ui.TeradataMessages;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class TeradataRoleConfigurator
implements DBEObjectConfigurator<TeradataRole> {
    public TeradataRole configureObject(@NotNull DBRProgressMonitor monitor, @Nullable DBECommandContext commandContext, @Nullable Object container, final @NotNull TeradataRole role, @NotNull Map<String, Object> options) {
        return (TeradataRole)new UITask<TeradataRole>(){

            protected TeradataRole runTask() {
                CreateRoleDialog dialog = new CreateRoleDialog(UIUtils.getActiveWorkbenchShell());
                if (dialog.open() != 0) {
                    return null;
                }
                role.setName(dialog.getName());
                role.setExternal(dialog.isExternal());
                return role;
            }
        }.execute();
    }

    class CreateRoleDialog
    extends BaseDialog {
        private String name;
        private boolean isExternal;

        CreateRoleDialog(Shell parentShell) {
            super(parentShell, TeradataMessages.role_configurator_dialog_title, null);
        }

        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            Text nameText = UIUtils.createLabelText((Composite)composite, (String)TeradataMessages.role_configurator_text_name, (String)"");
            nameText.addModifyListener(e -> {
                this.name = nameText.getText().trim();
                Button okButton = this.getButton(0);
                if (okButton != null && !okButton.isDisposed()) {
                    okButton.setEnabled(!this.name.isEmpty());
                }
            });
            final Button isExternalButton = UIUtils.createCheckbox((Composite)composite, (String)TeradataMessages.role_configurator_button_external, (String)TeradataMessages.role_configurator_button_external_tip, (boolean)false, (int)2);
            isExternalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CreateRoleDialog.this.isExternal = isExternalButton.getSelection();
                }
            });
            return composite;
        }

        String getName() {
            return this.name;
        }

        boolean isExternal() {
            return this.isExternal;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            Button okButton = this.getButton(0);
            if (okButton != null && !okButton.isDisposed()) {
                okButton.setEnabled(false);
            }
        }
    }
}

