/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.chart.ui.resultset;

import com.dbeaver.ee.chart.model.ChartMeasurement;
import com.dbeaver.ee.chart.model.ChartType;
import com.dbeaver.ee.chart.ui.resultset.ResultsChartConfigDialog;
import com.dbeaver.ee.chart.ui.resultset.ResultsChartPresentation;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.charts.BaseChartComposite;

public class ResultsChartComposite
extends BaseChartComposite {
    private ResultsChartPresentation presentation;

    public ResultsChartComposite(ResultsChartPresentation presentation, Composite comp, int style) {
        super(comp, style, new Point(680, 420));
        this.presentation = presentation;
    }

    protected void fillContextMenu(@NotNull IMenuManager manager) {
        List<ChartMeasurement> measurements = this.presentation.getMeasurements();
        if (measurements.size() == 1) {
            ChartMeasurement measurement = measurements.get(0);
            MenuManager viewManager = new MenuManager("View as");
            viewManager.setRemoveAllWhenShown(true);
            viewManager.addMenuListener(e -> {
                ChartType[] chartTypeArray = ChartType.values();
                int n = chartTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ChartType type = chartTypeArray[n2];
                    e.add((IAction)new ChangeChartTypeAction(measurement, type));
                    ++n2;
                }
            });
            manager.add((IContributionItem)viewManager);
            manager.add((IContributionItem)new Separator());
        }
        super.fillContextMenu(manager);
    }

    protected boolean showChartConfigDialog() {
        ResultsChartConfigDialog dialog = new ResultsChartConfigDialog(this.presentation);
        return dialog.open() == 0;
    }

    private class ChangeChartTypeAction
    extends Action {
        private final ChartMeasurement measurement;
        private final ChartType type;

        public ChangeChartTypeAction(@NotNull ChartMeasurement measurement, ChartType type) {
            super(type.getLabel(), 8);
            this.measurement = measurement;
            this.type = type;
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)type.getIcon()));
            this.setChecked(measurement.getChartType() == type);
        }

        public void run() {
            this.measurement.setChartType(this.type);
            ResultsChartComposite.this.presentation.setMeasurements(List.of(this.measurement));
            ResultsChartComposite.this.presentation.refreshData(false, false, false);
        }
    }
}

