/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.odbc.bridge.util;

import com.dbeaver.jdbc.odbc.bridge.OdbcHandle;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Pointer;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import java.util.function.Function;
import org.jkiss.code.NotNull;

public class OdbcTypeMapper
implements TypeMapper {
    public static final OdbcTypeMapper INSTANCE = new OdbcTypeMapper();

    public FromNativeConverter getFromNativeConverter(Class<?> javaType) {
        return null;
    }

    public ToNativeConverter getToNativeConverter(Class<?> javaType) {
        if (OdbcHandle.class.isAssignableFrom(javaType)) {
            return new ToNativeAdapter<OdbcHandle, Pointer>(Pointer.class, OdbcHandle::getPointer);
        }
        if (OdbcHandle.Type.class.isAssignableFrom(javaType)) {
            return new ToNativeAdapter<OdbcHandle.Type, Short>(Short.TYPE, OdbcHandle.Type::getValue);
        }
        if (String.class.isAssignableFrom(javaType)) {
            return new ToNativeAdapter<String, WString>(WString.class, WString::new);
        }
        return null;
    }

    private static class ToNativeAdapter<IN, OUT>
    implements ToNativeConverter {
        private final Class<OUT> type;
        private final Function<IN, OUT> mapper;

        public ToNativeAdapter(@NotNull Class<OUT> type, @NotNull Function<IN, OUT> mapper) {
            this.type = type;
            this.mapper = mapper;
        }

        public Object toNative(Object value, ToNativeContext context) {
            if (value == null) {
                return null;
            }
            return this.mapper.apply(value);
        }

        public Class<?> nativeType() {
            return this.type;
        }
    }
}

