/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.debug.internal.impl;

import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.debug.DBGBaseController;
import org.jkiss.dbeaver.debug.DBGBreakpointDescriptor;
import org.jkiss.dbeaver.debug.DBGException;
import org.jkiss.dbeaver.ext.postgresql.debug.internal.impl.PostgreDebugBreakpointDescriptor;
import org.jkiss.dbeaver.ext.postgresql.debug.internal.impl.PostgreDebugSession;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PostgreDebugController
extends DBGBaseController {
    private static final Log log = Log.getLog(PostgreDebugController.class);

    public PostgreDebugController(DBPDataSourceContainer dataSourceContainer, Map<String, Object> configuration) {
        super(dataSourceContainer, configuration);
    }

    public PostgreDebugSession createSession(DBRProgressMonitor monitor, Map<String, Object> configuration) throws DBGException {
        PostgreDebugSession pgSession = null;
        try {
            log.debug((Object)"Creating debug session");
            pgSession = new PostgreDebugSession(monitor, this);
            log.debug((Object)"Attaching debug session");
            pgSession.attach(monitor, configuration);
            log.debug((Object)"Debug session created");
            return pgSession;
        }
        catch (DBException e) {
            if (pgSession != null) {
                try {
                    pgSession.closeSession(monitor);
                }
                catch (Exception e1) {
                    log.error((Object)e1);
                }
            }
            if (e instanceof DBGException) {
                throw (DBGException)e;
            }
            log.debug((Object)String.format("Error attaching debug session %s", e.getMessage()));
            throw new DBGException("Error attaching debug session", (Throwable)e);
        }
    }

    public DBGBreakpointDescriptor describeBreakpoint(Map<String, Object> attributes) {
        return PostgreDebugBreakpointDescriptor.fromMap(attributes);
    }
}

