/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.bigquery.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import liquibase.CatalogAndSchema;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.configuration.ConfiguredValue;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.ext.bigquery.database.BigQueryConnection;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.GetViewDefinitionStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Sequence;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;

public class BigQueryDatabase
extends AbstractJdbcDatabase {
    public static final String PRODUCT_NAME = "Google BigQuery";
    public static final int BIGQUERY_PRIORITY_DATABASE = 510;
    private String liquibaseSchemaName;
    private static final Pattern CREATE_VIEW_AS_PATTERN = Pattern.compile("^CREATE\\s+.*?VIEW\\s+.*?AS\\s+", 34);

    public BigQueryDatabase() {
        this.setCurrentDateTimeFunction("CURRENT_DATETIME()");
        this.unquotedObjectsAreUppercased = false;
        this.addReservedWords(this.getDefaultReservedWords());
    }

    public String getShortName() {
        return "bigquery";
    }

    protected String getDefaultDatabaseProductName() {
        return PRODUCT_NAME;
    }

    public Integer getDefaultPort() {
        return 443;
    }

    public int getPriority() {
        return 510;
    }

    public String correctObjectName(String objectName, Class<? extends DatabaseObject> objectType) {
        if (Table.class.isAssignableFrom(objectType) && objectName.equalsIgnoreCase("DATABASECHANGELOGHISTORY")) {
            return "DATABASECHANGELOGHISTORY";
        }
        return super.correctObjectName(objectName, objectType);
    }

    public CatalogAndSchema.CatalogAndSchemaCase getSchemaAndCatalogCase() {
        return CatalogAndSchema.CatalogAndSchemaCase.ORIGINAL_CASE;
    }

    public String escapeStringForDatabase(String string) {
        if (string == null) {
            return null;
        }
        return super.escapeStringForDatabase(string).replace("''", "\\'");
    }

    public String getCurrentDateTimeFunction() {
        return "CURRENT_DATETIME()";
    }

    public String getDatabaseProductVersion() {
        return "1.5";
    }

    public int getDatabaseMajorVersion() {
        return 1;
    }

    public int getDatabaseMinorVersion() {
        return 5;
    }

    protected String getQuotingStartCharacter() {
        return "`";
    }

    protected String getQuotingEndCharacter() {
        return "`";
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.trim().equalsIgnoreCase(conn.getDatabaseProductName().trim());
    }

    public String escapeObjectName(String objectName, Class<? extends DatabaseObject> objectType) {
        if (objectType.equals(Schema.class)) {
            return objectName;
        }
        return super.escapeObjectName(objectName, objectType);
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:bigquery")) {
            return "com.simba.googlebigquery.jdbc.Driver";
        }
        return null;
    }

    public boolean supportsDatabaseChangeLogHistory() {
        return true;
    }

    public boolean supportsSequences() {
        return this.supports(Sequence.class);
    }

    public boolean supportsRestrictForeignKeys() {
        return false;
    }

    public boolean supportsNotNullConstraintNames() {
        return false;
    }

    public boolean supportsPrimaryKeyNames() {
        return false;
    }

    public boolean supports(Class<? extends DatabaseObject> object) {
        if (Sequence.class.isAssignableFrom(object)) {
            return false;
        }
        if (UniqueConstraint.class.isAssignableFrom(object)) {
            return false;
        }
        return super.supports(object);
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public boolean supportsDropTableCascadeConstraints() {
        return false;
    }

    public boolean supportsTablespaces() {
        return false;
    }

    private String getDefaultDataset() {
        DatabaseConnection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return BigQueryConnection.getUrlParamValue(connection.getURL(), "DefaultDataset");
    }

    protected String getConnectionSchemaName() {
        return this.getDefaultDataset();
    }

    public String getLiquibaseSchemaName() {
        if (this.liquibaseSchemaName != null) {
            return this.liquibaseSchemaName;
        }
        ConfiguredValue configuredValue = GlobalConfiguration.LIQUIBASE_SCHEMA_NAME.getCurrentConfiguredValue();
        if (!configuredValue.wasDefaultValueUsed() && configuredValue.getValue() != null) {
            return (String)configuredValue.getValue();
        }
        return this.getDefaultSchemaName();
    }

    public String getDatabaseChangeLogTableName() {
        if (this.getRawDatabaseChangeLogTableName() != null) {
            return this.getRawDatabaseChangeLogTableName();
        }
        return (String)GlobalConfiguration.DATABASECHANGELOG_TABLE_NAME.getCurrentValue();
    }

    public String getDatabaseChangeLogLockTableName() {
        if (this.getRawDatabaseChangeLogLockTableName() != null) {
            return this.getRawDatabaseChangeLogLockTableName();
        }
        return (String)GlobalConfiguration.DATABASECHANGELOGLOCK_TABLE_NAME.getCurrentValue();
    }

    public void setLiquibaseSchemaName(String schemaName) {
        this.liquibaseSchemaName = schemaName;
    }

    public String getJdbcCatalogName(CatalogAndSchema schema) {
        DatabaseConnection connection = this.getConnection();
        try {
            return connection.getCatalog();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getViewDefinition(CatalogAndSchema schema, String viewName) throws DatabaseException {
        schema = schema.customize((Database)this);
        String definition = (String)((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)this).queryForObject((SqlStatement)new GetViewDefinitionStatement(schema.getCatalogName(), schema.getSchemaName(), viewName), String.class);
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("getViewDefinition " + definition);
        return definition == null ? null : CREATE_VIEW_AS_PATTERN.matcher(definition).replaceFirst("");
    }

    public void setAutoCommit(boolean b) {
    }

    public boolean supportsDDLInTransaction() {
        return false;
    }

    private Set<String> getDefaultReservedWords() {
        HashSet<String> reservedWords = new HashSet<String>();
        reservedWords.add("ALL");
        reservedWords.add("AND");
        reservedWords.add("ANY");
        reservedWords.add("ARRAY");
        reservedWords.add("AS");
        reservedWords.add("ASC");
        reservedWords.add("ASSERT_ROWS_MODIFIED");
        reservedWords.add("AT");
        reservedWords.add("BETWEEN");
        reservedWords.add("BY");
        reservedWords.add("CASE");
        reservedWords.add("CAST");
        reservedWords.add("COLLATE");
        reservedWords.add("CONTAINS");
        reservedWords.add("CREATE");
        reservedWords.add("CROSS");
        reservedWords.add("CUBE");
        reservedWords.add("CURRENT");
        reservedWords.add("DEFAULT");
        reservedWords.add("DEFINE");
        reservedWords.add("DESC");
        reservedWords.add("DISTINCT");
        reservedWords.add("ELSE");
        reservedWords.add("END");
        reservedWords.add("ENUM");
        reservedWords.add("ESCAPE");
        reservedWords.add("EXCEPT");
        reservedWords.add("EXCLUDE");
        reservedWords.add("EXISTS");
        reservedWords.add("EXTRACT");
        reservedWords.add("FALSE");
        reservedWords.add("FETCH");
        reservedWords.add("FOLLOWING");
        reservedWords.add("FOR");
        reservedWords.add("FROM");
        reservedWords.add("FULL");
        reservedWords.add("GROUP");
        reservedWords.add("GROUPING");
        reservedWords.add("GROUPS");
        reservedWords.add("HASH");
        reservedWords.add("HAVING");
        reservedWords.add("IF");
        reservedWords.add("IGNORE");
        reservedWords.add("IN");
        reservedWords.add("INNER");
        reservedWords.add("INTERSECT");
        reservedWords.add("INTERVAL");
        reservedWords.add("INTO");
        reservedWords.add("IS");
        reservedWords.add("JOIN");
        reservedWords.add("LATERAL");
        reservedWords.add("LEFT");
        reservedWords.add("LIKE");
        reservedWords.add("LIMIT");
        reservedWords.add("LOOKUP");
        reservedWords.add("MERGE");
        reservedWords.add("NATURAL");
        reservedWords.add("NEW");
        reservedWords.add("NO");
        reservedWords.add("NOT");
        reservedWords.add("NULL");
        reservedWords.add("NULLS");
        reservedWords.add("OF");
        reservedWords.add("ON");
        reservedWords.add("OR");
        reservedWords.add("ORDER");
        reservedWords.add("OUTER");
        reservedWords.add("OVER");
        reservedWords.add("PARTITION");
        reservedWords.add("PRECEDING");
        reservedWords.add("PROTO");
        reservedWords.add("RANGE");
        reservedWords.add("RECURSIVE");
        reservedWords.add("RESPECT");
        reservedWords.add("RIGHT");
        reservedWords.add("ROLLUP");
        reservedWords.add("ROWS");
        reservedWords.add("SELECT");
        reservedWords.add("SET");
        reservedWords.add("SOME");
        reservedWords.add("STRUCT");
        reservedWords.add("TABLESAMPLE");
        reservedWords.add("THEN");
        reservedWords.add("TO");
        reservedWords.add("TREAT");
        reservedWords.add("TRUE");
        reservedWords.add("UNBOUNDED");
        reservedWords.add("UNION");
        reservedWords.add("UNNEST");
        reservedWords.add("USING");
        reservedWords.add("WHEN");
        reservedWords.add("WHERE");
        reservedWords.add("WINDOW");
        reservedWords.add("WITH");
        reservedWords.add("WITHIN");
        return reservedWords;
    }

    public void checkDatabaseConnection() throws DatabaseException {
        BigQueryConnection connection = (BigQueryConnection)this.getConnection();
        try {
            String catalogName = this.getConnectionCatalogName();
            String schemaName = this.getConnectionSchemaName();
            ResultSet schemasAlikeUsed = connection.getMetaData().getSchemas(catalogName, schemaName);
            while (schemasAlikeUsed.next()) {
                if (!schemasAlikeUsed.getString(1).equals(schemaName)) continue;
                return;
            }
            throw new DatabaseException(String.format("Please specify existing dataset in connection url. Current connection points to '%s.%s'", catalogName, schemaName));
        }
        catch (SQLException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Error checking database connection", (Throwable)e);
            return;
        }
    }
}

